/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.Ideal;
import edu.jas.application.Local;
import edu.jas.kern.StringUtil;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.QuotPairFactory;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisor;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public class LocalRing<C extends GcdRingElem<C>>
implements RingFactory<Local<C>>,
QuotPairFactory<GenPolynomial<C>, Local<C>> {
    private static final Logger logger = Logger.getLogger(LocalRing.class);
    protected final GreatestCommonDivisor<C> engine;
    public final Ideal<C> ideal;
    public final GenPolynomialRing<C> ring;
    protected int isField = -1;

    public LocalRing(Ideal<C> i) {
        if (i == null) {
            throw new IllegalArgumentException("ideal may not be null");
        }
        this.ideal = i.GB();
        if (this.ideal.isONE()) {
            throw new IllegalArgumentException("ideal may not be 1");
        }
        if (this.ideal.isMaximal()) {
            this.isField = 1;
        } else {
            this.isField = 0;
            logger.warn((Object)"ideal not maximal");
        }
        this.ring = this.ideal.list.ring;
        this.engine = GCDFactory.getProxy(this.ring.coFac);
    }

    @Override
    public GenPolynomialRing<C> pairFactory() {
        return this.ring;
    }

    @Override
    public Local<C> create(GenPolynomial<C> n) {
        return new Local<C>(this, n);
    }

    @Override
    public Local<C> create(GenPolynomial<C> n, GenPolynomial<C> d) {
        return new Local<C>(this, n, d);
    }

    @Override
    public boolean isFinite() {
        return this.ring.isFinite() && this.ideal.bb.commonZeroTest(this.ideal.getList()) <= 0;
    }

    @Override
    public Local<C> copy(Local<C> c) {
        return new Local(c.ring, c.num, c.den, true);
    }

    @Override
    public Local<C> getZERO() {
        return new Local(this, this.ring.getZERO());
    }

    @Override
    public Local<C> getONE() {
        return new Local(this, this.ring.getONE());
    }

    @Override
    public List<Local<C>> generators() {
        List<GenPolynomial<C>> pgens = this.ring.generators();
        ArrayList<Local<C>> gens = new ArrayList<Local<C>>(pgens.size());
        MonoidElem one = this.ring.getONE();
        for (GenPolynomial<C> p : pgens) {
            Local<C> q = new Local<C>(this, p);
            gens.add(q);
            if (p.isONE() || this.ideal.contains(p)) continue;
            q = new Local<C>(this, one, p);
            gens.add(q);
        }
        return gens;
    }

    @Override
    public boolean isCommutative() {
        return this.ring.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.ring.isAssociative();
    }

    @Override
    public boolean isField() {
        if (this.isField > 0) {
            return true;
        }
        if (this.isField == 0) {
            return false;
        }
        return false;
    }

    @Override
    public BigInteger characteristic() {
        return this.ring.characteristic();
    }

    @Override
    public Local<C> fromInteger(BigInteger a) {
        return new Local(this, this.ring.fromInteger(a));
    }

    @Override
    public Local<C> fromInteger(long a) {
        return new Local(this, this.ring.fromInteger(a));
    }

    public String toString() {
        return "LocalRing[ " + this.ideal.toString() + " ]";
    }

    @Override
    public String toScript() {
        return "LC(" + this.ideal.list.toScript() + ")";
    }

    public boolean equals(Object b) {
        if (!(b instanceof LocalRing)) {
            return false;
        }
        LocalRing a = null;
        try {
            a = (LocalRing)b;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (a == null) {
            return false;
        }
        if (!this.ring.equals(a.ring)) {
            return false;
        }
        return this.ideal.equals(a.ideal);
    }

    public int hashCode() {
        int h = this.ideal.hashCode();
        return h;
    }

    @Override
    public Local<C> random(int n) {
        GenPolynomial s;
        GenPolynomial r = ((GenPolynomial)this.ring.random(n)).monic();
        r = this.ideal.normalform(r);
        do {
            s = ((GenPolynomial)this.ring.random(n)).monic();
        } while ((s = this.ideal.normalform(s)).isZERO());
        return new Local(this, r, s, false);
    }

    public Local<C> random(int k, int l, int d, float q) {
        GenPolynomial<C> s;
        GenPolynomial<C> r = this.ring.random(k, l, d, q).monic();
        r = this.ideal.normalform(r);
        do {
            s = this.ring.random(k, l, d, q).monic();
        } while ((s = this.ideal.normalform(s)).isZERO());
        return new Local<C>(this, r, s, false);
    }

    @Override
    public Local<C> random(int n, Random rnd) {
        GenPolynomial s;
        GenPolynomial r = ((GenPolynomial)this.ring.random(n, rnd)).monic();
        r = this.ideal.normalform(r);
        do {
            s = ((GenPolynomial)this.ring.random(n)).monic();
        } while ((s = this.ideal.normalform(s)).isZERO());
        return new Local(this, r, s, false);
    }

    @Override
    public Local<C> parse(String s) {
        int i = s.indexOf("{");
        if (i >= 0) {
            s = s.substring(i + 1);
        }
        if ((i = s.lastIndexOf("}")) >= 0) {
            s = s.substring(0, i);
        }
        if ((i = s.indexOf("|")) < 0) {
            Element n = this.ring.parse(s);
            return new Local(this, n);
        }
        String s1 = s.substring(0, i);
        String s2 = s.substring(i + 1);
        Element n = this.ring.parse(s1);
        Element d = this.ring.parse(s2);
        return new Local(this, n, d);
    }

    @Override
    public Local<C> parse(Reader r) {
        String s = StringUtil.nextPairedString(r, '{', '}');
        return this.parse(s);
    }
}

