/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.Dimension;
import edu.jas.application.Ideal;
import edu.jas.arith.BigRational;
import edu.jas.gb.GBOptimized;
import edu.jas.gb.GBProxy;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.GroebnerBaseParallel;
import edu.jas.gbufd.GBFactory;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.Element;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.BasicConfigurator;

public class ExamplesGeoTheorems {
    public static void main(String[] args) {
        BasicConfigurator.configure();
        ExamplesGeoTheorems.example10();
        ExamplesGeoTheorems.example11();
        ExamplesGeoTheorems.example12();
        ExamplesGeoTheorems.example13();
        ExamplesGeoTheorems.example14();
        ExamplesGeoTheorems.example15();
        ExamplesGeoTheorems.example16();
        ExamplesGeoTheorems.example17();
        ComputerThreads.terminate();
    }

    public static List<GenPolynomial<BigRational>> getExample() {
        String[] vars = new String[]{"a1", "a2", "b1", "b2", "c1", "c2", "d1", "d2", "e1", "e2", "f1", "f2", "g1", "g2", "h1", "h2", "i1", "i2", "j1", "j2", "z1", "z2", "z3"};
        BigRational br = new BigRational();
        GenPolynomialRing<BigRational> pring = new GenPolynomialRing<BigRational>(br, vars);
        Element e1 = pring.parse("(a1*(b2 - c2) + a2*( - b1 + c1) + b1*c2 - b2*c1)");
        Element e2 = pring.parse("(d1*(e2 - f2) + d2*( - e1 + f1) + e1*f2 - e2*f1)");
        Element e3 = pring.parse("(a1*( - e2 + h2) + a2*(e1 - h1) - e1*h2 + e2*h1)");
        Element e4 = pring.parse("(b1*(d2 - h2) + b2*( - d1 + h1) + d1*h2 - d2*h1)");
        Element e5 = pring.parse("(c1*(d2 - i2) + c2*( - d1 + i1) + d1*i2 - d2*i1)");
        Element e6 = pring.parse("(a1*( - f2 + i2) + a2*(f1 - i1) - f1*i2 + f2*i1)");
        Element e7 = pring.parse("(c1*(e2 - j2) + c2*( - e1 + j1) + e1*j2 - e2*j1)");
        Element e8 = pring.parse("(b1*( - f2 + j2) + b2*(f1 - j1) - f1*j2 + f2*j1)");
        Element e9 = pring.parse("(a1*(b2*z2 - d2*z2) + a2*( - b1*z2 + d1*z2) + b1*d2*z2 - b2*d1*z2 - 1)");
        Element e10 = pring.parse("(a1*(b2*z3 - e2*z3) + a2*( - b1*z3 + e1*z3) + b1*e2*z3 - b2*e1*z3 - 1)");
        Element e11 = pring.parse("(h1*(i2*z1 - j2*z1) + h2*( - i1*z1 + j1*z1) + i1*j2*z1 - i2*j1*z1 - 1)");
        ArrayList<GenPolynomial<BigRational>> cp = new ArrayList<GenPolynomial<BigRational>>(11);
        cp.add((GenPolynomial<BigRational>)e1);
        cp.add((GenPolynomial<BigRational>)e2);
        cp.add((GenPolynomial<BigRational>)e3);
        cp.add((GenPolynomial<BigRational>)e4);
        cp.add((GenPolynomial<BigRational>)e5);
        cp.add((GenPolynomial<BigRational>)e6);
        cp.add((GenPolynomial<BigRational>)e7);
        cp.add((GenPolynomial<BigRational>)e8);
        cp.add((GenPolynomial<BigRational>)e9);
        cp.add((GenPolynomial<BigRational>)e10);
        cp.add((GenPolynomial<BigRational>)e11);
        return cp;
    }

    public static void example10() {
        List cp = ExamplesGeoTheorems.getExample();
        BigRational br = new BigRational();
        GenPolynomialRing pring = cp.get((int)0).ring;
        GroebnerBaseAbstract<BigRational> sgb = GBFactory.getImplementation(br);
        long t = System.currentTimeMillis();
        List gb = sgb.GB(cp);
        t = System.currentTimeMillis() - t;
        System.out.println("time(gb) = " + t);
        t = System.currentTimeMillis();
        gb = sgb.GB(cp);
        t = System.currentTimeMillis() - t;
        System.out.println("time(gb) = " + t);
        PolynomialList pl = new PolynomialList(pring, gb);
        Ideal id = new Ideal(pl, true);
        System.out.println("cp = " + cp);
        System.out.println("id = " + id);
        Dimension dim = id.dimension();
        System.out.println("dim = " + dim);
    }

    public static void example11() {
        List cp = ExamplesGeoTheorems.getExample();
        BigRational br = new BigRational();
        GenPolynomialRing pring = cp.get((int)0).ring;
        GroebnerBaseAbstract<BigRational> sgb = GBFactory.getProxy(br);
        long t = System.currentTimeMillis();
        List gb = sgb.GB(cp);
        t = System.currentTimeMillis() - t;
        System.out.println("time(proxy-gb) = " + t);
        t = System.currentTimeMillis();
        gb = sgb.GB(cp);
        t = System.currentTimeMillis() - t;
        System.out.println("time(proxy-gb) = " + t);
        PolynomialList pl = new PolynomialList(pring, gb);
        Ideal id = new Ideal(pl, true);
        System.out.println("cp = " + cp);
        System.out.println("id = " + id);
        Dimension dim = id.dimension();
        System.out.println("dim = " + dim);
        sgb.terminate();
    }

    public static void example12() {
        List cp = ExamplesGeoTheorems.getExample();
        BigRational br = new BigRational();
        GenPolynomialRing pring = cp.get((int)0).ring;
        GroebnerBaseAbstract<BigRational> sgb = GBFactory.getImplementation(br);
        GBOptimized<BigRational> ogb = new GBOptimized<BigRational>(sgb, true);
        long t = System.currentTimeMillis();
        List gb = ogb.GB(cp);
        t = System.currentTimeMillis() - t;
        System.out.println("time(optimized-gb) = " + t);
        t = System.currentTimeMillis();
        gb = ogb.GB(cp);
        t = System.currentTimeMillis() - t;
        System.out.println("time(optimized-gb) = " + t);
        PolynomialList pl = new PolynomialList(pring, gb);
        Ideal id = new Ideal(pl, true);
        System.out.println("cp = " + cp);
        System.out.println("id = " + id);
        Dimension dim = id.dimension();
        System.out.println("dim = " + dim);
        ((GroebnerBaseAbstract)ogb).terminate();
    }

    public static void example13() {
        List cp = ExamplesGeoTheorems.getExample();
        BigRational br = new BigRational();
        GenPolynomialRing pring = cp.get((int)0).ring;
        GroebnerBaseAbstract<BigRational> sgb = GBFactory.getProxy(br);
        GBOptimized<BigRational> ogb = new GBOptimized<BigRational>(sgb, true);
        long t = System.currentTimeMillis();
        List gb = ogb.GB(cp);
        t = System.currentTimeMillis() - t;
        System.out.println("time(optimized-proxy-gb) = " + t);
        t = System.currentTimeMillis();
        gb = ogb.GB(cp);
        t = System.currentTimeMillis() - t;
        System.out.println("time(optimized-proxy-gb) = " + t);
        PolynomialList pl = new PolynomialList(pring, gb);
        Ideal id = new Ideal(pl, true);
        System.out.println("cp = " + cp);
        System.out.println("id = " + id);
        Dimension dim = id.dimension();
        System.out.println("dim = " + dim);
        ((GroebnerBaseAbstract)ogb).terminate();
    }

    public static void example14() {
        List cp = ExamplesGeoTheorems.getExample();
        BigRational br = new BigRational();
        GenPolynomialRing pring = cp.get((int)0).ring;
        GroebnerBaseAbstract<BigRational> sgb = GBFactory.getImplementation(br, GBFactory.Algo.ffgb);
        long t = System.currentTimeMillis();
        List gb = sgb.GB(cp);
        t = System.currentTimeMillis() - t;
        System.out.println("time(fraction-free-gb) = " + t);
        t = System.currentTimeMillis();
        gb = sgb.GB(cp);
        t = System.currentTimeMillis() - t;
        System.out.println("time(fraction-free-gb) = " + t);
        PolynomialList pl = new PolynomialList(pring, gb);
        Ideal id = new Ideal(pl, true);
        System.out.println("cp = " + cp);
        System.out.println("id = " + id);
        Dimension dim = id.dimension();
        System.out.println("dim = " + dim);
        sgb.terminate();
    }

    public static void example15() {
        List cp = ExamplesGeoTheorems.getExample();
        BigRational br = new BigRational();
        GenPolynomialRing pring = cp.get((int)0).ring;
        GroebnerBaseAbstract<BigRational> sgb = GBFactory.getImplementation(br, GBFactory.Algo.ffgb);
        GBOptimized<BigRational> ogb = new GBOptimized<BigRational>(sgb, true);
        long t = System.currentTimeMillis();
        List gb = ogb.GB(cp);
        t = System.currentTimeMillis() - t;
        System.out.println("time(optimized-fraction-free-gb) = " + t);
        t = System.currentTimeMillis();
        gb = ogb.GB(cp);
        t = System.currentTimeMillis() - t;
        System.out.println("time(optimized-fraction-free-gb) = " + t);
        PolynomialList pl = new PolynomialList(pring, gb);
        Ideal id = new Ideal(pl, true);
        System.out.println("cp = " + cp);
        System.out.println("id = " + id);
        Dimension dim = id.dimension();
        System.out.println("dim = " + dim);
        ((GroebnerBaseAbstract)ogb).terminate();
    }

    public static void example16() {
        List cp = ExamplesGeoTheorems.getExample();
        BigRational br = new BigRational();
        GenPolynomialRing pring = cp.get((int)0).ring;
        GroebnerBaseAbstract<BigRational> sgb = GBFactory.getImplementation(br, GBFactory.Algo.ffgb);
        GBOptimized<BigRational> ogb = new GBOptimized<BigRational>(sgb, true);
        GroebnerBaseParallel pgb = new GroebnerBaseParallel();
        GBOptimized opgb = new GBOptimized(pgb, true);
        GBProxy<BigRational> popgb = new GBProxy<BigRational>(ogb, opgb);
        long t = System.currentTimeMillis();
        List gb = popgb.GB(cp);
        t = System.currentTimeMillis() - t;
        System.out.println("time(proxy-optimized-fraction-free-gb) = " + t);
        t = System.currentTimeMillis();
        gb = popgb.GB(cp);
        t = System.currentTimeMillis() - t;
        System.out.println("time(proxy-optimized-fraction-free-gb) = " + t);
        PolynomialList pl = new PolynomialList(pring, gb);
        Ideal id = new Ideal(pl, true);
        System.out.println("cp = " + cp);
        System.out.println("id = " + id);
        Dimension dim = id.dimension();
        System.out.println("dim = " + dim);
        ((GroebnerBaseAbstract)popgb).terminate();
    }

    public static void example17() {
        List cp = ExamplesGeoTheorems.getExample();
        BigRational br = new BigRational();
        GenPolynomialRing pring = cp.get((int)0).ring;
        GroebnerBaseAbstract<BigRational> sgb = GBFactory.getImplementation(br, GBFactory.Algo.ffgb);
        GroebnerBaseParallel pgb = new GroebnerBaseParallel();
        GBProxy<BigRational> ppgb = new GBProxy<BigRational>(sgb, pgb);
        GBOptimized<BigRational> ogb = new GBOptimized<BigRational>(ppgb, true);
        long t = System.currentTimeMillis();
        List gb = ogb.GB(cp);
        t = System.currentTimeMillis() - t;
        System.out.println("time(optimized-proxy-fraction-free-gb) = " + t);
        t = System.currentTimeMillis();
        gb = ogb.GB(cp);
        t = System.currentTimeMillis() - t;
        System.out.println("time(optimized-proxy-fraction-free-gb) = " + t);
        PolynomialList pl = new PolynomialList(pring, gb);
        Ideal id = new Ideal(pl, true);
        System.out.println("cp = " + cp);
        System.out.println("id = " + id);
        Dimension dim = id.dimension();
        System.out.println("dim = " + dim);
        ((GroebnerBaseAbstract)ogb).terminate();
    }
}

