/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.maths.demo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYSplineRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

class GraphPanel
extends JPanel {
    private final ChartPanel chartPanel = new ChartPanel(null);

    public GraphPanel() {
        super(new BorderLayout());
        this.add((Component)this.chartPanel, "Center");
    }

    public void generateGraph(String title, Map<Double, Double> observedValues, Map<Double, Double> expectedValues, double expectedMean, double expectedStandardDeviation, boolean discrete) {
        XYSeriesCollection dataSet = new XYSeriesCollection();
        XYSeries observedSeries = new XYSeries((Comparable)((Object)"Observed"));
        dataSet.addSeries(observedSeries);
        XYSeries expectedSeries = new XYSeries((Comparable)((Object)"Expected"));
        dataSet.addSeries(expectedSeries);
        for (Map.Entry<Double, Double> entry : observedValues.entrySet()) {
            observedSeries.add((Number)entry.getKey(), (Number)entry.getValue());
        }
        for (Map.Entry<Double, Double> entry : expectedValues.entrySet()) {
            expectedSeries.add((Number)entry.getKey(), (Number)entry.getValue());
        }
        JFreeChart chart = ChartFactory.createXYLineChart((String)title, (String)"Value", (String)"Probability", (XYDataset)dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        XYPlot plot = (XYPlot)chart.getPlot();
        if (discrete) {
            plot.setRenderer((XYItemRenderer)new XYLineAndShapeRenderer());
        } else {
            XYSplineRenderer renderer = new XYSplineRenderer();
            renderer.setBaseShapesVisible(false);
            plot.setRenderer((XYItemRenderer)renderer);
        }
        this.chartPanel.setChart(chart);
    }
}

