/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.maths.demo;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.uncommons.maths.demo.ProbabilityDistribution;
import org.uncommons.maths.random.GaussianGenerator;

class GaussianDistribution
extends ProbabilityDistribution {
    private final double mean;
    private final double standardDeviation;

    public GaussianDistribution(double mean, double standardDeviation) {
        this.mean = mean;
        this.standardDeviation = standardDeviation;
    }

    protected GaussianGenerator createValueGenerator(Random rng) {
        return new GaussianGenerator(this.mean, this.standardDeviation, rng);
    }

    @Override
    public Map<Double, Double> getExpectedValues() {
        double p;
        HashMap<Double, Double> values = new HashMap<Double, Double>();
        double x = 0.0;
        do {
            p = this.getExpectedProbability(this.mean + x);
            values.put(this.mean + x, p);
            values.put(this.mean - x, p);
            x += 3.0 * this.standardDeviation / 10.0;
        } while (p > 0.001);
        return values;
    }

    private double getExpectedProbability(double x) {
        double y = 1.0 / (this.standardDeviation * Math.sqrt(Math.PI * 2));
        double z = -(Math.pow(x - this.mean, 2.0) / (2.0 * Math.pow(this.standardDeviation, 2.0)));
        return y * Math.exp(z);
    }

    @Override
    public double getExpectedMean() {
        return this.mean;
    }

    @Override
    public double getExpectedStandardDeviation() {
        return this.standardDeviation;
    }

    @Override
    public String getDescription() {
        return "Gaussian Distribution (\u03bc = " + this.mean + ", \u03c3 = " + this.standardDeviation + ")";
    }

    @Override
    public boolean isDiscrete() {
        return false;
    }
}

