/*
 * Decompiled with CFR 0.152.
 */
package jplot3d.draw;

import java.awt.Point;
import jplot3d.JSurface;

public class DrawWireframe {
    public static final void run(JSurface sf) {
        float zx;
        float zi;
        boolean printing = sf.printing;
        boolean plotfunc1 = sf.plotfunc1;
        boolean plotfunc2 = sf.plotfunc2;
        boolean isBoxed = sf.isBoxed;
        float lx = 0.0f;
        float ly = 0.0f;
        float lastz = 0.0f;
        Point lastproj = new Point(0, 0);
        sf.projection = new Point(0, 0);
        try {
            zi = sf.model.getZMin();
            zx = sf.model.getZMax();
            if (zi >= zx) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            System.out.println("Error in ranges");
            return;
        }
        int plot_density = sf.model.getDispDivisions();
        int multiple_factor = sf.calc_divisions / plot_density;
        sf.zmin = zi;
        sf.zmax = zx;
        if (!printing) {
            sf.graphics.setColor(sf.getSurfaceColor().getBackgroundColor());
            sf.graphics.fillRect(0, 0, sf.getBounds().width, sf.getBounds().height);
        }
        Thread.yield();
        sf.drawBoxGridsTicksLabels(sf.graphics, false);
        sf.projector.setZRange(sf.zmin, sf.zmax);
        for (int func = 0; func < 2; ++func) {
            float ratio;
            boolean error;
            boolean invalid;
            float z;
            boolean lasterror;
            int i;
            if (func == 0 && !plotfunc1 || func == 1 && !plotfunc2) continue;
            int j = 0;
            int k = 0;
            int counter = 0;
            for (i = 0; i <= sf.calc_divisions; ++i) {
                lasterror = true;
                if (counter == 0) {
                    while (j <= sf.calc_divisions) {
                        Thread.yield();
                        z = sf.vertex[func][k].z;
                        invalid = Float.isNaN(z);
                        if (!invalid) {
                            sf.graphics.setColor(sf.getSurfaceColor().getLineColor(sf.curve, z));
                            if (z < sf.zmin) {
                                error = true;
                                ratio = (sf.zmin - lastz) / (z - lastz);
                                sf.projection = sf.projector.project(ratio * (sf.vertex[func][k].x - lx) + lx, ratio * (sf.vertex[func][k].y - ly) + ly, -10.0f);
                            } else if (z > sf.zmax) {
                                error = true;
                                ratio = (sf.zmax - lastz) / (z - lastz);
                                sf.projection = sf.projector.project(ratio * (sf.vertex[func][k].x - lx) + lx, ratio * (sf.vertex[func][k].y - ly) + ly, 10.0f);
                            } else {
                                error = false;
                                sf.projection = sf.vertex[func][k].projection(sf.projector);
                            }
                            if (lasterror && !error && j != 0) {
                                if (lastz > sf.zmax) {
                                    ratio = (sf.zmax - z) / (lastz - z);
                                    lastproj = sf.projector.project(ratio * (lx - sf.vertex[func][k].x) + sf.vertex[func][k].x, ratio * (ly - sf.vertex[func][k].y) + sf.vertex[func][k].y, 10.0f);
                                } else if (lastz < sf.zmin) {
                                    ratio = (sf.zmin - z) / (lastz - z);
                                    lastproj = sf.projector.project(ratio * (lx - sf.vertex[func][k].x) + sf.vertex[func][k].x, ratio * (ly - sf.vertex[func][k].y) + sf.vertex[func][k].y, -10.0f);
                                }
                            } else {
                                invalid = error && lasterror;
                            }
                        } else {
                            error = true;
                        }
                        if (!invalid && j != 0) {
                            sf.graphics.drawLine(lastproj.x, lastproj.y, sf.projection.x, sf.projection.y);
                        }
                        lastproj = sf.projection;
                        lasterror = error;
                        lx = sf.vertex[func][k].x;
                        ly = sf.vertex[func][k].y;
                        lastz = z;
                        ++j;
                        ++k;
                    }
                } else {
                    k += sf.calc_divisions + 1;
                }
                j = 0;
                counter = (counter + 1) % multiple_factor;
            }
            i = 0;
            j = 0;
            k = 0;
            counter = 0;
            while (j <= sf.calc_divisions) {
                lasterror = true;
                if (counter == 0) {
                    while (i <= sf.calc_divisions) {
                        Thread.yield();
                        z = sf.vertex[func][k].z;
                        invalid = Float.isNaN(z);
                        if (!invalid) {
                            if (z < sf.zmin) {
                                error = true;
                                ratio = (sf.zmin - lastz) / (z - lastz);
                                sf.projection = sf.projector.project(ratio * (sf.vertex[func][k].x - lx) + lx, ratio * (sf.vertex[func][k].y - ly) + ly, -10.0f);
                            } else if (z > sf.zmax) {
                                error = true;
                                ratio = (sf.zmax - lastz) / (z - lastz);
                                sf.projection = sf.projector.project(ratio * (sf.vertex[func][k].x - lx) + lx, ratio * (sf.vertex[func][k].y - ly) + ly, 10.0f);
                            } else {
                                error = false;
                                sf.projection = sf.vertex[func][k].projection(sf.projector);
                            }
                            if (lasterror && !error && i != 0) {
                                if (lastz > sf.zmax) {
                                    ratio = (sf.zmax - z) / (lastz - z);
                                    lastproj = sf.projector.project(ratio * (lx - sf.vertex[func][k].x) + sf.vertex[func][k].x, ratio * (ly - sf.vertex[func][k].y) + sf.vertex[func][k].y, 10.0f);
                                } else if (lastz < sf.zmin) {
                                    ratio = (sf.zmin - z) / (lastz - z);
                                    lastproj = sf.projector.project(ratio * (lx - sf.vertex[func][k].x) + sf.vertex[func][k].x, ratio * (ly - sf.vertex[func][k].y) + sf.vertex[func][k].y, -10.0f);
                                }
                            } else {
                                invalid = error && lasterror;
                            }
                        } else {
                            error = true;
                        }
                        if (!invalid && i != 0) {
                            sf.graphics.drawLine(lastproj.x, lastproj.y, sf.projection.x, sf.projection.y);
                        }
                        lastproj = sf.projection;
                        lasterror = error;
                        lx = sf.vertex[func][k].x;
                        ly = sf.vertex[func][k].y;
                        lastz = z;
                        ++i;
                        k += sf.calc_divisions + 1;
                    }
                }
                i = 0;
                k = ++j;
                counter = (counter + 1) % multiple_factor;
            }
        }
        if (isBoxed) {
            sf.drawBoundingBox();
        }
    }
}

