/*
 * Decompiled with CFR 0.152.
 */
package jplot3d.draw;

import java.awt.Rectangle;
import jplot3d.JSurface;
import jplot3d.SurfaceModel;
import jplot3d.draw.DrawPlain;

public class DrawH2D {
    public static final void run(JSurface sf) {
        float zx;
        float zi;
        boolean printing = sf.printing;
        boolean plotfunc1 = sf.plotfunc1;
        boolean plotfunc2 = sf.plotfunc2;
        float[][] pointsX = sf.model.getPlotter().getPointsX();
        float[][] pointsY = sf.model.getPlotter().getPointsY();
        float[][] pointsZ = sf.model.getPlotter().getPointsZ();
        float stepx = sf.model.getPlotter().getStepX();
        float stepy = sf.model.getPlotter().getStepY();
        float xfactor = sf.model.getPlotter().getFactorX();
        float yfactor = sf.model.getPlotter().getFactorY();
        float zfactor = sf.model.getPlotter().getFactorZ();
        Rectangle comp = sf.getBounds();
        int h = (int)comp.getHeight();
        int w = (int)comp.getWidth();
        try {
            zi = sf.model.getZMin();
            zx = sf.model.getZMax();
            if (zi >= zx) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            return;
        }
        Thread.yield();
        sf.zmin = zi;
        sf.zmax = zx;
        sf.projector.setZRange(sf.zmin, sf.zmax);
        if (pointsX == null || pointsY == null || pointsZ == null) {
            System.out.println("DEBUG: No data available");
            return;
        }
        sf.color_factor = 0.8f / (sf.zmax - sf.zmin);
        if (sf.model.getPlotColor() == SurfaceModel.PlotColor.DUALSHADE) {
            sf.color_factor *= 0.75f;
        }
        if (!printing) {
            sf.graphics.setColor(sf.getSurfaceColor().getBackgroundColor());
            sf.graphics.fillRect(0, 0, w, h);
        }
        sf.drawBoxGridsTicksLabels(sf.graphics, false);
        if (sf.projector == null) {
            return;
        }
        float new_value = sf.projector.getRotationAngle();
        float dx = stepx * xfactor;
        float dy = stepy * yfactor;
        for (int i = 0; i < sf.calc_divisions; ++i) {
            for (int j = 0; j < sf.calc_divisions; ++j) {
                int ii = i;
                int jj = j;
                if (new_value >= 0.0f && new_value < 90.0f) {
                    ii = i;
                    jj = j;
                }
                if (new_value >= 90.0f && new_value < 180.0f) {
                    ii = i;
                    jj = sf.calc_divisions - j - 1;
                }
                if (new_value >= 180.0f && new_value < 270.0f) {
                    ii = sf.calc_divisions - i - 1;
                    jj = sf.calc_divisions - j - 1;
                }
                if (new_value >= 270.0f && new_value <= 360.0f) {
                    ii = sf.calc_divisions - i - 1;
                    jj = j;
                }
                float x1 = pointsX[ii][jj];
                float y1 = pointsY[ii][jj];
                float z1 = pointsZ[ii][jj] * zfactor - 10.0f;
                float dz = -pointsZ[ii][jj] * zfactor;
                if (new_value >= 0.0f && new_value < 90.0f) {
                    DrawPlain.run(3, x1, y1, z1, dx, dy, dz, sf);
                    DrawPlain.run(4, x1, y1, z1, dx, dy, dz, sf);
                    DrawPlain.run(0, x1, y1, z1, dx, dy, dz, sf);
                    continue;
                }
                if (new_value >= 90.0f && new_value < 180.0f) {
                    DrawPlain.run(2, x1, y1, z1, dx, dy, dz, sf);
                    DrawPlain.run(3, x1, y1, z1, dx, dy, dz, sf);
                    DrawPlain.run(0, x1, y1, z1, dx, dy, dz, sf);
                    continue;
                }
                if (new_value >= 180.0f && new_value < 270.0f) {
                    DrawPlain.run(1, x1, y1, z1, dx, dy, dz, sf);
                    DrawPlain.run(2, x1, y1, z1, dx, dy, dz, sf);
                    DrawPlain.run(0, x1, y1, z1, dx, dy, dz, sf);
                    continue;
                }
                if (!(new_value >= 270.0f) || !(new_value < 360.0f)) continue;
                DrawPlain.run(1, x1, y1, z1, dx, dy, dz, sf);
                DrawPlain.run(4, x1, y1, z1, dx, dy, dz, sf);
                DrawPlain.run(0, x1, y1, z1, dx, dy, dz, sf);
            }
        }
        if (sf.isBoxed) {
            sf.drawBoundingBox();
        }
    }
}

