/*
 * Decompiled with CFR 0.152.
 */
package jplot.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jplot.GPoints;
import jplot.LinePars;
import jplot.MyUtils;
import jplot.SmallScrollPane;
import jplot.panels.PanelGridUI;
import jplot.panels.PanelSeeOption;

public class PanelPoint
extends JPanel {
    private static final long serialVersionUID = 1L;
    float actualSize;
    SmallScrollPane ssp;
    JTextField tf_freq;
    String[] ten = new String[]{"30", "24", "20", "18", "!6", "14", "13", "12", "11", "10", "9", "8", "7", "6", "5", "4", "3", "2", "1"};
    LinePars lp;
    PointSwatches swatches;
    boolean actionNeeded;

    public PanelPoint(LinePars l) {
        this.lp = l;
        this.actionNeeded = false;
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(new EtchedBorder(), "Points"));
        JPanel p = new JPanel();
        this.swatches = new PointSwatches();
        p.add(this.swatches);
        this.add((Component)p, "Center");
        PanelGridUI south = new PanelGridUI();
        this.actualSize = this.lp.getSymbolSize();
        if (this.actualSize == 0.0f) {
            this.actualSize = 5.0f;
        }
        this.ssp = new SmallScrollPane(this.ten, true);
        this.ssp.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (PanelPoint.this.actionNeeded) {
                    PanelPoint.this.actualSize = Float.parseFloat(PanelPoint.this.ten[PanelPoint.this.ssp.getSelectedIndex()]);
                    if (PanelPoint.this.lp.getSymbol() <= 13) {
                        PanelPoint.this.lp.setSymbolSize(PanelPoint.this.actualSize);
                    }
                }
            }
        });
        this.tf_freq = new JTextField(Integer.toString(this.lp.getPointFrequency()));
        this.tf_freq.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                int k;
                if (!PanelPoint.this.tf_freq.getText().equals("") && (k = Integer.parseInt(PanelPoint.this.tf_freq.getText())) > 0) {
                    PanelPoint.this.lp.setPointFrequency(k);
                }
            }
        });
        this.tf_freq.setColumns(3);
        south.addComponent(MyUtils.getLabel("frequency"), 1, 1);
        south.addComponent(this.tf_freq, 1, 2);
        south.addComponent(MyUtils.getLabel("point size"), 2, 1);
        south.addComponent(this.ssp, 2, 2);
        this.add((Component)south, "South");
    }

    public void refresh(LinePars l) {
        this.lp = l;
        this.actionNeeded = true;
        this.actualSize = this.lp.getSymbolSize();
        this.tf_freq.setText(Integer.toString(this.lp.getPointFrequency()));
        this.ssp.setSelected(Integer.toString((int)this.actualSize));
        this.swatches.setSelectedSwatch(this.lp.getSymbol());
    }

    class PointSwatches
    extends PanelSeeOption {
        private static final long serialVersionUID = 1L;

        public PointSwatches() {
            this.setSelectedSwatch(PanelPoint.this.lp.getSymbol());
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 1) {
                        int index = PointSwatches.this.getIndex(e.getX(), e.getY());
                        PointSwatches.this.setSelectedSwatch(index);
                        PanelPoint.this.lp.setSymbol(index);
                        PanelPoint.this.lp.setSymbolSize(PanelPoint.this.actualSize);
                    }
                }
            });
        }

        @Override
        protected void initValues() {
            this.soptionSize = new Dimension(30, 12);
            this.numSOption = new Dimension(2, 7);
        }

        @Override
        protected void paintIt(Graphics2D g2, int column, int row, int x, int y) {
            g2.setColor(Color.black);
            int type = row * this.numSOption.width + column;
            GPoints.drawPointType(type, g2, x + this.soptionSize.width / 2, y + this.soptionSize.height / 2, 5.0f);
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            int i = this.getIndex(e.getX(), e.getY());
            if (i >= 0 && i < this.Ns) {
                return "point type " + new Integer(i).toString();
            }
            return "";
        }
    }
}

