/*
 * Decompiled with CFR 0.152.
 */
package jplot;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import jplot.GraphGeneral;
import jplot.GraphLabel;
import jplot.JPlot;
import jplot.Utils;
import jplot.panels.PanelFonts;
import jplot.panels.PanelGridUI;

public class LabelProperties
extends PanelGridUI {
    private static final long serialVersionUID = 1L;
    private JTextField labelText;
    private PanelFonts fontPanel;
    private JCheckBox autoPos;
    private JCheckBox manuPos;
    private JRadioButton hide;
    private JTextField xPosField;
    private JTextField yPosField;
    private JTextField rotField;
    private JDialog dialog;
    private boolean result;
    private JPlot jplot;
    private int type;

    public LabelProperties(JPlot jp) {
        this.jplot = jp;
        this.fontPanel = new PanelFonts(this.jplot, Utils.getDefaultFont(), Color.black);
        Dimension longField = new Dimension(180, 22);
        Dimension shortField = new Dimension(80, 22);
        Dimension cbField = new Dimension(110, 20);
        EmptyBorder border = new EmptyBorder(new Insets(5, 5, 5, 5));
        PanelGridUI labelPanel = new PanelGridUI();
        labelPanel.setBorder(new EtchedBorder());
        JLabel label = new JLabel("Label:");
        this.labelText = new JTextField();
        this.labelText.setPreferredSize(longField);
        label.setBorder(border);
        labelPanel.addComponent(label, 1, 1);
        labelPanel.addFilledComponent(this.labelText, 1, 2, 2, 1, 2);
        label = new JLabel("Rotation:");
        label.setBorder(border);
        labelPanel.addComponent(label, 2, 1);
        this.rotField = new JTextField("0.0");
        this.rotField.setEnabled(true);
        this.rotField.setPreferredSize(shortField);
        labelPanel.addComponent(this.rotField, 2, 2);
        label = new JLabel("Position:");
        label.setBorder(border);
        labelPanel.addComponent(label, 3, 1);
        ButtonGroup bg = new ButtonGroup();
        this.autoPos = new JCheckBox("automatic", true);
        this.autoPos.setPreferredSize(cbField);
        this.autoPos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelProperties.this.xPosField.setEnabled(false);
                LabelProperties.this.yPosField.setEnabled(false);
            }
        });
        bg.add(this.autoPos);
        labelPanel.addComponent(this.autoPos, 3, 2);
        this.manuPos = new JCheckBox("manual", false);
        this.manuPos.setPreferredSize(cbField);
        this.manuPos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelProperties.this.xPosField.setEnabled(true);
                LabelProperties.this.yPosField.setEnabled(true);
            }
        });
        bg.add(this.manuPos);
        labelPanel.addComponent(this.manuPos, 3, 3);
        JPanel posPanel = new JPanel(new BorderLayout());
        posPanel.add((Component)new JLabel("x: "), "West");
        this.xPosField = new JTextField("0.0");
        this.xPosField.setEnabled(true);
        posPanel.add((Component)this.xPosField, "Center");
        posPanel.setPreferredSize(shortField);
        labelPanel.addComponent(posPanel, 4, 2);
        posPanel = new JPanel(new BorderLayout());
        posPanel.add((Component)new JLabel("y: "), "West");
        this.yPosField = new JTextField("0.0");
        this.yPosField.setEnabled(true);
        posPanel.add((Component)this.yPosField, "Center");
        posPanel.setPreferredSize(shortField);
        labelPanel.addComponent(posPanel, 4, 3);
        this.hide = new JRadioButton("hide", false);
        this.hide.setPreferredSize(cbField);
        labelPanel.addComponent(this.hide, 5, 2);
        this.addComponent(labelPanel, 1, 1);
        this.addFilledComponent(this.fontPanel, 2, 1, 3, 1, 3);
    }

    public GraphLabel getGraphLabel() {
        GraphLabel gl = new GraphLabel(this.type, this.labelText.getText(), this.fontPanel.getSelectedFont(), this.fontPanel.getSelectedColor());
        gl.setRotation(Double.parseDouble(this.rotField.getText()) * Math.PI / 180.0);
        if (this.manuPos.isSelected()) {
            gl.setLocation(Double.parseDouble(this.xPosField.getText()), Double.parseDouble(this.yPosField.getText()));
        }
        gl.setUsePosition(!this.autoPos.isSelected());
        gl.hide(this.hide.isSelected());
        return gl;
    }

    public void refresh(GraphLabel gl) {
        this.type = gl.getID();
        this.labelText.setText(gl.getText());
        this.xPosField.setText(Integer.toString((int)gl.getX()));
        this.yPosField.setText(Integer.toString((int)gl.getY()));
        this.rotField.setText(GraphGeneral.formatNumber(gl.getRotation() / Math.PI * 180.0, 4));
        this.autoPos.setSelected(!gl.usePosition());
        this.manuPos.setSelected(gl.usePosition());
        this.hide.setSelected(gl.hide());
        this.fontPanel.refresh(gl.getFont(), gl.getColor());
    }

    public boolean show(Frame parent, int x, int y) {
        if (this.dialog == null) {
            JPanel panel = new JPanel(new BorderLayout());
            this.dialog = new JDialog(parent, "Textlabel settings", true);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    LabelProperties.this.result = false;
                    LabelProperties.this.dialog.dispose();
                }
            });
            JPanel p = new JPanel(new FlowLayout());
            p.setBorder(BorderFactory.createEtchedBorder());
            JButton b = new JButton("Apply");
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LabelProperties.this.result = true;
                    LabelProperties.this.dialog.dispose();
                }
            });
            p.add(b);
            b = new JButton("Cancel");
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LabelProperties.this.result = false;
                    LabelProperties.this.dialog.dispose();
                }
            });
            p.add(b);
            panel.add((Component)this, "Center");
            panel.add((Component)p, "South");
            this.dialog.getContentPane().add(panel);
            this.dialog.setLocation(x, y);
            this.dialog.pack();
        }
        this.dialog.setVisible(true);
        return this.result;
    }
}

