/*
 * Decompiled with CFR 0.152.
 */
package jhplot.v3d;

import java.awt.Color;
import jhplot.v3d.Face3d;
import jhplot.v3d.Matrix3d;
import jhplot.v3d.Model3d;
import jhplot.v3d.Object3d;
import jhplot.v3d.Vector3d;

public class Sphere
extends Object3d {
    public Sphere(Model3d md, float r, int m, int n) {
        super(md, (m - 1) * n + 2, m * n);
        int j;
        Vector3d v = new Vector3d(0.0f, 0.0f, r);
        Vector3d a = new Vector3d();
        Vector3d b = new Vector3d();
        Matrix3d t = new Matrix3d();
        this.addVertex(v);
        for (int i = 1; i < m; ++i) {
            t.unit();
            t.xrot((float)i * 180.0f / (float)m);
            t.transform(v, a);
            for (j = 0; j < n; ++j) {
                t.unit();
                t.zrot((float)j * 360.0f / (float)n);
                t.transform(a, b);
                this.addVertex(b);
            }
        }
        v.mul(-1.0f);
        this.addVertex(v);
        int[] p = new int[n + 1];
        for (j = 0; j < n; ++j) {
            p[j] = j + 1;
        }
        p[n] = 1;
        for (j = 0; j < n; ++j) {
            Face3d f = this.face[this.addFace(3, this.getFaceColor(0, j))];
            f.addVertex(this.vert[0]);
            f.addVertex(this.vert[p[j]]);
            f.addVertex(this.vert[p[j + 1]]);
        }
        for (int i = 1; i < m - 1; ++i) {
            int j2;
            for (j2 = 0; j2 < n; ++j2) {
                Face3d f = this.face[this.addFace(4, this.getFaceColor(i, j2))];
                f.addVertex(this.vert[p[j2]]);
                f.addVertex(this.vert[p[j2] + n]);
                f.addVertex(this.vert[p[j2 + 1] + n]);
                f.addVertex(this.vert[p[j2 + 1]]);
            }
            j2 = 0;
            while (j2 <= n) {
                int n2 = j2++;
                p[n2] = p[n2] + n;
            }
        }
        for (j = 0; j < n; ++j) {
            Face3d f = this.face[this.addFace(3, this.getFaceColor(m - 1, j))];
            f.addVertex(this.vert[(m - 1) * n + 1]);
            f.addVertex(this.vert[p[j]]);
            f.addVertex(this.vert[p[j + 1]]);
        }
        this.colectNormals();
    }

    Color getFaceColor(int i, int j) {
        if ((i + j) % 2 == 0) {
            return Color.red;
        }
        return Color.yellow;
    }
}

