/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.Vector;
import jhplot.math.io.ArrayString;
import jhplot.math.io.DataFile;

public class ASCIIFile
extends DataFile {
    public ASCIIFile(File f) {
        super(f);
    }

    public static String read(File f) {
        ASCIIFile af = new ASCIIFile(f);
        return af.read();
    }

    public static String[] readLines(File f) {
        ASCIIFile af = new ASCIIFile(f);
        return af.readLines();
    }

    public static String readLine(File f, int i) {
        ASCIIFile af = new ASCIIFile(f);
        return af.readLine(i);
    }

    public static double[] readDouble1DArray(File f) {
        return ArrayString.readString1DDouble(ASCIIFile.read(f));
    }

    public static double[][] readDoubleArray(File f) {
        return ArrayString.readStringDouble(ASCIIFile.read(f));
    }

    public static int[] readInt1DArray(File f) {
        return ArrayString.readString1DInt(ASCIIFile.read(f));
    }

    public static int[][] readIntArray(File f) {
        return ArrayString.readStringInt(ASCIIFile.read(f));
    }

    public static void write(File f, String t) {
        ASCIIFile af = new ASCIIFile(f);
        af.write(t, false);
    }

    public static void writeDoubleArray(File f, double[] array) {
        ASCIIFile.write(f, ArrayString.printDoubleArray(array));
    }

    public static void writeDoubleArray(File f, double[][] array) {
        ASCIIFile.write(f, ArrayString.printDoubleArray(array));
    }

    public static void writeIntArray(File f, int[] array) {
        ASCIIFile.write(f, ArrayString.printIntArray(array));
    }

    public static void writeIntArray(File f, int[][] array) {
        ASCIIFile.write(f, ArrayString.printIntArray(array));
    }

    public static void append(File f, String t) {
        ASCIIFile af = new ASCIIFile(f);
        af.write(t, true);
    }

    public String read() {
        StringBuffer text = new StringBuffer((int)this.file.length());
        try {
            FileReader fr = new FileReader(this.file);
            BufferedReader b = new BufferedReader(fr);
            boolean eof = false;
            String ret = "\n";
            while (!eof) {
                String line = b.readLine();
                if (line == null) {
                    eof = true;
                    continue;
                }
                text.append(line);
                text.append(ret);
            }
            b.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("File " + this.file.getName() + " is unreadable : " + e.toString());
        }
        return text.toString();
    }

    public String[] readLines() {
        Vector<String> linesVector = new Vector<String>();
        try {
            FileReader fr = new FileReader(this.file);
            BufferedReader b = new BufferedReader(fr);
            boolean eof = false;
            while (!eof) {
                String line = b.readLine();
                if (line == null) {
                    eof = true;
                    continue;
                }
                linesVector.add(line);
            }
            b.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("File " + this.file.getName() + " is unreadable : " + e.toString());
        }
        String[] lines = new String[linesVector.size()];
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = (String)linesVector.get(i);
        }
        return lines;
    }

    public String readLine(int i) {
        String line = new String("");
        try {
            FileReader fr = new FileReader(this.file);
            BufferedReader b = new BufferedReader(fr);
            boolean eof = false;
            for (int j = 0; j < i; ++j) {
                if (eof) {
                    throw new IllegalArgumentException("Line " + i + " is not found in the file " + this.file.getName() + ".");
                }
                b.readLine();
                if (line != null) continue;
                eof = true;
            }
            line = b.readLine();
            b.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("File " + this.file.getName() + " is unreadable : " + e.toString());
        }
        return line;
    }

    public void write(String text, boolean append) {
        if (this.file.exists()) {
            System.out.println("Warning : the file " + this.file.getName() + " already exists !");
        }
        try {
            FileWriter fw = new FileWriter(this.file, append);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(text);
            bw.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("File " + this.file.getName() + " is unwritable : " + e.toString());
        }
    }

    public static void concatenate(File f1, File f2) {
        try {
            int c;
            FileInputStream fis = new FileInputStream(f2);
            BufferedInputStream bis = new BufferedInputStream(fis);
            FileOutputStream fos = new FileOutputStream(f1, true);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            while ((c = bis.read()) != -1) {
                bos.write(c);
            }
            bis.close();
            bos.close();
        }
        catch (IOException e) {
            System.err.println("Concatenate: " + e);
        }
    }

    public static void main(String[] args) {
        File f = new File("read.txt");
        System.out.println(ASCIIFile.read(f));
        String[] lines = ASCIIFile.readLines(f);
        for (int i = 0; i < lines.length; ++i) {
            System.out.println("line " + i + " : " + lines[i]);
        }
        System.out.println(ASCIIFile.readLine(f, 0));
        System.out.println(ASCIIFile.readLine(f, lines.length - 1));
        ASCIIFile.append(new File("write.txt"), Calendar.getInstance().getTime().toString());
    }
}

