/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class SortUtils {
    public static int[] identity(int n) {
        int[] indices = new int[n];
        for (int i = 0; i < n; ++i) {
            indices[i] = i;
        }
        return indices;
    }

    public static int[] reverse(int n) {
        int[] indices = new int[n];
        for (int i = 0; i < n; ++i) {
            indices[i] = n - i - 1;
        }
        return indices;
    }

    public static int[] inverse(int[] p) {
        int[] pi = new int[p.length];
        for (int i = 0; i < pi.length; ++i) {
            pi[p[i]] = i;
        }
        return pi;
    }

    public static Object[] permute(int[] p, Object[] data, boolean clone) {
        Object[] permuted = null;
        if (clone) {
            permuted = (Object[])data.clone();
            for (int i = 0; i < data.length; ++i) {
                permuted[p[i]] = data[i];
            }
        } else {
            int i = 0;
            while (i < p.length) {
                if (p[i] < 0 || p[i] == i) {
                    ++i;
                    continue;
                }
                int j = p[i];
                Object save = data[i];
                while (p[j] >= 0) {
                    Object tmp = data[j];
                    data[j] = save;
                    save = tmp;
                    i = j;
                    j = p[j];
                    p[i] = -1;
                }
            }
            permuted = data;
        }
        return permuted;
    }

    public static Iterator getIterator(final int[] p, final Object[] data) {
        return new Iterator(){
            int pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < data.length;
            }

            public Object next() {
                return data[p[this.pos++]];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot remove from immutable iterator!");
            }
        };
    }

    public static Iterator getIterator(final int[] p, final List data) {
        return new Iterator(){
            int pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < data.size();
            }

            public Object next() {
                return data.get(p[this.pos++]);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot remove from immutable iterator!");
            }
        };
    }

    public static void sort(int[] indices, Object[] data, Comparator comparator, boolean stable) {
        new QuickSorter(data).sort(indices, comparator, stable);
    }

    public static int[] sort(Object[] data, Comparator comparator, boolean stable) {
        int[] indices = SortUtils.identity(data.length);
        SortUtils.sort(indices, data, comparator, stable);
        return indices;
    }

    public static int[] sort(Object[] data, Comparator comparator) {
        return SortUtils.sort(data, comparator, false);
    }

    public static void sort(int[] indices, Object[] data, Comparator comparator) {
        SortUtils.sort(indices, data, comparator, false);
    }

    public static void main(String[] args) {
        int i;
        int i2;
        Comparator cmp = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Comparable)o1).compareTo(o2);
            }
        };
        int n = 100000;
        if (args.length == 1) {
            try {
                n = Integer.parseInt(args[0]);
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        System.out.println("Generating " + n + " random integers...");
        Random random = new Random();
        Object[] data = new Double[n];
        for (int i3 = 0; i3 < n; ++i3) {
            data[i3] = new Double(Math.abs(random.nextDouble()));
        }
        System.out.print("Arrays.sort...");
        long time = System.currentTimeMillis();
        Double[] clone = (Double[])data.clone();
        Arrays.sort(clone, cmp);
        System.out.println(System.currentTimeMillis() - time + "ms");
        System.out.print("quicksort...");
        int[] indices = SortUtils.identity(n);
        time = System.currentTimeMillis();
        SortUtils.sort(indices, data, cmp, false);
        System.out.println(System.currentTimeMillis() - time + "ms");
        for (i2 = 1; i2 < n; ++i2) {
            if (cmp.compare(data[indices[i2 - 1]], data[indices[i2]]) <= 0) continue;
            System.err.println("proplem: quickSort at " + i2);
        }
        System.out.print("quicksort stable...");
        time = System.currentTimeMillis();
        SortUtils.sort(indices, data, cmp, true);
        System.out.println(System.currentTimeMillis() - time + "ms");
        for (i2 = 0; i2 < indices.length; ++i2) {
            System.out.println(Integer.toString(indices[i2]) + " value=" + Double.toString((Double)data[indices[i2]]));
        }
        for (i2 = 1; i2 < n; ++i2) {
            int res = cmp.compare(data[indices[i2 - 1]], data[indices[i2]]);
            if (res > 0) {
                System.err.println("proplem: quickSort stable at " + i2);
            }
            if (res != 0 || indices[i2 - 1] <= indices[i2]) continue;
            System.err.println("proplem: quickSort stable (not stable) at " + i2);
        }
        System.out.print("permutate copy...");
        time = System.currentTimeMillis();
        Object[] data_copy = SortUtils.permute(SortUtils.inverse(indices), data, true);
        System.out.println(System.currentTimeMillis() - time + "ms");
        for (i = 1; i < n; ++i) {
            if (cmp.compare(data_copy[i - 1], data_copy[i]) <= 0) continue;
            System.err.println("proplem: permute copy at " + i);
        }
        System.out.print("permutate original...");
        time = System.currentTimeMillis();
        SortUtils.permute(SortUtils.inverse(indices), data, false);
        System.out.println(System.currentTimeMillis() - time + "ms");
        for (i = 1; i < n; ++i) {
            if (cmp.compare(data[i - 1], data[i]) <= 0) continue;
            System.err.println("proplem: permute original at " + i);
        }
    }

    static final class QuickSorter {
        private static final int INSERTIONSORT_THRESHOLD = 7;
        private final Object[] data;

        QuickSorter(Object[] data) {
            this.data = data;
        }

        private int compare(Comparator cmp, boolean stable, int i, int j) {
            int result = cmp.compare(this.data[i], this.data[j]);
            if (result == 0 && stable && i != j) {
                result = i < j ? -1 : 1;
            }
            return result;
        }

        private int med3(Comparator cmp, int a, int b, int c) {
            return this.compare(cmp, false, a, b) < 0 ? (this.compare(cmp, false, b, c) < 0 ? b : (this.compare(cmp, false, a, c) < 0 ? c : a)) : (this.compare(cmp, false, b, c) > 0 ? b : (this.compare(cmp, false, a, c) < 0 ? c : a));
        }

        private int pivot(int[] indices, Comparator cmp, int lo, int hi) {
            return this.med3(cmp, indices[lo + 1], indices[(lo + hi) / 2], indices[hi - 1]);
        }

        private void swap(int[] indices, int i, int j) {
            int tmp = indices[i];
            indices[i] = indices[j];
            indices[j] = tmp;
        }

        private void insertionSort(int[] indices, Comparator cmp, boolean stable, int lo, int hi) {
            for (int i = lo; i <= hi; ++i) {
                for (int j = i; j > lo && this.compare(cmp, stable, indices[j - 1], indices[j]) > 0; --j) {
                    this.swap(indices, j - 1, j);
                }
            }
        }

        private void quickSort(int[] indices, Comparator cmp, boolean stable, int lo0, int hi0) {
            int pivot = this.pivot(indices, cmp, lo0, hi0);
            int lo = lo0;
            int hi = hi0;
            while (lo <= hi) {
                while (lo < hi0 && this.compare(cmp, stable, pivot, indices[lo]) > 0) {
                    ++lo;
                }
                while (hi > lo0 && this.compare(cmp, stable, pivot, indices[hi]) < 0) {
                    --hi;
                }
                if (lo > hi) continue;
                this.swap(indices, lo++, hi--);
            }
            this.sort(indices, cmp, stable, lo0, hi);
            this.sort(indices, cmp, stable, lo, hi0);
        }

        void sort(int[] indices, Comparator cmp, boolean stable, int lo, int hi) {
            if (hi - lo < 7) {
                this.insertionSort(indices, cmp, stable, lo, hi);
            } else {
                this.quickSort(indices, cmp, stable, lo, hi);
            }
        }

        void sort(int[] indices, Comparator cmp, boolean stable) {
            this.sort(indices, cmp, stable, 0, indices.length - 1);
        }

        int[] sort(Comparator cmp, boolean stable) {
            int[] indices = SortUtils.identity(this.data.length);
            this.sort(indices, cmp, stable);
            return indices;
        }
    }
}

