/*
 * Decompiled with CFR 0.152.
 */
package jhplot.io;

import hep.aida.IAnalysisFactory;
import hep.aida.IDataPointSet;
import hep.aida.ITree;
import hep.aida.ref.histogram.Cloud1D;
import hep.aida.ref.histogram.Cloud2D;
import hep.aida.ref.histogram.Histogram1D;
import hep.aida.ref.histogram.Histogram2D;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import jhplot.DrawOptions;
import jhplot.H1D;
import jhplot.H2D;
import jhplot.HPlot;
import jhplot.P1D;
import jhplot.gui.GHFrame;
import jhplot.io.AidaDirectoryTreeCellRenderer;
import jhplot.io.BrowserDataGeneric;
import jhplot.utils.Util;

public class BrowserAida
extends BrowserDataGeneric {
    static Random random = new Random();
    private static final long serialVersionUID = 1L;
    boolean take = true;
    private Map<String, Object> map;
    protected JTree m_tree;
    protected JScrollPane scroll;
    public JButton closeButton;
    private JButton runButton;
    private JDialog jdialog;
    private GHFrame gframe;
    private JCheckBox cb;
    private IAnalysisFactory af;
    private ITree itree;
    private TreeModel model;
    private static final TreeModel emptyTree = null;

    public BrowserAida() {
    }

    public BrowserAida(GHFrame h, String hfile, boolean ishow) {
        this.setFile(h, hfile, ishow);
    }

    public void setFile(GHFrame frame, String hb, boolean ishow) {
        this.map = new TreeMap<String, Object>();
        this.gframe = frame;
        File file = null;
        this.m_tree = new JTree(emptyTree);
        this.m_tree.setRootVisible(false);
        this.m_tree.getSelectionModel().setSelectionMode(1);
        this.m_tree.setShowsRootHandles(false);
        this.m_tree.setEditable(false);
        try {
            file = new File(hb);
            IAnalysisFactory af = IAnalysisFactory.create();
            this.itree = af.createTreeFactory().create(file.getAbsolutePath(), "xml");
            this.model = new DefaultTreeModel(this.getModel(this.itree));
            this.m_tree.setModel(this.model);
            this.m_tree.setCellRenderer(new AidaDirectoryTreeCellRenderer());
            this.m_tree.setRowHeight(20);
            this.m_tree.setLargeModel(true);
        }
        catch (IOException x) {
            Util.ErrorMessage("Error when opening the file:" + hb);
        }
        this.makeDialog();
    }

    public void makeDialog() {
        JFrame frame = this.gframe.getFrame();
        this.jdialog = new JDialog();
        this.cb = new JCheckBox("Overlay");
        this.jdialog.setTitle("Objects");
        this.jdialog.setResizable(true);
        this.jdialog.setDefaultCloseOperation(2);
        JPanel lowerPanel = new JPanel();
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.cb = new JCheckBox("Overlay");
        this.scroll = new JScrollPane();
        this.scroll.getViewport().add(this.m_tree);
        mainPanel.add((Component)this.scroll, "Center");
        this.closeButton = new JButton();
        this.closeButton.setText("Exit");
        this.runButton = new JButton();
        this.runButton.setText("Plot");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserAida.this.jdialog.setVisible(false);
                BrowserAida.this.jdialog.dispose();
            }
        });
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserAida.this.plotObject();
            }
        });
        lowerPanel.add((Component)this.runButton, null);
        lowerPanel.add((Component)this.cb, null);
        lowerPanel.add((Component)this.closeButton, null);
        this.jdialog.getContentPane().add((Component)lowerPanel, "South");
        this.jdialog.getContentPane().add((Component)mainPanel, "North");
        Dimension dim = frame.getSize();
        int w = dim.width;
        int h = dim.height;
        Dimension res = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = new Dimension(Math.min((int)(0.5 * (double)w), res.width), Math.min((int)(1.0 * (double)h), res.height));
        this.jdialog.setSize(size);
        Util.rightWithin(frame, this.jdialog);
        this.jdialog.setVisible(true);
    }

    public void plotObject() {
        DrawOptions h1;
        Histogram1D hh;
        int symbol;
        P1D p1;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object nodeInfo = node.getUserObject();
        OidNode iod = (OidNode)nodeInfo;
        Color randomColor = Color.getHSBColor(random.nextFloat(), 1.0f, 1.0f);
        HPlot frame = (HPlot)this.gframe;
        if (!this.cb.isSelected()) {
            frame.clearAll();
        }
        frame.setAutoRange();
        if (iod.getType().equals("IDataPointSet")) {
            IDataPointSet p1d = (IDataPointSet)this.itree.find(iod.getName());
            p1 = new P1D(p1d);
            p1.setErrAll(true);
            symbol = (int)(5.0f * random.nextFloat());
            if (symbol <= 0) {
                symbol = 1;
            }
            p1.setSymbol(symbol);
            p1.setSymbolSize(4);
            p1.setStyle("p");
            p1.setPenWidth(3);
            p1.setColor(randomColor);
            frame.draw(p1);
        }
        if (iod.getType().equals("IHistogram1D")) {
            hh = (Histogram1D)this.itree.find(iod.getName());
            h1 = new H1D(hh);
            h1.setFill(true);
            h1.setStyle("h");
            h1.setPenWidthErr(1);
            h1.setPenWidth(1);
            h1.setFillColorTransparency(0.6);
            h1.setFillColor(randomColor);
            h1.setColor(Color.black);
            frame.draw((H1D)h1);
        } else if (iod.getType().equals("IHistogram2D")) {
            hh = (Histogram2D)this.itree.find(iod.getName());
            h1 = new H2D((Histogram2D)hh);
        } else if (iod.getType().equals("ICloud1D")) {
            hh = (Cloud1D)this.itree.find(iod.getName());
            h1 = new H1D((Cloud1D)hh, 100);
            h1.setFill(true);
            h1.setStyle("h");
            h1.setPenWidthErr(1);
            h1.setPenWidth(1);
            h1.setFillColorTransparency(0.6);
            h1.setFillColor(randomColor);
            h1.setColor(Color.black);
            frame.draw((H1D)h1);
        } else if (iod.getType().equals("ICloud2D")) {
            Cloud2D c2d = (Cloud2D)this.itree.find(iod.getName());
            p1 = new P1D(c2d);
            p1.setErrAll(true);
            symbol = (int)(5.0f * random.nextFloat());
            if (symbol <= 0) {
                symbol = 1;
            }
            p1.setSymbol(symbol);
            p1.setSymbolSize(4);
            p1.setStyle("p");
            p1.setPenWidth(3);
            p1.setColor(randomColor);
            frame.draw(p1);
        }
    }

    public Map<String, Object> getMap() {
        return this.map;
    }

    private DefaultMutableTreeNode getModel(ITree tree) {
        DefaultMutableTreeNode node;
        DefaultMutableTreeNode clus_parent;
        String[] names = tree.listObjectNames(".", true);
        String[] types = tree.listObjectTypes(".", true);
        Object[] nodes = new Object[names.length + 1];
        DefaultMutableTreeNode parent = clus_parent = (node = new DefaultMutableTreeNode(new OidNode(1, "Data", "none")));
        nodes[0] = clus_parent;
        for (int i = 0; i < names.length; ++i) {
            node = new DefaultMutableTreeNode(new OidNode(i + 1, names[i], types[i]));
            clus_parent.add(node);
            parent = node;
            nodes[i + 1] = parent;
        }
        return clus_parent;
    }

    class OidNode {
        protected int m_id;
        protected String m_type;
        protected String m_name;

        public OidNode(int id, String name, String type) {
            this.m_id = id;
            this.m_name = name;
            this.m_type = type;
        }

        public int getId() {
            return this.m_id;
        }

        public String getName() {
            return this.m_name;
        }

        public String getType() {
            return this.m_type;
        }

        public String toString() {
            return this.m_name;
        }
    }
}

