/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import hep.aida.IAnalysisFactory;
import hep.aida.IDataPointSet;
import hep.aida.IDataPointSetFactory;
import hep.aida.ITree;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jhplot.H1D;
import jhplot.HPlot;
import jhplot.HTable;
import jhplot.P0D;
import jhplot.P0I;
import jhplot.P1D;
import jhplot.P2D;
import jhplot.gui.HelpBrowser;
import jhplot.io.PReader;
import jhplot.io.Serialized;
import jhplot.utils.Util;

public class PNI
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<int[]> data;
    private String title;
    private int dimension;
    private double min = 0.0;
    private double max = 0.0;

    public PNI(String title) {
        this.data = new ArrayList();
        this.title = title;
        this.dimension = 0;
    }

    public PNI(String title, boolean shallow, PNI pni) {
        this.title = title;
        this.data = new ArrayList();
        this.dimension = pni.getDimension();
        if (shallow) {
            this.data = (ArrayList)pni.getArrayList().clone();
        } else {
            for (int i = 0; i < pni.size(); ++i) {
                this.data.add(pni.get(i));
            }
        }
    }

    public PNI(String title, String file) {
        this.dimension = 0;
        this.data = new ArrayList();
        this.title = title;
        this.read(file);
    }

    public PNI() {
        this("NOT SET");
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void clear() {
        this.data.clear();
    }

    public int[] get(int row) {
        return this.data.get(row);
    }

    public P0I getRowP0D(int row) {
        P0I p = new P0I(this.title + ":row:" + Integer.toString(row));
        p.fill(this.data.get(row));
        return p;
    }

    public int get(int row, int column) {
        int[] tmp = this.data.get(row);
        return tmp[column];
    }

    public String toString() {
        String tmp = "\nPNI: " + this.title + "\n";
        for (int i = 0; i < this.data.size(); ++i) {
            int[] tt = this.data.get(i);
            for (int j = 0; j < tt.length; ++j) {
                tmp = tmp + Double.toString(tt[j]);
                tmp = tmp + " ";
            }
            tmp = tmp + "\n";
        }
        return tmp;
    }

    public void print() {
        System.out.println(this.toString());
    }

    public int[] getColumn(int column) {
        int[] tmp = new int[this.data.size()];
        if (column >= this.dimension) {
            this.ErrorMessage("Index is too large");
            return tmp;
        }
        for (int j = 0; j < this.data.size(); ++j) {
            int[] tt = this.data.get(j);
            tmp[j] = tt[column];
        }
        return tmp;
    }

    public P1D getP1D(int c1, int c2) {
        P1D tmp = new P1D(this.title + ":" + Integer.toString(c1) + "-" + Integer.toString(c2));
        tmp.setDimension(2);
        if (c1 >= this.dimension || c2 >= this.dimension) {
            this.ErrorMessage("Index is too large");
            return tmp;
        }
        for (int j = 0; j < this.data.size(); ++j) {
            int[] tt = this.data.get(j);
            tmp.add(tt[c1], tt[c2]);
        }
        return tmp;
    }

    public P0I getP0I(int column) {
        P0I tmp = new P0I(this.title + " :" + Integer.toString(column));
        if (column >= this.dimension) {
            this.ErrorMessage("Index is too large");
            return tmp;
        }
        for (int j = 0; j < this.data.size(); ++j) {
            int[] tt = this.data.get(j);
            tmp.add(tt[column]);
        }
        return tmp;
    }

    public P2D getP2D(int c1, int c2, int c3) {
        P2D tmp = new P2D(this.title + ":" + Integer.toString(c1) + "-" + Integer.toString(c2) + "-" + Integer.toString(c3));
        if (c1 >= this.dimension || c2 >= this.dimension || c3 >= this.dimension) {
            this.ErrorMessage("Index is too large");
            return tmp;
        }
        for (int j = 0; j < this.data.size(); ++j) {
            int[] tt = this.data.get(j);
            tmp.add(tt[c1], tt[c2], tt[c3]);
        }
        return tmp;
    }

    public P0D getRow(int row) {
        P0D tmp = new P0D(this.title + " row=" + Integer.toString(row));
        if (row > this.data.size()) {
            this.ErrorMessage("Index is too large");
            return tmp;
        }
        int[] tt = this.data.get(row);
        tmp.setArray(tt);
        return tmp;
    }

    public ArrayList<int[]> getArrayList() {
        return this.data;
    }

    public IDataPointSet getIDataPointSet() {
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree = af.createTreeFactory().create();
        IDataPointSetFactory dpsf = af.createDataPointSetFactory(tree);
        IDataPointSet fDps2D = dpsf.create(this.getTitle(), this.getTitle(), this.dimension);
        for (int i = 0; i < this.data.size(); ++i) {
            fDps2D.addPoint();
            int[] tt = this.data.get(i);
            for (int j = 0; j < this.dimension; ++j) {
                fDps2D.point(i).coordinate(j).setValue((double)tt[j]);
            }
        }
        return fDps2D;
    }

    public void add(int[] values) {
        this.dimension = values.length;
        this.data.add(values);
    }

    public void add(P0I values) {
        this.dimension = values.size();
        this.data.add(values.getArray());
    }

    public void set(int index, int[] values) {
        if (index >= this.data.size()) {
            this.ErrorMessage("Index is too large");
        }
        this.dimension = values.length;
        this.data.set(index, values);
    }

    public void set(int index, P0I values) {
        if (index >= this.data.size()) {
            this.ErrorMessage("Index is too large");
        }
        this.dimension = values.size();
        this.data.set(index, values.getArray());
    }

    public int read(BufferedReader br) {
        this.data.clear();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.startsWith("*")) continue;
                StringTokenizer st = new StringTokenizer(line);
                this.dimension = st.countTokens();
                int[] snum = new int[this.dimension];
                int mm = 0;
                while (st.hasMoreTokens()) {
                    String tmp = st.nextToken();
                    int dd = 0;
                    try {
                        dd = Integer.parseInt(tmp.trim());
                    }
                    catch (NumberFormatException e) {
                        this.ErrorMessage("Error in reading the line " + Integer.toString(mm + 1));
                    }
                    snum[mm] = dd;
                    ++mm;
                }
                this.data.add(snum);
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            this.ErrorMessage("File not found!");
            e.printStackTrace();
            return 2;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public int readZip(String sfile) {
        this.data.clear();
        try {
            ZipFile zf = new ZipFile(sfile);
            Enumeration<? extends ZipEntry> entries = zf.entries();
            BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
            while (entries.hasMoreElements()) {
                String line;
                long size;
                ZipEntry ze = entries.nextElement();
                String inputLine = input.readLine();
                if (!inputLine.equalsIgnoreCase("yes") || (size = ze.getSize()) <= 0L) continue;
                BufferedReader br = new BufferedReader(new InputStreamReader(zf.getInputStream(ze)));
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#") || line.startsWith("*")) continue;
                    StringTokenizer st = new StringTokenizer(line);
                    this.dimension = st.countTokens();
                    int[] snum = new int[this.dimension];
                    int mm = 0;
                    while (st.hasMoreTokens()) {
                        String tmp = st.nextToken();
                        int dd = 0;
                        try {
                            dd = Integer.parseInt(tmp.trim());
                        }
                        catch (NumberFormatException e) {
                            this.ErrorMessage("Error in reading the line " + Integer.toString(mm + 1));
                        }
                        snum[mm] = dd;
                        ++mm;
                    }
                    this.data.add(snum);
                }
                br.close();
            }
        }
        catch (FileNotFoundException e) {
            this.ErrorMessage("File not found!");
            e.printStackTrace();
            return 2;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public int read(File sfile) {
        BufferedReader is = PReader.read(sfile);
        if (is == null) {
            return 1;
        }
        return this.read(is);
    }

    public int read(URL url) {
        BufferedReader is = PReader.read(url);
        if (is == null) {
            return 1;
        }
        return this.read(is);
    }

    public int readGZip(String sfile) {
        BufferedReader is = PReader.readGZip(sfile);
        if (is == null) {
            return 1;
        }
        return this.read(is);
    }

    public int read(String sfile) {
        BufferedReader is = PReader.read(sfile);
        if (is == null) {
            return 1;
        }
        return this.read(is);
    }

    public int readGZip(File sfile) {
        BufferedReader is = PReader.readGZip(sfile);
        if (is == null) {
            return 1;
        }
        return this.read(is);
    }

    public void write(String name) {
        this.toFile(name);
    }

    public int writeSerialized(String name) {
        return Serialized.write(this, name);
    }

    public PNI readSerialized(String name) {
        return (PNI)Serialized.read(name);
    }

    public void toFile(String name) {
        Date dat = new Date();
        String today = String.valueOf(dat);
        try {
            FileOutputStream f1 = new FileOutputStream(new File(name));
            PrintStream tx = new PrintStream(f1);
            tx.println("# DataMelt: output from PNI " + this.title);
            tx.println("# DataMelt: created at " + today);
            tx.println("# values:");
            tx.println("#");
            for (int i = 0; i < this.data.size(); ++i) {
                int[] tt = this.get(i);
                this.dimension = tt.length;
                for (int j = 0; j < this.dimension; ++j) {
                    tx.print(tt[j]);
                }
                tx.print("\n");
            }
            f1.close();
        }
        catch (IOException e) {
            this.ErrorMessage("Error in the output file");
            e.printStackTrace();
        }
    }

    public PNI remove(int index) {
        this.data.remove(index);
        return this;
    }

    public PNI oper(PNI PNI2, String what) {
        return this.oper(PNI2, this.getTitle(), what);
    }

    public PNI oper(PNI PNI2, String title, String what) {
        what = what.trim();
        if (this.data.size() != PNI2.size()) {
            this.ErrorMessage("Sizes of the PNIs are different!");
            return this;
        }
        if (this.dimension != PNI2.getDimension()) {
            this.ErrorMessage("Dimensions of the PNIs are different!");
            return this;
        }
        if (what.equals("+")) {
            for (int i = 0; i < this.data.size(); ++i) {
                int[] tt1 = this.get(i);
                int[] tt2 = PNI2.get(i);
                for (int j = 0; j < tt1.length; ++j) {
                    tt1[j] = tt1[j] + tt2[j];
                }
                this.data.set(i, tt1);
            }
            return this;
        }
        if (what.equals("-")) {
            for (int i = 0; i < this.data.size(); ++i) {
                int[] tt1 = this.get(i);
                int[] tt2 = PNI2.get(i);
                for (int j = 0; j < tt1.length; ++j) {
                    tt1[j] = tt1[j] - tt2[j];
                }
                this.data.set(i, tt1);
            }
            return this;
        }
        if (what.equals("*")) {
            for (int i = 0; i < this.data.size(); ++i) {
                int[] tt1 = this.get(i);
                int[] tt2 = PNI2.get(i);
                for (int j = 0; j < tt1.length; ++j) {
                    tt1[j] = tt1[j] * tt2[j];
                }
                this.data.set(i, tt1);
            }
            return this;
        }
        if (what.equals("/")) {
            for (int i = 0; i < this.data.size(); ++i) {
                int[] tt1 = this.get(i);
                int[] tt2 = PNI2.get(i);
                for (int j = 0; j < tt1.length; ++j) {
                    tt1[j] = tt1[j] / tt2[j];
                }
                this.data.set(i, tt1);
            }
            return this;
        }
        return this;
    }

    public void toTable() {
        new HTable(this);
    }

    public int getDimension() {
        return this.dimension;
    }

    public int[] getDimensions() {
        int[] ii = new int[this.data.size()];
        for (int j = 0; j < this.data.size(); ++j) {
            int[] tt = this.data.get(j);
            ii[j] = tt.length;
        }
        return ii;
    }

    public void operScale(double scale) {
        for (int i = 0; i < this.data.size(); ++i) {
            int[] tt1 = this.get(i);
            for (int j = 0; j < tt1.length; ++j) {
                tt1[j] = (int)((double)tt1[j] * scale);
            }
            this.data.set(i, tt1);
        }
    }

    public int size() {
        return this.data.size();
    }

    public PNI copy(String newtitle) {
        PNI tmp = new PNI(newtitle);
        for (int i = 0; i < this.data.size(); ++i) {
            int[] tt = this.data.get(i);
            int[] clone = (int[])tt.clone();
            tmp.add(clone);
        }
        return tmp;
    }

    public PNI getRows(String newtitle, int indexMin, int indexMax) {
        PNI tmp = new PNI(newtitle);
        if (indexMin < 0) {
            this.ErrorMessage("Wrong min index");
            return null;
        }
        if (indexMax > this.data.size()) {
            this.ErrorMessage("Wrong max index");
            return null;
        }
        for (int i = indexMin; i < indexMax; ++i) {
            tmp.add(this.get(i));
        }
        return tmp;
    }

    public void setArrayList(ArrayList<int[]> array) {
        this.data = array;
    }

    public int[][] getArray() {
        int[][] tmp = new int[this.data.size()][this.dimension];
        for (int i = 0; i < this.data.size(); ++i) {
            int[] tt = this.data.get(i);
            for (int j = 0; j < tt.length; ++j) {
                tmp[i][j] = tt[j];
            }
        }
        return tmp;
    }

    public PNI setArray(int[][] values) {
        if (values[0].length != this.dimension) {
            this.ErrorMessage("Input array has too large dimension");
            return this;
        }
        this.data.clear();
        for (int i = 0; i < values.length; ++i) {
            this.data.add(values[i]);
        }
        return this;
    }

    private void ErrorMessage(String a) {
        Util.ErrorMessage(a);
    }

    public static void main(String[] args) {
        HPlot c1 = new HPlot("Canvas", 600, 400);
        c1.visible(true);
        c1.setAutoRange();
        PNI p0 = new PNI("Example");
        p0.add(new int[]{1, 2, 3});
        p0.add(new int[]{2, 5, 1});
        System.out.println(p0.toString());
        c1.setNameX("X");
        c1.setNameY("Y");
        p0.print();
        P0I ppp = p0.getP0I(1);
        H1D h1 = ppp.getH1D(100);
        c1.draw(h1);
    }

    public H1D getH1D(int bins, double min, double max) {
        H1D h1d = new H1D(this.title, bins, min, max);
        for (int n = 0; n < this.getDimension(); ++n) {
            for (int j = 0; j < this.size(); ++j) {
                h1d.fill(this.get(j, n));
            }
        }
        return h1d;
    }

    public H1D getH1D(int bins) {
        this.getMinMax();
        return this.getH1D(bins, this.min, this.max);
    }

    public H1D getH1D(int bins, double min, double max, int column) {
        H1D h1d = new H1D(this.title, bins, min, max);
        for (int j = 0; j < this.size(); ++j) {
            h1d.fill(this.get(j, column));
        }
        return h1d;
    }

    public double getMax() {
        double maxValue = this.get(0, 0);
        for (int n = 0; n < this.getDimension(); ++n) {
            for (int j = 0; j < this.size(); ++j) {
                if (!((double)this.get(j, n) > maxValue)) continue;
                maxValue = this.get(j, n);
            }
        }
        return maxValue;
    }

    public double getMin() {
        double minValue = this.get(0, 0);
        for (int n = 0; n < this.getDimension(); ++n) {
            for (int j = 0; j < this.size(); ++j) {
                if (!((double)this.get(j, n) < minValue)) continue;
                minValue = this.get(j, n);
            }
        }
        return minValue;
    }

    private void getMinMax() {
        this.min = this.get(0, 0);
        this.min = this.max;
        for (int n = 0; n < this.getDimension(); ++n) {
            for (int j = 0; j < this.size(); ++j) {
                if ((double)this.get(j, n) < this.min) {
                    this.min = this.get(j, n);
                }
                if (!((double)this.get(j, n) > this.max)) continue;
                this.max = this.get(j, n);
            }
        }
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

