/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jhplot.gui.GHFrame;
import jhplot.gui.HelpBrowser;
import jhplot.v3d.Canvas3d;
import jhplot.v3d.Model3d;
import jhplot.v3d.Object3d;

public class HView3D
extends GHFrame {
    private static final long serialVersionUID = 1L;
    public boolean set = true;
    private Canvas3d[][] canv;
    private JPanel[][] jpp;
    private Model3d[][] md;
    private static final Color DEFAULT_BG_COLOR = Color.white;
    private Thread1 m_Close;
    private int xsize;
    private int ysize;

    public HView3D(String title, int xsize, int ysize, int n1, int n2, boolean set) {
        super(title, xsize, ysize, n1, n2, set);
        this.xsize = xsize;
        this.ysize = ysize;
        if (set) {
            this.setGraph();
        }
    }

    @Override
    protected void clearFrame() {
    }

    @Override
    protected void refreshFrame() {
    }

    @Override
    protected void openWriteDialog() {
        JOptionPane.showMessageDialog(this.getFrame(), "Not implemented for HGraph");
    }

    @Override
    protected void openReadDialog() {
        JOptionPane.showMessageDialog(this.getFrame(), "Not implemented for HGraph");
    }

    public void visible(boolean vs) {
        if (!vs) {
            this.mainFrame.setVisible(false);
        }
        if (vs) {
            this.showIt();
        }
    }

    public void visible() {
        this.showIt();
    }

    private void showIt() {
        this.mainFrame.setVisible(true);
        for (int i2 = 0; i2 < this.N2final; ++i2) {
            for (int i1 = 0; i1 < this.N1final; ++i1) {
                Dimension d = this.jpp[i1][i2].getSize();
                double panelWidth = d.width;
                double panelHeight = d.height;
                this.md[i1][i2] = new Model3d(null, (int)panelWidth - 1, (int)panelHeight - 1);
                this.canv[i1][i2] = new Canvas3d(this.md[i1][i2]);
                this.canv[i1][i2].setColorBack(DEFAULT_BG_COLOR);
                this.jpp[i1][i2].add(this.canv[i1][i2]);
            }
        }
    }

    public void destroy() {
        this.mainFrame.setVisible(false);
        this.close();
    }

    private void setGraph() {
        this.md = new Model3d[this.N1final][this.N2final];
        this.canv = new Canvas3d[this.N1final][this.N2final];
        this.jpp = new JPanel[this.N1final][this.N2final];
        this.mainPanel.setLayout(new BorderLayout());
        for (int i2 = 0; i2 < this.N2final; ++i2) {
            for (int i1 = 0; i1 < this.N1final; ++i1) {
                this.jpp[i1][i2] = new JPanel();
                this.jpp[i1][i2].setLayout(new BorderLayout());
                this.jpp[i1][i2].setBorder(BorderFactory.createEmptyBorder());
                this.mainPanel.add(this.jpp[i1][i2]);
            }
        }
    }

    public void update(int n1, int n2) {
        this.canv[n1][n2].repaint();
    }

    public void update() {
        this.update(N1, N2);
    }

    public void updateAll() {
        if (this.N1final == 0 && this.N2final == 0) {
            return;
        }
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.update(i1, i2);
            }
        }
    }

    public void setZoomIn(double zoom) {
        if (this.md[HView3D.N1][HView3D.N2].persp) {
            this.md[HView3D.N1][HView3D.N2].minScale /= (float)zoom;
            this.md[HView3D.N1][HView3D.N2].maxScale /= (float)zoom;
            this.md[N1][N2].computeMatrix();
        } else {
            float f = 1.0f / (float)zoom;
            this.md[N1][N2].incScale(f, f, f);
        }
        this.update(N1, N2);
    }

    public void setZoomOut(double zoom) {
        if (this.md[HView3D.N1][HView3D.N2].persp) {
            this.md[HView3D.N1][HView3D.N2].minScale *= (float)zoom;
            this.md[HView3D.N1][HView3D.N2].maxScale *= (float)zoom;
            this.md[N1][N2].computeMatrix();
        } else {
            float f = (float)zoom;
            this.md[N1][N2].incScale(f, f, f);
        }
        this.update(N1, N2);
    }

    public void setMove(double x, double y, double z) {
        this.md[N1][N2].incTrans((float)x, (float)y, (float)z);
        this.update(N1, N2);
    }

    public void setRotate(double x, double y, double z) {
        this.md[N1][N2].incRot((float)x, (float)y, (float)z);
        this.update(N1, N2);
    }

    public HView3D(String title, int xs, int ys) {
        this(title, xs, ys, 1, 1, true);
        this.xsize = xs;
        this.ysize = ys;
    }

    public HView3D(String title, int xs, int ys, boolean set) {
        this(title, xs, ys, 1, 1, set);
        this.xsize = xs;
        this.ysize = ys;
    }

    public HView3D(String title, int xs, int ys, int n1, int n2) {
        this(title, xs, ys, n1, n2, true);
        this.xsize = xs;
        this.ysize = ys;
    }

    public HView3D(String title) {
        this(title, 600, 400, 1, 1, true);
        this.xsize = 600;
        this.ysize = 400;
    }

    public Model3d getModel() {
        return this.md[N1][N2];
    }

    public void draw(Object3d object) {
        this.md[N1][N2].addObject(object);
    }

    public HView3D() {
        this("Default", 600, 400, 1, 1, true);
    }

    public void clear() {
        this.clear(N1, N2);
    }

    public void clear(int i1, int i2) {
        this.setGTitle("");
        System.gc();
    }

    public void clearAll() {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.clear(i1, i2);
            }
        }
        System.gc();
    }

    public void close() {
        this.mainFrame.setVisible(false);
        this.m_Close = new Thread1("Closing softly");
        if (!this.m_Close.Alive()) {
            this.m_Close.Start();
        }
    }

    public void quit() {
        this.doNotShowFrame();
        this.clearAll();
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.canv[i1][i2] = null;
                this.md[i1][i2] = null;
            }
        }
        this.canv = null;
        this.md = null;
        this.removeFrame();
    }

    @Override
    protected void quitFrame() {
        this.close();
    }

    @Override
    protected void showHelp() {
        JOptionPane.showMessageDialog(this.getFrame(), "Not implemented for HGraph");
    }

    @Override
    protected void openReadDataDialog() {
        JOptionPane.showMessageDialog(this.getFrame(), "Not implemented for this canvas");
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }

    class Thread1
    implements Runnable {
        private Thread t = null;
        private String mess;

        Thread1(String s1) {
            this.mess = s1;
        }

        public boolean Alive() {
            boolean tt = false;
            if (this.t != null && this.t.isAlive()) {
                tt = true;
            }
            return tt;
        }

        public boolean Joint() {
            boolean tt = false;
            try {
                this.t.join();
                return true;
            }
            catch (InterruptedException interruptedException) {
                return tt;
            }
        }

        public void Start() {
            this.t = new Thread((Runnable)this, this.mess);
            this.t.start();
        }

        public void Stop() {
            this.t = null;
        }

        @Override
        public void run() {
            HView3D.this.quit();
        }
    }
}

