/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import java.io.InputStream;
import java.net.URL;
import jhplot.gui.HelpBrowser;
import vmm3d.conformalmap.ConformalMap;
import vmm3d.core.Display;
import vmm3d.core.Exhibit;
import vmm3d.core.SaveAndRestore;
import vmm3d.core.UserExhibit;
import vmm3d.core.View;
import vmm3d.polyhedron.RegularPolyhedron;
import vmm3d.spacecurve.parametric.SpaceCurveParametric;
import vmm3d.surface.implicit.SurfaceImplicit;
import vmm3d.surface.parametric.SurfaceParametric;
import vmm3d.xm3d.DisplayXM;
import vmm3d.xm3d.WindowXM;

public class HPlotMX {
    private static final long serialVersionUID = 1L;
    private Exhibit exhibit;
    private View view;
    private String exhibitName = null;
    private WindowXM window;

    public HPlotMX(String exhibitName) {
        DisplayXM.noSplash();
        boolean singleExhibit = false;
        boolean singleGallery = false;
        if (exhibitName != null) {
            try {
                if (exhibitName.endsWith(".xml")) {
                    URL url = new URL(exhibitName);
                    InputStream in = url.openStream();
                    this.exhibit = SaveAndRestore.readExhibitFromXML(in, "Settings File");
                    this.view = this.exhibit.getViews().get(0);
                } else {
                    this.exhibit = (Exhibit)Class.forName(exhibitName).newInstance();
                    if (this.exhibit instanceof UserExhibit) {
                        this.view = ((UserExhibit)((Object)this.exhibit)).getUserExhibitSupport().defaults();
                        if (this.view == null) {
                            throw new Exception("Error while creating user exhibits with default settings");
                        }
                    } else {
                        this.view = this.exhibit.getDefaultView();
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Could not load specified exhibit, \"" + exhibitName + "\".");
                e.printStackTrace();
                singleGallery = false;
                singleExhibit = false;
                this.exhibit = null;
                this.view = null;
            }
        }
        int options = 16;
        this.window = new WindowXM(options);
        if (this.view != null) {
            this.window.getMenus().install(this.view, this.exhibit);
        }
    }

    public HPlotMX() {
        this(null);
    }

    public void clear() {
        this.window.dispose();
    }

    public void draw(Exhibit exhibit) {
        this.exhibit = exhibit;
        this.view = exhibit.getDefaultView();
        this.window.getMenus().install(this.view, exhibit);
    }

    public void draw(SurfaceParametric exhibit) {
        this.view = exhibit.getDefaultView();
        this.window.getMenus().install(this.view, exhibit);
    }

    public void draw(SurfaceImplicit exhibit) {
        this.view = exhibit.getDefaultView();
        this.window.getMenus().install(this.view, exhibit);
    }

    public void draw(RegularPolyhedron exhibit) {
        this.view = exhibit.getDefaultView();
        this.window.getMenus().install(this.view, exhibit);
    }

    public void draw(ConformalMap exhibit) {
        this.view = exhibit.getDefaultView();
        this.window.getMenus().install(this.view, exhibit);
    }

    public void draw(SpaceCurveParametric exhibit) {
        this.view = exhibit.getDefaultView();
        this.window.getMenus().install(this.view, exhibit);
    }

    public void draw(Exhibit exhibit, View view) {
        this.exhibit = exhibit;
        this.view = view;
        this.window.getMenus().install(view, exhibit);
    }

    public boolean export(String file) {
        return this.window.getMenus().export(file);
    }

    public WindowXM getWindowXM() {
        return this.window;
    }

    public Display getDisplay() {
        return this.window.getDisplay();
    }

    public View getView() {
        return this.window.getView();
    }

    public void visible(boolean vs) {
        if (!vs) {
            this.window.setVisible(false);
            return;
        }
        this.window.setVisible(true);
    }

    public void visible() {
        this.visible(true);
    }

    public void close() {
        this.window.dispose();
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

