/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import jehep.ui.SetEnv;
import jhplot.F2D;
import jhplot.gui.HelpBrowser;
import jhplot.utils.Util;
import jv.geom.PgElementSet;
import jv.object.PsConfig;
import jv.object.PsMainFrame;
import jv.object.PsUtil;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.viewer.PvViewer;

public class HJavaView {
    private static final long serialVersionUID = 1L;
    private String exhibitName = "Default";
    private PvViewer viewer;
    private Color background = Color.white;
    private Dimension frameSize;
    private int xsize = 600;
    private int ysize = 400;
    private PsMainFrame frame;
    private JDialog dialog;

    public HJavaView(String exhibitName, int xsize, int ysize, Color background) {
        this.xsize = xsize;
        this.ysize = ysize;
        SetEnv.init();
        String dir = SetEnv.DirPath + SetEnv.fSep + "lib" + SetEnv.fSep + "javaview" + SetEnv.fSep;
        PsConfig.setApplication((boolean)true);
        PsConfig.setCodeBase((String)dir);
        PsConfig.setUserBase((String)dir);
        this.exhibitName = exhibitName;
        this.background = background;
        this.frame = new PsMainFrame(exhibitName, null){

            public void windowClosing(WindowEvent e) {
                HJavaView.this.frame.dispose();
            }

            public void windowClosed(WindowEvent e) {
                HJavaView.this.frame.dispose();
            }
        };
        this.frame.setSize(xsize, ysize);
        this.viewer = new PvViewer(null, (Frame)this.frame);
        this.viewer.setEmbedded(true);
        PvDisplayIf disp = this.viewer.getDisplay();
        disp.setBackgroundColor(this.background);
        this.frame.add((Component)disp, (Object)"Center");
        this.frame.setTitle("HJavaView");
        String license = dir + "rsrc" + SetEnv.fSep + "jv-lic.lic";
        File tempFile = new File(license);
        boolean exists = tempFile.exists();
        if (!exists) {
            final Thread t = new Thread(new ThreadSleep5());
            t.start();
            String mess = "<html><body>Missing license <br>" + license + "<br>Obtain it from http://www.javaview.de/</body></html>";
            this.dialog = new JDialog((Frame)this.frame, false);
            JButton b = new JButton("OK");
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    t.stop();
                    HJavaView.this.dialog.dispose();
                }
            });
            this.dialog.setLayout(new FlowLayout());
            this.dialog.add(new JLabel(mess));
            this.dialog.add(b);
            Util.centreWithin((Component)this.frame, this.dialog);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.pack();
        }
    }

    public HJavaView(String exhibitName, int xsize, int ysize) {
        this(exhibitName, xsize, ysize, Color.white);
    }

    public HJavaView() {
        this("Default", 600, 500, Color.white);
    }

    public void clear() {
        this.frame.dispose();
    }

    public void draw(PgGeometry geom) {
        PvDisplayIf disp = this.viewer.getDisplay();
        disp.addGeometry((PgGeometryIf)geom);
        disp.selectGeometry((PgGeometryIf)geom);
    }

    public void draw(F2D f2d) {
        PvDisplayIf disp = this.viewer.getDisplay();
        PgGeometry geom = this.add(f2d);
        disp.addGeometry((PgGeometryIf)geom);
        disp.selectGeometry((PgGeometryIf)geom);
    }

    public void draw(F2D[] f2d) {
        for (int i = 0; i < f2d.length; ++i) {
            this.draw(this.add(f2d[i]));
        }
    }

    public void draw(PgGeometry[] obj) {
        for (int i = 0; i < obj.length; ++i) {
            this.draw(obj[i]);
        }
    }

    public PgGeometry[] add(F2D[] f2d) {
        PgGeometry[] arr = new PgGeometry[f2d.length];
        for (int i = 0; i < f2d.length; ++i) {
            arr[i] = this.add(f2d[i]);
        }
        return arr;
    }

    public PgGeometry add(F2D f2d) {
        PgElementSet geom = new PgElementSet(3);
        geom.setName(f2d.getTitle());
        int numXLines = f2d.getPoints();
        int numYLines = f2d.getPoints();
        geom.setNumVertices(numXLines * numYLines);
        double xMin = f2d.getMinX();
        double xMax = f2d.getMaxX();
        double yMin = f2d.getMinY();
        double yMax = f2d.getMaxY();
        double dX = (xMax - xMin) / (double)(numXLines - 1);
        double dY = (yMax - yMin) / (double)(numYLines - 1);
        int ind = 0;
        for (int i = 0; i < numXLines; ++i) {
            double x = xMin + (double)i * dX;
            for (int j = 0; j < numYLines; ++j) {
                double y = yMin + (double)j * dY;
                geom.setVertex(ind, x, y, f2d.eval(x, y));
                ++ind;
            }
        }
        geom.makeQuadrConn(numXLines, numYLines);
        geom.makeElementColorsFromXYZ();
        geom.showElementColors(true);
        geom.showEdges(false);
        return geom;
    }

    public boolean export(String file) {
        PvDisplayIf disp = this.viewer.getDisplay();
        disp.getCanvas().repaint();
        String fileExtension = PsUtil.getFileExtension((String)file);
        int n = 61;
        if (fileExtension != null && fileExtension.equalsIgnoreCase("gif")) {
            n = 62;
        } else if (fileExtension != null && fileExtension.equalsIgnoreCase("png")) {
            n = 67;
        } else if (fileExtension != null && fileExtension.equalsIgnoreCase("jpg")) {
            n = 63;
        } else if (fileExtension != null && fileExtension.equalsIgnoreCase("ppm")) {
            n = 65;
        } else if (fileExtension != null && fileExtension.equalsIgnoreCase("eps")) {
            n = 69;
        } else if (fileExtension != null && fileExtension.equalsIgnoreCase("ps")) {
            n = 70;
        } else {
            System.out.println("unknown image file extension: ext = " + fileExtension);
            return false;
        }
        return this.viewer.export(n, file, this.xsize, this.ysize);
    }

    public PvViewer getView() {
        return this.viewer;
    }

    public PsMainFrame getFrame() {
        return this.frame;
    }

    public void visible(boolean vs) {
        if (!vs) {
            this.frame.setVisible(false);
            return;
        }
        this.frame.pack();
        this.frame.setSize(this.xsize, this.ysize);
        this.frame.setVisible(true);
    }

    public void visible() {
        this.visible(true);
    }

    public void close() {
        this.frame.dispose();
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }

    private class ThreadSleep5
    implements Runnable {
        Thread t;

        private ThreadSleep5() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(7000L);
                HJavaView.this.dialog.setVisible(true);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }
}

