/*
 * Decompiled with CFR 0.152.
 */
package graph;

import java.util.Hashtable;

public class ScanString {
    public static final int UNKNOWN = -256;
    public static final int ERROR = -257;
    public static final int NUMBER = -258;
    public static final int EOS = -259;
    private String string;
    private char[] buffer;
    private int count;
    private int position;
    private int kwlength;
    public String sval;
    public double nval;
    private Hashtable kwords = new Hashtable();

    public ScanString() {
        this.string = null;
        this.count = 0;
        this.position = 0;
        this.kwlength = 0;
        this.buffer = new char[32];
        this.sval = null;
        this.nval = 0.0;
    }

    public ScanString(String s) {
        this.setString(s);
    }

    public void setString(String s) {
        if (s == null) {
            return;
        }
        this.string = new String(s);
    }

    public void addKeyWord(String s, int i) {
        if (s == null) {
            return;
        }
        if (this.kwlength < s.length()) {
            this.kwlength = s.length();
        }
        this.kwords.put(s.toLowerCase(), new Integer(i));
    }

    public int getKeyValue(String s) {
        if (s == null) {
            return -256;
        }
        if (!this.kwords.containsKey(s.toLowerCase())) {
            return -256;
        }
        Integer i = (Integer)this.kwords.get(s.toLowerCase());
        if (i == null) {
            return -256;
        }
        return i;
    }

    public void resetKeyWords() {
        this.kwords.clear();
        this.kwlength = 0;
    }

    public int nextWord() {
        int count = 0;
        char[] buffer = new char[this.string.length()];
        boolean exponent = false;
        boolean point = false;
        if (this.position >= this.string.length()) {
            return -259;
        }
        char c = this.string.charAt(this.position);
        while (c == ' ' || c == '\t' || c == '\n' || c == '\u000b' || c == '\r') {
            ++this.position;
            if (this.position >= this.string.length()) {
                return -259;
            }
            c = this.string.charAt(this.position);
        }
        if (c >= '0' && c <= '9' || c == '.') {
            for (int i = this.position; i < this.string.length(); ++i) {
                c = this.string.charAt(i);
                if (exponent && (c < '0' || c > '9')) break;
                if (c == 'E' || c == 'e' || c == 'D' || c == 'd') {
                    exponent = true;
                    buffer[count++] = 101;
                    c = this.string.charAt(i + 1);
                    if (c != '-' && c != '+') continue;
                    buffer[count++] = c;
                    ++i;
                    continue;
                }
                if (point && c == '.') break;
                if (c == '.') {
                    point = true;
                    buffer[count++] = c;
                    continue;
                }
                if (c < '0' || c > '9') break;
                buffer[count++] = c;
            }
            try {
                this.sval = new String(buffer, 0, count);
                this.nval = Double.valueOf(this.sval);
                this.position += count;
                return -258;
            }
            catch (Exception e) {
                return -257;
            }
        }
        int last = -256;
        int nchar = 0;
        int pos = this.position;
        while (pos < this.string.length()) {
            buffer[count++] = this.string.charAt(pos++);
            int word = this.getKeyValue(new String(buffer, 0, count));
            if (word != -256) {
                last = word;
                nchar = count;
                continue;
            }
            if (nchar == 0 && count >= this.kwlength) {
                return -257;
            }
            if (count < this.kwlength) continue;
            this.sval = new String(buffer, 0, nchar);
            this.position += nchar;
            return last;
        }
        if (nchar != 0) {
            this.sval = new String(buffer, 0, nchar);
            this.position += nchar;
            return last;
        }
        return -257;
    }
}

