/*
 * Decompiled with CFR 0.152.
 */
package graph;

import java.io.Serializable;

class Node
implements Serializable {
    public static final int OP = 0;
    public static final int VALUE = 1;
    public static final int INTRINSIC = 2;
    public static final int NULL = 3;
    public static final int INDEPENDENT = 4;
    public static final int GROUP = 5;
    public static final int PARAMETER = 6;
    public static final int P0 = 0;
    public static final int P1 = 1;
    public static final int P2 = 2;
    public static final int P3 = 3;
    public static final int P4 = 4;
    public static final int P5 = 5;
    int type;
    Node left;
    Node right;
    int op;
    double value;
    int precedence;

    public Node() {
        this.type = 3;
        this.left = null;
        this.right = null;
        this.op = 3;
        this.value = 0.0;
        this.precedence = 0;
    }

    public Node(Node n) {
        this.replace(n);
    }

    public void replace(Node n) {
        if (n == null) {
            return;
        }
        this.op = n.op;
        this.type = n.type;
        this.left = n.left;
        this.right = n.right;
        this.value = n.value;
        this.precedence = n.precedence;
    }

    public void indent(int ind) {
        for (int i = 0; i < ind; ++i) {
            System.out.print(" ");
        }
    }

    public void print(int indentLevel) {
        char[] l = new char[1];
        this.indent(indentLevel);
        System.out.println("NODE type=" + this.type);
        this.indent(indentLevel);
        System.out.println("     prec=" + this.precedence);
        this.indent(indentLevel);
        switch (this.type) {
            case 1: {
                System.out.println("     value=" + this.value);
                break;
            }
            case 4: {
                System.out.println("     variable=" + this.op);
                break;
            }
            default: {
                System.out.println("     op=" + this.op);
                if (this.left != null) {
                    this.left.print(indentLevel + 5);
                }
                if (this.right == null) break;
                this.right.print(indentLevel + 5);
            }
        }
    }
}

