/*
 * Decompiled with CFR 0.152.
 */
package fitter;

import fitter.BMark;
import fitter.Fitter;
import fitter.MyTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import jhplot.utils.Util;

public class SEditor
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JTabbedPane tabbedPane;
    private JButton plotButton;
    private JButton closeButton;
    private JButton saveButton;
    private JFrame win;
    private JTable m_table;
    private MyTableModel model;
    private ArrayList<BMark> setting;
    private final Fitter fit;
    protected String[] columnToolTips = new String[]{"parameter ID", "name", "min value", "max value", "initial value", "fixed or not", "parameterID if constrainted"};

    public SEditor(JFrame win, final Fitter fit) {
        this.win = win;
        this.fit = fit;
        this.setDefaultCloseOperation(2);
        this.setTitle("");
        this.setModal(true);
        this.setResizable(true);
        Dimension size = new Dimension(300, 250);
        JPanel topPanel = new JPanel();
        JPanel lowerPanel = new JPanel();
        lowerPanel.setPreferredSize(new Dimension(300, 20));
        this.closeButton = new JButton();
        this.closeButton.setText("Exit");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SEditor.this.setVisible(false);
                SEditor.this.dispose();
            }
        });
        this.plotButton = new JButton();
        this.plotButton.setText("Plot");
        this.plotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                fit.drawFunc();
            }
        });
        this.saveButton = new JButton();
        this.saveButton.setText("Save");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SEditor.this.setting = SEditor.this.getSet();
            }
        });
        lowerPanel.add((Component)this.saveButton, null);
        lowerPanel.add((Component)this.plotButton, null);
        lowerPanel.add((Component)this.closeButton, null);
        topPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)topPanel, "Center");
        this.getContentPane().add((Component)lowerPanel, "South");
        topPanel.setLayout(new BorderLayout());
        lowerPanel.setPreferredSize(new Dimension(80, 40));
        this.model = new MyTableModel();
        this.m_table = new JTable(this.model){
            public static final long serialVersionUID = 126L;

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
                Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
                Color colcell = new Color(255, 250, 240);
                Color colsell = new Color(230, 230, 255);
                Color colselcel = new Color(255, 244, 130);
                if (rowIndex % 2 == 0 && !this.isCellSelected(rowIndex, vColIndex)) {
                    c.setBackground(colcell);
                } else {
                    c.setBackground(this.getBackground());
                }
                if (SEditor.this.m_table.isRowSelected(rowIndex)) {
                    c.setBackground(colselcel);
                }
                return c;
            }

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Object tip = null;
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return SEditor.this.columnToolTips[realIndex];
                    }
                };
            }
        };
        this.m_table.setRowHeight(24);
        this.model.addColumn("No");
        this.model.addColumn("Par");
        this.model.addColumn("min");
        this.model.addColumn("max");
        this.model.addColumn("center");
        this.model.addColumn("fix");
        this.model.addColumn("setTo");
        TableColumn column0 = null;
        column0 = this.m_table.getColumnModel().getColumn(0);
        column0.setPreferredWidth(20);
        column0.setMinWidth(10);
        column0.setMaxWidth(50);
        column0 = this.m_table.getColumnModel().getColumn(5);
        column0.setPreferredWidth(30);
        column0.setMinWidth(20);
        column0.setMaxWidth(50);
        column0 = this.m_table.getColumnModel().getColumn(6);
        column0.setPreferredWidth(40);
        column0.setMinWidth(20);
        column0.setMaxWidth(40);
        JScrollPane scrollPane = new JScrollPane(this.m_table);
        topPanel.add((Component)scrollPane, "Center");
        this.setSize(size);
    }

    public void addRaw(String par, double min, double max, double c, boolean fix, int cons) {
        int nn = this.model.getRowCount() + 1;
        this.model.addRow(new Object[]{new Integer(nn), new String(par), new Double(min), new Double(max), new Double(c), new Boolean(fix), new Integer(cons)});
        this.m_table.repaint();
    }

    public void putSettings(ArrayList<BMark> setting) {
        this.setting = setting;
    }

    public void fillTable() {
        this.removeAll();
        for (int i = 0; i < this.setting.size(); ++i) {
            BMark b = this.setting.get(i);
            this.addRaw(b.getTitle(), b.getMin(), b.getMax(), b.getC(), b.getFix(), b.getCons());
        }
    }

    private ArrayList<BMark> getSet() {
        ArrayList<BMark> bSet = new ArrayList<BMark>();
        int hmax = this.m_table.getRowCount();
        for (int i = 0; i < hmax; ++i) {
            Object tmp1 = this.m_table.getValueAt(i, 1);
            Object tmp2 = this.m_table.getValueAt(i, 2);
            Object tmp3 = this.m_table.getValueAt(i, 3);
            Object tmp4 = this.m_table.getValueAt(i, 4);
            Object tmp5 = this.m_table.getValueAt(i, 5);
            Object tmp6 = this.m_table.getValueAt(i, 6);
            if (tmp1 == null || tmp2 == null || tmp3 == null || tmp4 == null) continue;
            bSet.add(new BMark(tmp1.toString(), (Double)tmp2, (Double)tmp3, (Double)tmp4, (Boolean)tmp5, (Integer)tmp6));
        }
        return bSet;
    }

    public ArrayList<BMark> getSettings() {
        return this.setting;
    }

    public void showIt() {
        Util.rightWithin(this.win, this);
        this.setVisible(true);
    }

    @Override
    public void removeAll() {
        while (this.model.getRowCount() > 0) {
            this.model.removeRow(0);
        }
    }

    public double getDouble(String s) {
        double dd = 0.0;
        try {
            dd = Double.parseDouble(s.trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return dd;
    }

    public boolean getBool(String s) {
        return s.equals("true");
    }
}

