/*
 * Decompiled with CFR 0.152.
 */
package units;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Vector;
import units.Browser;
import units.CommandArgs;
import units.Env;
import units.Tables;
import units.UnitsFile;
import units.UnitsWindow;
import units.Value;

class convert {
    static final String USAGE = "Usage:\n\n  java -jar <jarfile> [options] [from-unit [to-unit]]\n\nCall without 'options', 'from-unit', and 'to-unit' opens graphical interface.\nOptions are:\n\n  -c  suppress printing of tab, '*', and '/' character\n  -e  specify encoding for the dialog\n  -f  specify a units data file (-f \"\" loads default file)\n  -g  specify font for browser window\n  -h  print this help and exit\n  -i  use interactively from command prompt\n  -l  specify locale\n  -q  suppress prompting\n  -r  round last element of unit list output to an integer\n  -s  suppress reciprocal unit conversion (e.g. Hz<->s)\n  -t  terse output (-c -q -s -1)\n  -v  print slightly more verbose output\n  -1  suppress the second line of output\n  -C  check that all units reduce to primitive units\n  -V  describe this version of Units and exit\n\nAfter starting the program, type 'help' at a prompt\nor click on 'Help' button for more help.";
    static final String HELP = " Units converts between different measuring systems.\n Type the measure you want to convert at the 'You have:' prompt.\n Type the desired units at the 'You want:' prompt.\n\n Press return at the 'You want:' prompt to see the measure you entered above\n reduced to primitive units.\n Type '?' at 'You want:' prompt to get a list of conformable units.\n\n At either prompt you can type:\n  'help' to see this message, or\n  'help unit' to explore units database around the definition of 'unit', or\n  'search text' to see the units whose name contains 'text'.\n\n Type 'quit' at either prompt to quit.\n\n Examples of conversions:\n\n EXAMPLE 1. What is 6 feet 7 inches in meters?\n\n   You have: 6 ft + 7 in\n   You want: m\n           6 ft + 7 in = 2.0066 m\n\n Answer: About 2 m.\n\n EXAMPLE 2. What is 2 meters in feet and inches?\n\n   You have: 2 m\n   You want: ft;in;1|8in;;\n     2 m = 6 ft + 6 in + 6|8in (rounded up to nearest 1|8in)\n\n EXAMPLE 3. Thermometer shows 75 degrees Fahrenheit.\n What is the temperature in degrees Celsius?\n\n   You have: tempF(75)\n   You want: tempC\n           tempF(75) = tempC(23.888889)\n\n Answer: About 24 C.\n\n EXAMPLE 4. A European car maker states fuel consumption of the newest model\n as 8 liters per 100 km. What it means in miles per gallon?\n\n   You have: 8 liters / 100 km\n   You want: miles per gallon\n          reciprocal conversion\n           1 / (8 liters / 100 km) = 29.401823 miles per gallon\n\n Answer: About 29.4 mpg. Notice the indication that 'miles per gallon'\n and 'liters per 100 km' are reciprocal dimensions.\n\n EXAMPLE 5. A flow of electrons in a vacuum tube has ben measured as 5 mA.\n How many electrons flow through the tube every second?\n (Hint: units data file defines the electron charge as 'e'.)\n\n   You have: 5 mA\n   You want: e/sec\n           5mA = 3.1207548e16 e/sec\n\n Answer: About 31 200 000 000 000 000.\n\n EXAMPLE 6. What is the energy, in electronvolts, of a photon of yellow sodium light\n with wavelength of 5896 angstroms? (The energy is equal to Planck's constant times\n speed of light divided by the wavelength. The units data file defines the Planck's\n constant as 'h' and the speed of light as 'c'.)\n\n   You have: h * (c/5896 angstroms)\n   You want: e V\n           h * (c/5896 angstroms) = 2.1028526 e V\n\n Answer: About 2.103 eV.\n\n";
    private static Charset charset;

    convert() {
    }

    public static void main(String[] argv) {
        boolean done;
        if (argv.length == 0) {
            UnitsWindow.init();
            return;
        }
        Env.filenames = new Vector();
        Env.filenames.add("units.dat");
        Env.getPersonalUnits();
        Env.locale = "en_US";
        Env.encoding = null;
        Env.font = "Monospaced";
        Env.verbose = 1;
        Env.quiet = false;
        Env.oneline = false;
        Env.strict = false;
        Env.unitcheck = false;
        Env.round = false;
        Env.getProperties();
        CommandArgs cmd = new CommandArgs(argv, "chiqrstv1CV", "efgl", 0, 2);
        if (cmd.nErrors() > 0) {
            Env.out.println(USAGE);
            System.exit(1);
        }
        if (done = convert.processopts(cmd)) {
            System.exit(0);
        }
        if (Env.encoding == null) {
            charset = Charset.defaultCharset();
        } else {
            try {
                charset = Charset.forName(Env.encoding);
            }
            catch (Exception e) {
                System.out.println(e);
                System.exit(1);
            }
        }
        UnitsFile.fileAcc = new UnitsFile.StandAcc();
        Env.out = new myOut();
        boolean ok = Tables.build();
        if (!ok) {
            System.exit(1);
        }
        if (cmd.opt('V')) {
            Env.showAbout();
            System.exit(0);
        }
        if (Env.unitcheck) {
            Tables.check();
            System.exit(0);
        }
        if (cmd.nArgs() > 0) {
            convert.noninteractive(cmd);
        } else {
            convert.interactive();
        }
        System.exit(0);
    }

    private static void noninteractive(CommandArgs cmd) {
        boolean ok;
        Value have;
        String haveDef;
        Env.quiet = true;
        String havestr = cmd.arg(0).trim();
        String wantstr = null;
        if (cmd.nArgs() > 1) {
            wantstr = cmd.arg(1).trim();
        }
        if ((haveDef = Tables.showdef(havestr, false)) != null) {
            Env.out.print(Env.verbose > 0 ? "\tDefinition: " : "\t");
            Env.out.println(haveDef);
            System.exit(0);
        }
        if ((have = Value.fromString(havestr)) == null) {
            System.exit(1);
        }
        if (wantstr == null) {
            haveDef = Tables.showdef(havestr, true);
            if (haveDef != null) {
                Env.out.print(Env.verbose > 0 ? "\tDefinition: " : "\t");
                Env.out.println(haveDef);
                System.exit(0);
            }
            have.completereduce();
            Env.out.println("\t" + havestr + " = " + have.asString());
            System.exit(0);
        }
        if (ok = Env.convert(havestr, have, wantstr)) {
            System.exit(0);
        }
        System.exit(1);
    }

    private static void interactive() {
        String havestr;
        InputStreamReader isr = new InputStreamReader(System.in, charset);
        BufferedReader in = new BufferedReader(isr);
        if (!Env.quiet) {
            Env.out.println(Tables.stat());
        }
        block0: while ((havestr = convert.getuser("You have: ", in)) != null && !havestr.equals("quit")) {
            String wantstr;
            if (convert.ishelpquery(havestr)) continue;
            String haveDef = Tables.showdef(havestr, false);
            if (haveDef != null) {
                Env.out.print(Env.verbose > 0 ? "\tDefinition: " : "\t");
                Env.out.println(haveDef);
                continue;
            }
            Value have = Value.fromString(havestr);
            if (have == null) continue;
            while (true) {
                if ((wantstr = convert.getuser("You want: ", in)) == null) {
                    haveDef = Tables.showdef(havestr, true);
                    if (haveDef != null) {
                        if (Env.verbose > 0) {
                            Env.out.print("\tDefinition: ");
                        }
                        Env.out.println(haveDef);
                        continue block0;
                    }
                    have.completereduce();
                    Env.out.println("\t" + havestr + " = " + have.asString());
                    continue block0;
                }
                if (wantstr.equals("quit")) break block0;
                if (wantstr.equals("?")) {
                    Tables.showConformable(have, havestr);
                    continue;
                }
                if (!convert.ishelpquery(wantstr)) break;
            }
            Env.convert(havestr, have, wantstr);
        }
    }

    private static boolean processopts(CommandArgs cmd) {
        if (cmd.opt('h')) {
            Env.out.println(USAGE);
            return true;
        }
        if (cmd.opt('e')) {
            Env.encoding = cmd.optArg('e');
        }
        if (cmd.opt('f')) {
            Env.filenames = cmd.optArgs('f');
        }
        if (cmd.opt('g')) {
            Env.font = cmd.optArg('g');
        }
        if (cmd.opt('l')) {
            Env.locale = cmd.optArg('l');
        }
        if (cmd.opt('v')) {
            Env.verbose = 2;
        }
        if (cmd.opt('c')) {
            Env.verbose = 0;
        }
        if (cmd.opt('q')) {
            Env.quiet = true;
        }
        if (cmd.opt('1')) {
            Env.oneline = true;
        }
        if (cmd.opt('r')) {
            Env.round = true;
        }
        if (cmd.opt('s')) {
            Env.strict = true;
        }
        if (cmd.opt('C')) {
            Env.unitcheck = true;
        }
        if (cmd.opt('t')) {
            Env.verbose = 0;
            Env.quiet = true;
            Env.strict = true;
            Env.oneline = true;
        }
        return false;
    }

    private static boolean ishelpquery(String s) {
        String str = s.trim();
        if (str.equals("help")) {
            Browser.show("Units help", HELP, 0, 0, false);
            return true;
        }
        if (str.startsWith("help ") || str.startsWith("help\t")) {
            str = str.substring("help ".length(), str.length()).trim();
            Tables.showSource(str);
            return true;
        }
        if (str.equals("search")) {
            Env.out.println("Type 'search text' to see a list of all unit names\ncontaining 'text' as a substring.");
            return true;
        }
        if (str.startsWith("search ") || str.startsWith("search\t")) {
            str = str.substring("search ".length(), str.length()).trim();
            Tables.showMatching(str);
            return true;
        }
        return false;
    }

    private static String getuser(String prompt, BufferedReader in) {
        String reply;
        if (!Env.quiet) {
            Env.out.print(prompt);
        }
        try {
            reply = in.readLine().trim();
        }
        catch (IOException e) {
            Env.out.println(e.toString());
            return null;
        }
        return reply.length() == 0 ? null : reply;
    }

    static /* synthetic */ Charset access$100() {
        return charset;
    }

    private static class myOut
    extends Env.Writer {
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)System.out, convert.access$100());
        BufferedWriter writer = new BufferedWriter(this.osw);

        private myOut() {
        }

        @Override
        void print(String s) {
            try {
                this.writer.write(s);
                this.writer.flush();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                return;
            }
        }

        @Override
        void println(String s) {
            this.print(s + "\n");
        }
    }
}

