/*
 * Decompiled with CFR 0.152.
 */
package units;

import units.Env;
import units.EvalError;
import units.Factor;
import units.Ignore;
import units.Parser;
import units.Product;
import units.Semantics;
import units.SourceString;
import units.Util;

public class Value {
    double factor;
    Product numerator;
    Product denominator;

    public Value() {
        this.factor = 1.0;
        this.numerator = new Product();
        this.denominator = new Product();
    }

    public Value(Value v) {
        this.factor = v.factor;
        this.numerator = new Product(v.numerator);
        this.denominator = new Product(v.denominator);
    }

    public Value copyFrom(Value v) {
        this.factor = v.factor;
        this.numerator = new Product(v.numerator);
        this.denominator = new Product(v.denominator);
        return this;
    }

    public static Value parse(String s) {
        Parser parser = new Parser();
        Semantics sem = parser.semantics();
        SourceString src = new SourceString(s);
        parser.parse(src);
        return sem.result;
    }

    public static Value parse(String s, String parm, Value parmValue) {
        Parser parser = new Parser();
        Semantics sem = parser.semantics();
        sem.parm = parm;
        sem.parmValue = parmValue;
        SourceString src = new SourceString(s);
        parser.parse(src);
        return sem.result;
    }

    public static Value fromString(String s) {
        try {
            Value v = Value.parse(s);
            v.completereduce();
            return v;
        }
        catch (EvalError e) {
            Env.out.println(e.getMessage());
            return null;
        }
    }

    public static Value fromName(String s) {
        Factor[] pu = Factor.split(s);
        if (pu == null) {
            throw new EvalError("Unit '" + s + "' is unknown.");
        }
        Value v = new Value();
        if (pu[0] != null) {
            v.numerator.add(pu[0]);
        }
        if (pu[1] != null) {
            v.numerator.add(pu[1]);
        }
        return v;
    }

    public String asString() {
        StringBuffer sb = new StringBuffer();
        if (this.factor != 1.0) {
            sb.append(Util.shownumber(this.factor));
            sb.append(this.numerator.asString());
        } else {
            sb.append(this.numerator.asString().substring(1));
        }
        if (this.denominator.size() > 0) {
            sb.append(" /").append(this.denominator.asString());
        }
        return sb.toString();
    }

    public void show() {
        Env.out.println(this.asString());
    }

    public boolean isCompatibleWith(Value v, Ignore ignore) {
        return this.numerator.hasSameFactorsAs(v.numerator, ignore) && this.denominator.hasSameFactorsAs(v.denominator, ignore);
    }

    public boolean isNumber() {
        this.completereduce();
        return this.numerator.size() == 0 && this.denominator.size() == 0;
    }

    void add(Value v) {
        this.completereduce();
        v.completereduce();
        if (!this.isCompatibleWith(v, Ignore.NONE)) {
            throw new EvalError("Sum of non-conformable values:\n\t" + this.asString() + "\n\t" + v.asString() + ".");
        }
        this.factor += v.factor;
    }

    void mult(Value v) {
        this.factor *= v.factor;
        this.numerator.add(v.numerator);
        this.denominator.add(v.denominator);
    }

    void div(Value v) {
        if (v.factor == 0.0) {
            throw new EvalError("Division of " + this.asString() + " by zero (" + v.asString() + ").");
        }
        this.factor /= v.factor;
        this.denominator.add(v.numerator);
        this.numerator.add(v.denominator);
    }

    void invert() {
        if (this.factor == 0.0) {
            throw new EvalError("Division by zero (" + this.asString() + ").");
        }
        this.factor = 1.0 / this.factor;
        Product num = this.numerator;
        this.numerator = this.denominator;
        this.denominator = num;
    }

    void power(Value v) {
        if (!v.isNumber()) {
            throw new EvalError("Non-numeric exponent, " + v.asString() + ", of " + this.asString() + ".");
        }
        double p = v.factor;
        if (Math.floor(p) == p) {
            this.power((int)Math.abs(p));
        } else if (Math.floor(1.0 / p) == 1.0 / p) {
            this.root((int)Math.abs(1.0 / p));
        } else {
            if (!this.isNumber()) {
                throw new EvalError("Non-numeric base, " + this.asString() + ", for exponent " + v.asString() + ".");
            }
            Double f = Math.pow(this.factor, Math.abs(p));
            if (Double.isNaN(f)) {
                throw new EvalError("The result of " + this.factor + "^" + p + " is undefined.");
            }
            this.factor = f;
        }
        if (p < 0.0) {
            this.invert();
        }
    }

    void power(int n) {
        if (n < 0) {
            throw new EvalError("Program error: exponent " + n + ".");
        }
        Product num = new Product();
        Product den = new Product();
        double fac = 1.0;
        for (int i = 0; i < n; ++i) {
            fac *= this.factor;
            num.add(this.numerator);
            den.add(this.denominator);
        }
        this.factor = fac;
        this.numerator = num;
        this.denominator = den;
    }

    void root(int n) {
        if (n == 0 || n % 2 == 0 && this.factor < 0.0) {
            throw new EvalError("Illegal n-th root of " + this.asString() + ", n=" + n + ".");
        }
        this.completereduce();
        Product num = this.numerator.root(n);
        Product den = this.denominator.root(n);
        if (num == null || den == null) {
            String nth = n == 2 ? "a square." : (n == 3 ? "a cube." : "an " + n + "-th power.");
            throw new EvalError(this.asString() + " is not " + nth);
        }
        this.numerator = num;
        this.denominator = den;
        this.factor = this.factor >= 0.0 ? Math.pow(this.factor, 1.0 / (double)n) : -Math.pow(-this.factor, 1.0 / (double)n);
    }

    void cancel() {
        int den = 0;
        int num = 0;
        while (num < this.numerator.size() && den < this.denominator.size()) {
            int comp = this.denominator.factor((int)den).name.compareTo(this.numerator.factor((int)num).name);
            if (comp == 0) {
                this.denominator.delete(den);
                this.numerator.delete(num);
                continue;
            }
            if (comp < 0) {
                ++den;
                continue;
            }
            ++num;
        }
    }

    boolean reduceproduct(boolean flip) {
        Product prod;
        boolean didsomething = false;
        Product product = prod = flip ? this.denominator : this.numerator;
        if (flip) {
            this.denominator = new Product();
        } else {
            this.numerator = new Product();
        }
        Product newprod = flip ? this.denominator : this.numerator;
        for (int f = 0; f < prod.size(); ++f) {
            Value newval;
            Factor fact = prod.factor(f);
            String toadd = fact.name;
            if (toadd == null) {
                throw new EvalError("Unit '" + toadd + "' is unknown.");
            }
            if (fact.isPrimitive) {
                newprod.add(fact);
                continue;
            }
            try {
                newval = Value.parse(fact.def);
            }
            catch (EvalError e) {
                throw new EvalError("Invalid definition of '" + toadd + "'. " + e.getMessage());
            }
            if (flip) {
                this.div(newval);
            } else {
                this.mult(newval);
            }
            didsomething = true;
        }
        return didsomething;
    }

    void completereduce() {
        boolean botchanged;
        boolean topchanged;
        do {
            topchanged = this.reduceproduct(false);
            botchanged = this.reduceproduct(true);
        } while (topchanged || botchanged);
        this.cancel();
    }

    static boolean convert(String fromExpr, Value fromValue, String toExpr, Value toValue) {
        Value invfrom = new Value();
        boolean doingrec = false;
        fromExpr = fromExpr.trim();
        toExpr = toExpr.trim();
        if (!fromValue.isCompatibleWith(toValue, Ignore.DIMLESS)) {
            invfrom.factor = 1.0 / fromValue.factor;
            invfrom.numerator = fromValue.denominator;
            invfrom.denominator = fromValue.numerator;
            if (Env.strict || !toValue.isCompatibleWith(invfrom, Ignore.DIMLESS)) {
                Env.out.println("Conformability error");
                Env.out.print(Env.verbose == 2 ? "\t" + fromExpr + " = " : (Env.verbose == 1 ? "\t" : ""));
                fromValue.show();
                Env.out.print(Env.verbose == 2 ? "\t" + toExpr + " = " : (Env.verbose == 1 ? "\t" : ""));
                toValue.show();
                return false;
            }
            Env.out.println("\treciprocal conversion");
            fromValue = invfrom;
            doingrec = true;
        }
        String sep = "";
        String right = "";
        String left = "";
        if (Env.verbose == 2) {
            if ("0123456789".indexOf(toExpr.charAt(0)) >= 0) {
                sep = " *";
            }
            if (doingrec) {
                if (fromExpr.indexOf(47) >= 0) {
                    left = "1 / (";
                    right = ")";
                } else {
                    left = "1 / ";
                }
            }
        }
        if (Env.verbose == 2) {
            Env.out.print("\t" + left + fromExpr + right + " = ");
        } else if (Env.verbose == 1) {
            Env.out.print("\t* ");
        }
        Env.out.print(Util.shownumber(fromValue.factor / toValue.factor));
        if (Env.verbose == 2) {
            Env.out.print(sep + " " + toExpr);
        }
        if (!Env.oneline) {
            if (Env.verbose == 2) {
                Env.out.print("\n\t" + left + fromExpr + right + " = (1 / ");
            } else if (Env.verbose == 1) {
                Env.out.print("\n\t/ ");
            } else {
                Env.out.print("\n");
            }
            Env.out.print(Util.shownumber(toValue.factor / fromValue.factor));
            if (Env.verbose == 2) {
                Env.out.print(")" + sep + " " + toExpr);
            }
        }
        Env.out.println("");
        return true;
    }
}

