/*
 * Decompiled with CFR 0.152.
 */
package units;

import java.util.Hashtable;
import units.Entity;
import units.Env;
import units.EvalError;
import units.Factor;
import units.Ignore;
import units.Location;
import units.Value;

class Unit
extends Factor {
    static Hashtable<String, Unit> table = null;
    static Value one = new Value();

    Unit(String name, Location loc, String def) {
        super(name, loc, def);
    }

    static void define(String name, String def, Location loc) {
        String diag = Entity.checkName(name);
        if (diag != null) {
            Env.out.println(loc.where() + ". Unit '" + name + "' is ignored. Its name " + diag + ".");
            return;
        }
        if (!Unit.hasSubscript(name) && "23456789".indexOf(name.charAt(name.length() - 1)) >= 0) {
            Env.out.println(loc.where() + ". Unit '" + name + "' is ignored. Its name ends with a digit 2-9 without '_'.");
            return;
        }
        Unit old = table.put(name, new Unit(name, loc, def));
        if (old != null) {
            Env.out.println("Unit '" + name + "' defined in " + old.location.where() + ", is redefined in " + loc.where() + ".");
        }
    }

    @Override
    void check() {
        if (Env.verbose == 2) {
            Env.out.println(this.location.where() + ". Doing '" + this.name + "'");
        }
        Value v = null;
        try {
            v = Value.parse(this.name);
            v.completereduce();
        }
        catch (EvalError e) {
            Env.out.println(this.location.where() + ". " + e.getMessage());
            return;
        }
        if (!v.isCompatibleWith(one, Ignore.PRIMITIVE)) {
            Env.out.println(this.location.where() + ". Unit '" + this.name + "' defined as '" + this.def + "' is irreducible.");
        }
    }

    @Override
    boolean conformsTo(Value v) {
        try {
            Value thisvalue = Value.parse(this.def);
            thisvalue.completereduce();
            return thisvalue.isCompatibleWith(v, Ignore.DIMLESS);
        }
        catch (EvalError e) {
            return false;
        }
    }

    @Override
    String desc() {
        return this.isPrimitive ? "<primitive unit>" : "= " + this.def;
    }

    static Unit find(String name) {
        if (table.containsKey(name)) {
            return table.get(name);
        }
        int ulg = name.length();
        if (ulg > 2 && name.charAt(ulg - 1) == 's') {
            String temp = name.substring(0, ulg - 1);
            if (table.containsKey(temp)) {
                return table.get(temp);
            }
            if (ulg > 3 && name.charAt(ulg - 2) == 'e') {
                temp = name.substring(0, ulg - 2);
                if (table.containsKey(temp)) {
                    return table.get(temp);
                }
                if (ulg > 4 && name.charAt(ulg - 3) == 'i' && table.containsKey(temp = name.substring(0, ulg - 3) + "y")) {
                    return table.get(temp);
                }
            }
        }
        return null;
    }

    static boolean hasSubscript(String name) {
        int i = name.lastIndexOf(95);
        if (i < 0 || i == name.length() - 1) {
            return false;
        }
        for (int j = i + 1; j < name.length(); ++j) {
            if ("0123456789,.".indexOf(name.charAt(j)) >= 0) continue;
            return false;
        }
        return true;
    }
}

