/*
 * Decompiled with CFR 0.152.
 */
package units;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import units.Alias;
import units.Browser;
import units.BuiltInFunction;
import units.DefinedFunction;
import units.Entity;
import units.Env;
import units.Factor;
import units.Function;
import units.Location;
import units.Prefix;
import units.Unit;
import units.UnitsFile;
import units.Value;

public class Tables {
    static boolean build() {
        if (Env.filenames.size() >= 25) {
            Env.out.println("At most 25 unit definition files are allowed.");
            return false;
        }
        Unit.table = new Hashtable();
        Prefix.table = new Hashtable();
        BuiltInFunction.table = new Hashtable();
        DefinedFunction.table = new Hashtable();
        Alias.table = new Hashtable();
        int nfiles = Env.filenames.size();
        for (int i = 0; i < nfiles; ++i) {
            UnitsFile file;
            boolean ok;
            String filename = Env.filenames.elementAt(i);
            if (filename.length() == 0) {
                filename = "units.dat";
            }
            if (ok = (file = new UnitsFile(filename)).readunits(0)) continue;
            return false;
        }
        BuiltInFunction.makeTable();
        return true;
    }

    static void clean() {
        Unit.table = null;
        Prefix.table = null;
        BuiltInFunction.table = null;
        DefinedFunction.table = null;
        Alias.table = null;
    }

    static String stat() {
        return Unit.table.size() + " units, " + Prefix.table.size() + " prefixes, " + DefinedFunction.table.size() + " nonlinear units, " + Alias.table.size() + " unit lists.";
    }

    public static void showSource(String name) {
        Location loc;
        Alias a = Alias.table.get(name);
        Function f = DefinedFunction.table.get(name);
        Unit u = Unit.table.get(name);
        Prefix p = Prefix.table.get(name);
        if (a != null) {
            loc = a.location;
        } else if (f != null) {
            loc = f.location;
        } else if (u != null) {
            loc = u.location;
        } else if (p != null) {
            loc = p.location;
        } else {
            Env.out.println("'" + name + "' is not the name of a unit, function, or unit list.");
            return;
        }
        Browser.show(loc.file.name, loc.file.contents, loc.beginChar, loc.endChar, true);
    }

    public static void showConformable(Value have, String havestr) {
        Entity e;
        Vector<Entity> list = new Vector<Entity>();
        Enumeration<Entity> enu = Alias.table.elements();
        while (enu.hasMoreElements()) {
            e = enu.nextElement();
            if (!e.conformsTo(have)) continue;
            list.add(e);
        }
        enu = DefinedFunction.table.elements();
        while (enu.hasMoreElements()) {
            e = enu.nextElement();
            if (!e.conformsTo(have)) continue;
            list.add(e);
        }
        enu = Unit.table.elements();
        while (enu.hasMoreElements()) {
            e = enu.nextElement();
            if (!e.conformsTo(have)) continue;
            list.add(e);
        }
        enu = Prefix.table.elements();
        while (enu.hasMoreElements()) {
            e = enu.nextElement();
            if (!e.conformsTo(have)) continue;
            list.add(e);
        }
        Tables.showListed(list, "Units conformable to " + havestr);
    }

    public static void showMatching(String havestr) {
        Entity e;
        Vector<Entity> list = new Vector<Entity>();
        Enumeration<Entity> enu = Alias.table.elements();
        while (enu.hasMoreElements()) {
            e = enu.nextElement();
            if (!e.name.contains(havestr)) continue;
            list.add(e);
        }
        enu = DefinedFunction.table.elements();
        while (enu.hasMoreElements()) {
            e = enu.nextElement();
            if (!e.name.contains(havestr)) continue;
            list.add(e);
        }
        enu = Unit.table.elements();
        while (enu.hasMoreElements()) {
            e = enu.nextElement();
            if (!e.name.contains(havestr)) continue;
            list.add(e);
        }
        enu = Prefix.table.elements();
        while (enu.hasMoreElements()) {
            e = enu.nextElement();
            if (!e.name.contains(havestr)) continue;
            list.add(e);
        }
        Tables.showListed(list, "Search result for *" + havestr + "*");
    }

    private static void showListed(Vector<Entity> list, String title) {
        Collections.sort(list);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            Entity d = list.elementAt(i);
            sb.append(d.name).append(" ").append(d.desc()).append("\n");
        }
        Browser.show(title, sb.toString(), 0, 0, false);
    }

    static void check() {
        Enumeration<Entity> e = Alias.table.elements();
        while (e.hasMoreElements()) {
            e.nextElement().check();
        }
        e = DefinedFunction.table.elements();
        while (e.hasMoreElements()) {
            ((DefinedFunction)e.nextElement()).check();
        }
        e = Prefix.table.elements();
        while (e.hasMoreElements()) {
            ((Prefix)e.nextElement()).check();
        }
        e = Unit.table.elements();
        while (e.hasMoreElements()) {
            ((Unit)e.nextElement()).check();
        }
    }

    static String showdef(String name, boolean showUnit) {
        if (Entity.checkName(name) != null) {
            return null;
        }
        String def = Alias.showdef(name);
        if (def != null) {
            return def;
        }
        def = DefinedFunction.showdef(name);
        if (def != null) {
            return def;
        }
        if (!showUnit) {
            return null;
        }
        def = Factor.showdef(name);
        if (def != null) {
            return def;
        }
        return null;
    }
}

