/*
 * Decompiled with CFR 0.152.
 */
package units;

import java.util.Vector;
import units.Factor;
import units.Ignore;

class Product {
    private Vector<Factor> factors = new Vector();

    Product() {
    }

    Product(Product p) {
        for (Factor f : p.factors) {
            this.factors.add(f);
        }
    }

    Product add(Factor f) {
        for (int i = 0; i < this.factors.size(); ++i) {
            if (f.compareTo(this.factors.elementAt(i)) > 0) continue;
            this.factors.add(i, f);
            return this;
        }
        this.factors.add(f);
        return this;
    }

    Product add(Product p) {
        for (int i = 0; i < p.size(); ++i) {
            this.add(p.factor(i));
        }
        return this;
    }

    int size() {
        return this.factors.size();
    }

    Factor factor(int i) {
        return this.factors.elementAt(i);
    }

    void delete(int i) {
        this.factors.removeElementAt(i);
    }

    boolean hasSameFactorsAs(Product p, Ignore ignore) {
        int i = 0;
        int j = 0;
        while (true) {
            if (i < this.size() && this.factor(i).ignoredIf(ignore)) {
                ++i;
                continue;
            }
            while (j < p.size() && p.factor(j).ignoredIf(ignore)) {
                ++j;
            }
            if (i == this.size() || j == p.size()) break;
            if (this.factor(i) != p.factor(j)) {
                return false;
            }
            ++i;
            ++j;
        }
        return i == this.size() && j == p.size();
    }

    String asString() {
        StringBuffer sb = new StringBuffer();
        int counter = 1;
        for (int i = 0; i < this.size(); ++i) {
            Factor f = this.factor(i);
            if (i > 0 && f == this.factor(i - 1)) {
                ++counter;
                continue;
            }
            if (counter > 1) {
                sb.append("^" + counter);
            }
            sb.append(" " + f.name);
            counter = 1;
        }
        if (counter > 1) {
            sb.append("^" + counter);
        }
        return sb.toString();
    }

    Product root(int n) {
        Product p = new Product();
        int i = 0;
        while (i < this.size()) {
            Factor f = this.factor(i);
            int j = 1;
            ++i;
            while (i < this.size() && f == this.factor(i)) {
                ++i;
                ++j;
            }
            if (j % n != 0) {
                return null;
            }
            for (int k = 0; k < j / n; ++k) {
                p.add(f);
            }
        }
        return p;
    }
}

