/*
 * Decompiled with CFR 0.152.
 */
package units;

import java.nio.charset.Charset;
import java.util.Vector;
import units.Browser;
import units.Env;
import units.Tables;
import units.UnitsFile;
import units.Value;

public class MainJHPLOT {
    private String havestr;
    private String wantstr;
    private Value have;
    private Value want;
    private Charset charset;
    private String answer;

    public MainJHPLOT() {
        Env.filenames = new Vector();
        Env.filenames.add("units.dat");
        Env.getPersonalUnits();
        Env.locale = "en_US";
        Env.encoding = null;
        Env.font = "Monospaced";
        Env.verbose = 0;
        Env.quiet = true;
        Env.oneline = true;
        Env.strict = false;
        Env.unitcheck = true;
        Env.round = false;
        this.answer = "";
        Env.getProperties();
        if (Env.encoding == null) {
            this.charset = Charset.defaultCharset();
        } else {
            try {
                this.charset = Charset.forName(Env.encoding);
            }
            catch (Exception e) {
                System.out.println(e);
                System.exit(1);
            }
        }
        UnitsFile.fileAcc = new UnitsFile.StandAcc();
        Env.out = new myOut();
        boolean ok = Tables.build();
        if (!ok) {
            System.exit(1);
        }
        Env.quiet = true;
    }

    public void showAbout() {
        Env.showAbout();
    }

    public boolean convert(String havestr, Value have, String wantstr) {
        this.havestr = havestr.trim();
        this.wantstr = wantstr.trim();
        this.answer = "";
        return Env.convert(havestr, have, wantstr);
    }

    public String answer() {
        this.answer = this.answer.trim();
        this.answer = this.answer.replace("\n", "");
        this.answer = this.answer.trim();
        return this.answer;
    }

    public String getExpectedUnits() {
        return this.wantstr;
    }

    public void showConformable() {
        Tables.showConformable(this.have, this.havestr);
    }

    public String eval(String havestr, String wantstr) {
        this.have = Value.fromString(havestr);
        this.havestr = havestr.trim();
        this.wantstr = wantstr.trim();
        if (this.have == null) {
            return "Correct 'You have' expression and try again.";
        }
        if (wantstr.length() == 0) {
            this.have.show();
            return "none";
        }
        this.have.completereduce();
        boolean ok = this.convert(havestr, this.have, wantstr);
        return this.answer();
    }

    public void showSource() {
        Tables.showSource(this.havestr);
    }

    public void search() {
        Tables.showMatching(this.havestr);
    }

    public void search(String tmp) {
        Tables.showMatching(tmp);
    }

    public String showDef(String tmp) {
        String haveDef = Tables.showdef(tmp, true);
        return haveDef;
    }

    public void help() {
        Browser.show("Units help", " Units is a program for computations on values expressed in terms\n of different measurement units. It is an advanced calculator\n that takes care of the units. An example shows how to use it:\n Suppose you want to compute the mass, in pounds, of water\n that fills to the depth of 7 inches a rectangular area measuring\n 5 yards by 4 feet 3 inches. You recall that 1 liter of water\n has the mass of 1 kilogram. To compute the weight, you multiply\n the water's volume by its specific mass, like this:\n\n   5 yds * (4 feet + 3 in) * 7 in * 1 kg/liter\n\n Just type this computation in 'You have' field, enter 'pounds'\n at 'You want', and press 'Compute'. The result is shown like this:\n\n   5 yds * (4 feet + 3 in) * 7 in * 1 kg/liter = 2321.5398 pounds\n\n You do not bother about conversions between yards, inches, feet,\n liters, kilograms, and pounds. The caculator does it all for you.\n\n If you leave 'You want:' field empty, you obtain the result\n reduced to standard primitive units; in this case, 1053.0327 kg.\n Press 'Conformable units' for a list of other units in which\n you can express your result.\n\n Enter a unit name in 'You have:' field and press 'Definition'\n to see the definition of that unit. Press 'Source' to explore\n units database around the definition of that unit. Press 'Search'\n to find units whose names contain the 'You have' string.\n\n You can also use Units for simple conversions:\n\n Feet and inches to meters:\n   You have: 6 ft + 7 in\n   You want: m\n     6 ft + 7 in = 2.0066 m\n\n Meters to feet and inches:\n   You have: 2 m\n   You want: ft;in;1|8in\n     2 m = 6 ft + 6 in + 5.9212598 * 1|8in\n\n Temperature from Fahrenheit to Celsius:\n   You have: tempF(75)\n   You want: tempC\n     tempF(75) = tempC(23.888889)\n\n Reciprocal conversion (volume / distance to distance / volume.):\n   You have: 8 liters / 100 km\n   You want: miles / gallon\n     reciprocal conversion\n     1 / (8 liters / 100 km) = 0.034011497 miles / gallon\n\n Compound result units:\n   You have: 5 mA\n   You want: e/sec\n           5mA = 3.1207548e16 e/sec\n (units data base defines 'e' as the charge of an electron.)\n\n See http://units-in-java.sourceforge.net for user's manual.\n", 0, 0, false);
    }

    private class myOut
    extends Env.Writer {
        private myOut() {
        }

        @Override
        void print(String s) {
            MainJHPLOT.this.answer = MainJHPLOT.this.answer + s;
        }

        @Override
        void println(String s) {
            MainJHPLOT.this.answer = MainJHPLOT.this.answer + s + "\n";
        }
    }
}

