/*
 * Decompiled with CFR 0.152.
 */
package units;

import units.Location;
import units.Util;
import units.Value;

abstract class Entity
implements Comparable<Entity> {
    String name;
    Location location;

    Entity(String name, Location location) {
        this.name = name;
        this.location = location;
    }

    @Override
    public int compareTo(Entity e) {
        return this.name.compareTo(e.name);
    }

    abstract void check();

    abstract boolean conformsTo(Value var1);

    abstract String desc();

    static String checkName(String name) {
        if ("0123456789".indexOf(name.charAt(0)) >= 0) {
            return "begins with a digit";
        }
        if ("_.,~".indexOf(name.charAt(0)) >= 0) {
            return "begins with '" + name.charAt(0) + "'";
        }
        int lg = name.length();
        if (".,_".indexOf(name.charAt(lg - 1)) >= 0) {
            return "ends with '" + name.charAt(lg - 1) + "'";
        }
        int i = Util.indexOf("+-*/|^();#", name, 1);
        if (i < lg) {
            return "contains '" + name.charAt(i) + "'";
        }
        return null;
    }
}

