/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.textures;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureCoords;
import com.jogamp.opengl.util.texture.awt.AWTTextureIO;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.jzy3d.plot3d.rendering.textures.SharedTexture;

public class BufferedImageTexture
extends SharedTexture {
    protected Texture texture;
    protected BufferedImage image;
    protected TextureCoords coords;
    protected float halfWidth;
    protected float halfHeight;

    public BufferedImageTexture(BufferedImage image) {
        this.image = image;
    }

    @Override
    public Texture getTexture(GL gl) {
        if (this.texture == null) {
            this.mount(gl);
        }
        return this.texture;
    }

    @Override
    public void mount(GL gl) {
        try {
            this.load(gl, this.image);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.coords = this.texture.getImageTexCoords();
        this.halfWidth = this.texture.getWidth() / 2;
        this.halfHeight = this.texture.getHeight() / 2;
    }

    protected void load(GL gl, BufferedImage image) throws GLException, IOException {
        this.texture = AWTTextureIO.newTexture(GLProfile.getDefault(), image, false);
        this.texture.setTexParameteri(gl, 10240, 9729);
        this.texture.setTexParameteri(gl, 10241, 9729);
    }

    @Override
    public String getFile() {
        return this.file;
    }

    @Override
    public TextureCoords getCoords() {
        return this.coords;
    }

    @Override
    public float getHalfWidth() {
        return this.halfWidth;
    }

    @Override
    public float getHalfHeight() {
        return this.halfHeight;
    }
}

