/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.enlightables;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import java.util.ArrayList;
import java.util.List;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.events.DrawableChangedEvent;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Normal;
import org.jzy3d.maths.Utils;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.primitives.enlightables.AbstractEnlightable;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.transform.Transform;

public class EnlightablePolygon
extends AbstractEnlightable {
    private boolean hasAlpha = false;
    protected ColorMapper mapper;
    protected List<Point> points = new ArrayList<Point>(4);
    protected Color color;
    protected Coord3d center;

    public EnlightablePolygon() {
        this.bbox = new BoundingBox3d();
        this.center = new Coord3d();
    }

    @Override
    public void draw(GL gl, GLU glu, Camera cam) {
        this.doTransform(gl, glu, cam);
        this.applyMaterial(gl);
        Coord3d norm = Normal.compute(this.points.get((int)0).xyz, this.points.get((int)1).xyz, this.points.get((int)2).xyz);
        if (gl.isGL2()) {
            if (this.facestatus) {
                gl.getGL2().glPolygonMode(1032, 6914);
                if (this.wfstatus) {
                    gl.getGL2().glEnable(32823);
                    gl.getGL2().glPolygonOffset(1.0f, 1.0f);
                }
                gl.getGL2().glBegin(9);
                for (Point p : this.points) {
                    if (this.mapper != null) {
                        Color c = this.mapper.getColor(p.xyz);
                        gl.getGL2().glColor4f(c.r, c.g, c.b, c.a);
                    } else {
                        gl.getGL2().glColor4f(p.rgb.r, p.rgb.g, p.rgb.b, p.rgb.a);
                    }
                    gl.getGL2().glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
                    gl.getGL2().glNormal3f(norm.x, norm.y, norm.z);
                }
                gl.getGL2().glEnd();
                if (this.wfstatus) {
                    gl.glDisable(32823);
                }
            }
            if (this.wfstatus) {
                gl.getGL2().glPolygonMode(1032, 6913);
                gl.glEnable(32823);
                gl.glPolygonOffset(1.0f, 1.0f);
                gl.getGL2().glColor4f(this.wfcolor.r, this.wfcolor.g, this.wfcolor.b, 1.0f);
                gl.glLineWidth(this.wfwidth);
                gl.getGL2().glBegin(9);
                for (Point p : this.points) {
                    gl.getGL2().glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
                    gl.getGL2().glNormal3f(norm.x, norm.y, norm.z);
                }
                gl.getGL2().glEnd();
                gl.glDisable(32823);
            }
        } else {
            if (this.facestatus) {
                GLES2CompatUtils.glPolygonMode(1032, 6914);
                if (this.wfstatus) {
                    gl.glEnable(32823);
                    gl.glPolygonOffset(1.0f, 1.0f);
                }
                GLES2CompatUtils.glBegin(9);
                for (Point p : this.points) {
                    if (this.mapper != null) {
                        Color c = this.mapper.getColor(p.xyz);
                        GLES2CompatUtils.glColor4f(c.r, c.g, c.b, c.a);
                    } else {
                        GLES2CompatUtils.glColor4f(p.rgb.r, p.rgb.g, p.rgb.b, p.rgb.a);
                    }
                    GLES2CompatUtils.glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
                    GLES2CompatUtils.glNormal3f(norm.x, norm.y, norm.z);
                }
                GLES2CompatUtils.glEnd();
                if (this.wfstatus) {
                    gl.glDisable(32823);
                }
            }
            if (this.wfstatus) {
                GLES2CompatUtils.glPolygonMode(1032, 6913);
                gl.glEnable(32823);
                gl.glPolygonOffset(1.0f, 1.0f);
                GLES2CompatUtils.glColor4f(this.wfcolor.r, this.wfcolor.g, this.wfcolor.b, 1.0f);
                gl.glLineWidth(this.wfwidth);
                GLES2CompatUtils.glBegin(9);
                for (Point p : this.points) {
                    GLES2CompatUtils.glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
                    GLES2CompatUtils.glNormal3f(norm.x, norm.y, norm.z);
                }
                GLES2CompatUtils.glEnd();
                gl.glDisable(32823);
            }
        }
    }

    @Override
    public void applyGeometryTransform(Transform transform) {
        for (Point p : this.points) {
            p.xyz = transform.compute(p.xyz);
        }
        this.updateBounds();
    }

    @Override
    public void updateBounds() {
        this.bbox.reset();
        this.bbox.add(this.points);
        this.updateCenter();
    }

    protected void updateCenter() {
        this.center = new Coord3d();
        for (Point p : this.points) {
            this.center = this.center.add(p.xyz);
        }
        this.center = this.center.div(this.points.size());
    }

    public void add(Point point) {
        if (point.rgb.a < 1.0f) {
            this.hasAlpha = true;
        }
        this.points.add(point);
        this.bbox.add(point);
        this.updateCenter();
    }

    public boolean hasAlpha() {
        return this.hasAlpha;
    }

    @Override
    public Coord3d getBarycentre() {
        return this.center;
    }

    public Point get(int p) {
        return this.points.get(p);
    }

    public int size() {
        return this.points.size();
    }

    public void setColorMapper(ColorMapper mapper) {
        this.mapper = mapper;
        this.fireDrawableChanged(new DrawableChangedEvent(this, 2));
    }

    public ColorMapper getColorMapper() {
        return this.mapper;
    }

    public void setColor(Color color) {
        this.color = color;
        for (Point p : this.points) {
            p.setColor(color);
        }
        this.fireDrawableChanged(new DrawableChangedEvent(this, 2));
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public String toString(int depth) {
        return Utils.blanks(depth) + "(EnlightablePolygon) #points:" + this.points.size();
    }
}

