/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import com.jogamp.opengl.GL;
import java.util.ArrayList;
import java.util.List;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.colors.IMultiColorable;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.ScatterMultiColorList;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.transform.Transform;

public class ConcurrentScatterMultiColorList
extends ScatterMultiColorList
implements IMultiColorable {
    public ConcurrentScatterMultiColorList(ColorMapper mapper) {
        this(new ArrayList<Coord3d>(), mapper, 1.0f);
    }

    public ConcurrentScatterMultiColorList(List<Coord3d> coordinates, ColorMapper mapper) {
        this(coordinates, mapper, 1.0f);
    }

    public ConcurrentScatterMultiColorList(List<Coord3d> coordinates, ColorMapper mapper, float width) {
        super(coordinates, mapper, width);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawGLES2() {
        GLES2CompatUtils.glPointSize(this.width);
        GLES2CompatUtils.glBegin(0);
        if (this.coordinates != null) {
            List list = this.coordinates;
            synchronized (list) {
                for (Coord3d coord : this.coordinates) {
                    Color color = this.mapper.getColor(coord);
                    GLES2CompatUtils.glColor4f(color.r, color.g, color.b, color.a);
                    GLES2CompatUtils.glVertex3f(coord.x, coord.y, coord.z);
                }
            }
        }
        GLES2CompatUtils.glEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawGL2(GL gl) {
        gl.getGL2().glPointSize(this.width);
        gl.getGL2().glBegin(0);
        if (this.coordinates != null) {
            List list = this.coordinates;
            synchronized (list) {
                for (Coord3d coord : this.coordinates) {
                    Color color = this.mapper.getColor(coord);
                    gl.getGL2().glColor4f(color.r, color.g, color.b, color.a);
                    gl.getGL2().glVertex3f(coord.x, coord.y, coord.z);
                }
            }
        }
        gl.getGL2().glEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyGeometryTransform(Transform transform) {
        List list = this.coordinates;
        synchronized (list) {
            for (Coord3d c : this.coordinates) {
                c.set(transform.compute(c));
            }
        }
        this.updateBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBounds() {
        this.bbox.reset();
        List list = this.coordinates;
        synchronized (list) {
            for (Coord3d c : this.coordinates) {
                this.bbox.add(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Coord3d c) {
        List list = this.coordinates;
        synchronized (list) {
            this.coordinates.add(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        List list = this.coordinates;
        synchronized (list) {
            this.coordinates.clear();
        }
        this.updateBounds();
    }
}

