/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import com.jogamp.opengl.GL;
import java.util.ArrayList;
import java.util.List;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.ConcurrentLineStrip;
import org.jzy3d.plot3d.primitives.Point;

public class ConcurrentLineStripSplitted
extends ConcurrentLineStrip {
    List<Integer> idOff = new ArrayList<Integer>();

    public ConcurrentLineStripSplitted() {
        super(100);
    }

    public ConcurrentLineStripSplitted(int n) {
        super(n);
    }

    public ConcurrentLineStripSplitted(List<Coord3d> coords) {
        super(coords);
    }

    public ConcurrentLineStripSplitted(Point c1, Point c2) {
        super(c1, c2);
    }

    @Override
    public void drawLineGL2(GL gl) {
        gl.getGL2().glLineWidth(this.wfwidth);
        if (this.wfcolor == null) {
            this.drawLineSegmentsGL2ByPointColor(gl);
        } else {
            this.drawLineSegmentsGL2ByWireColor(gl);
        }
    }

    public void drawLineSegmentsGL2ByPointColor(GL gl) {
        int nOff = 0;
        int nextOff = this.idOff.size() != 0 ? this.idOff.get(nOff) : 0;
        this.begin(gl);
        for (int nPt = 0; nPt <= this.points.size() - 1; ++nPt) {
            Point p = (Point)this.points.get(nPt);
            this.pointColorSelf(gl, p);
            if (nextOff != nPt) continue;
            this.end(gl);
            this.begin(gl);
            if (++nOff > this.idOff.size() - 1) continue;
            nextOff = this.idOff.get(nOff);
        }
        this.end(gl);
    }

    public void drawLineSegmentsGL2ByWireColor(GL gl) {
        int nPt = 0;
        int nOff = 0;
        int nextOff = -1;
        if (this.idOff.size() > 0) {
            nextOff = this.idOff.get(nOff);
        }
        this.begin(gl);
        while (nPt <= this.points.size() - 1) {
            Point p = (Point)this.points.get(nPt);
            this.pointColorWire(gl, p);
            if (nextOff == nPt) {
                this.end(gl);
                this.begin(gl);
                if (++nOff != -1 && nOff <= this.idOff.size() - 1) {
                    nextOff = this.idOff.get(nOff);
                }
            }
            ++nPt;
        }
        this.end(gl);
    }

    public void pointColorWire(GL gl, Point p) {
        gl.getGL2().glColor4f(this.wfcolor.r, this.wfcolor.g, this.wfcolor.b, this.wfcolor.a);
        gl.getGL2().glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
    }

    public void pointColorSelf(GL gl, Point p) {
        gl.getGL2().glColor4f(p.rgb.r, p.rgb.g, p.rgb.b, p.rgb.a);
        gl.getGL2().glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
    }

    public void begin(GL gl) {
        gl.getGL2().glBegin(3);
    }

    public void end(GL gl) {
        gl.getGL2().glEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAndSplit(Point point) {
        List list = this.points;
        synchronized (list) {
            this.idOff.add(this.points.size());
            this.points.add(point);
        }
        this.bbox.add(point);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Point point) {
        List list = this.points;
        synchronized (list) {
            this.points.add(point);
        }
        this.bbox.add(point);
    }
}

