/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.maths;

import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Vector2d;
import org.jzy3d.maths.Vector3d;

public class Angle2d {
    private float x1;
    private float x2;
    private float x3;
    private float y1;
    private float y2;
    private float y3;

    public Angle2d(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3) {
        this.x1 = x1;
        this.x2 = x2;
        this.x3 = x3;
        this.y1 = y1;
        this.y2 = y2;
        this.y3 = y3;
    }

    public Angle2d(Coord2d p1, Coord2d p2, Coord2d p3) {
        this.x1 = p1.x;
        this.x2 = p2.x;
        this.x3 = p3.x;
        this.y1 = p1.y;
        this.y2 = p2.y;
        this.y3 = p3.y;
    }

    public float sin() {
        float x4 = 0.0f;
        float y4 = 0.0f;
        float z4 = (this.x1 - this.x2) * (this.y3 - this.y2) - (this.y1 - this.y2) * (this.x3 - this.x2);
        Vector3d v1 = new Vector3d(this.x1, this.y1, 0.0f, this.x2, this.y2, 0.0f);
        Vector3d v3 = new Vector3d(this.x3, this.y3, 0.0f, this.x2, this.y2, 0.0f);
        Vector3d v4 = new Vector3d(x4, y4, z4, this.x2, this.y2, 0.0f);
        return (float)(z4 >= 0.0f ? 1 : -1) * v4.norm() / (v1.norm() * v3.norm());
    }

    public float cos() {
        Vector2d v1 = new Vector2d(this.x1, this.y1, this.x2, this.y2);
        Vector2d v3 = new Vector2d(this.x3, this.y3, this.x2, this.y2);
        return v1.dot(v3) / (v1.norm() * v3.norm());
    }

    public float angle() {
        double lenP1P3 = Math.sqrt(Math.pow(this.x1 - this.x3, 2.0) + Math.pow(this.y1 - this.y3, 2.0));
        double lenP1P2 = Math.sqrt(Math.pow(this.x1 - this.x2, 2.0) + Math.pow(this.y1 - this.y2, 2.0));
        double lenP3P2 = Math.sqrt(Math.pow(this.x3 - this.x2, 2.0) + Math.pow(this.y3 - this.y2, 2.0));
        double numerator = Math.pow(lenP1P2, 2.0) + Math.pow(lenP3P2, 2.0) - Math.pow(lenP1P3, 2.0);
        double denominator = 2.0 * lenP1P2 * lenP3P2;
        return (float)Math.acos(numerator / denominator);
    }
}

