/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.io.obj;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.jzy3d.maths.BoundingBox3d;

public class OBJFile {
    static Logger logger = Logger.getLogger(OBJFile.class);
    public static final int NumPrimTypes = 4;
    protected List<Float> positions_ = new ArrayList<Float>();
    protected List<Float> normals_ = new ArrayList<Float>();
    protected int posSize_ = 0;
    protected List<Integer> pIndex_ = new ArrayList<Integer>();
    protected List<Integer> nIndex_ = new ArrayList<Integer>();
    protected IntBuffer indices_ = null;
    protected FloatBuffer vertices_ = null;
    protected int pOffset_ = -1;
    protected int nOffset_ = -1;
    protected int vtxSize_ = 0;
    protected int openEdges_ = 0;

    public boolean loadModelFromFilename(String file) {
        URL fileURL = null;
        try {
            fileURL = new URL(file);
        }
        catch (MalformedURLException e) {
            logger.error((Object)e);
            return false;
        }
        return this.loadModelFromURL(fileURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadModelFromURL(URL fileURL) {
        if (fileURL != null) {
            BufferedReader input = null;
            try {
                input = new BufferedReader(new InputStreamReader(fileURL.openStream()));
                String line = null;
                float[] val = new float[4];
                int[][] idx = new int[3][3];
                boolean hasNormals = false;
                block28: while ((line = input.readLine()) != null) {
                    if (line.isEmpty()) continue;
                    switch (line.charAt(0)) {
                        case '#': {
                            continue block28;
                        }
                        case 'v': {
                            switch (line.charAt(1)) {
                                case ' ': {
                                    line = line.substring(line.indexOf(" ") + 1);
                                    val[0] = Float.valueOf(line.substring(0, line.indexOf(" "))).floatValue();
                                    line = line.substring(line.indexOf(" ") + 1);
                                    val[1] = Float.valueOf(line.substring(0, line.indexOf(" "))).floatValue();
                                    line = line.substring(line.indexOf(" ") + 1);
                                    val[2] = Float.valueOf(line).floatValue();
                                    this.positions_.add(Float.valueOf(val[0]));
                                    this.positions_.add(Float.valueOf(val[1]));
                                    this.positions_.add(Float.valueOf(val[2]));
                                    break;
                                }
                                case 'n': {
                                    line = line.substring(line.indexOf(" ") + 1);
                                    val[0] = Float.valueOf(line.substring(0, line.indexOf(" "))).floatValue();
                                    line = line.substring(line.indexOf(" ") + 1);
                                    val[1] = Float.valueOf(line.substring(0, line.indexOf(" "))).floatValue();
                                    line = line.substring(line.indexOf(" ") + 1);
                                    val[2] = Float.valueOf(line).floatValue();
                                    this.normals_.add(Float.valueOf(val[0]));
                                    this.normals_.add(Float.valueOf(val[1]));
                                    this.normals_.add(Float.valueOf(val[2]));
                                }
                            }
                            continue block28;
                        }
                        case 'f': {
                            line = line.substring(line.indexOf(" ") + 1);
                            while (line.startsWith(" ")) {
                                line = line.substring(1);
                            }
                            idx[0][0] = Integer.valueOf(line.substring(0, line.indexOf("//")));
                            line = line.substring(line.indexOf("//") + 2);
                            idx[0][1] = Integer.valueOf(line.substring(0, line.indexOf(" ")));
                            idx[0][0] = idx[0][0] > 0 ? idx[0][0] - 1 : this.positions_.size() - idx[0][0];
                            idx[0][1] = idx[0][1] > 0 ? idx[0][1] - 1 : this.normals_.size() - idx[0][1];
                            line = line.substring(line.indexOf(" ") + 1);
                            idx[1][0] = Integer.valueOf(line.substring(0, line.indexOf("//")));
                            line = line.substring(line.indexOf("//") + 2);
                            idx[1][1] = Integer.valueOf(line.substring(0, line.indexOf(" ")));
                            idx[1][0] = idx[1][0] > 0 ? idx[1][0] - 1 : this.positions_.size() - idx[1][0];
                            idx[1][1] = idx[1][1] > 0 ? idx[1][1] - 1 : this.normals_.size() - idx[1][1];
                            line = line.substring(line.indexOf(" ") + 1);
                            idx[2][0] = Integer.valueOf(line.substring(0, line.indexOf("//")));
                            line = line.substring(line.indexOf("//") + 2);
                            idx[2][1] = Integer.valueOf(line);
                            idx[2][0] = idx[2][0] > 0 ? idx[2][0] - 1 : this.positions_.size() - idx[2][0];
                            idx[2][1] = idx[2][1] > 0 ? idx[2][1] - 1 : this.normals_.size() - idx[2][1];
                            for (int ii = 0; ii < 3; ++ii) {
                                this.pIndex_.add(idx[ii][0]);
                                this.nIndex_.add(idx[ii][1]);
                            }
                            idx[1][0] = idx[2][0];
                            idx[1][1] = idx[2][1];
                            hasNormals = true;
                            continue block28;
                        }
                    }
                }
                if (!hasNormals) {
                    this.normals_.clear();
                    this.nIndex_.clear();
                }
                this.posSize_ = 3;
                boolean bl = true;
                return bl;
            }
            catch (FileNotFoundException kFNF) {
                logger.error((Object)("Unable to find the shader file " + fileURL + " : FileNotFoundException : " + kFNF.getMessage()));
            }
            catch (IOException kIO) {
                logger.error((Object)("Problem reading the shader file " + fileURL + " : IOException : " + kIO.getMessage()));
            }
            catch (NumberFormatException kIO) {
                logger.error((Object)("Problem reading the shader file " + fileURL + " : NumberFormatException : " + kIO.getMessage()));
            }
            finally {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException kFNF) {}
            }
        } else {
            logger.error((Object)"URL was null");
        }
        return false;
    }

    public void compileModel() {
        boolean needsTriangles = true;
        HashMap<IdxSet, Integer> pts = new HashMap<IdxSet, Integer>();
        this.vertices_ = FloatBuffer.allocate((this.pIndex_.size() + this.nIndex_.size()) * 3);
        this.indices_ = IntBuffer.allocate(this.pIndex_.size());
        for (int i = 0; i < this.pIndex_.size(); ++i) {
            IdxSet idx = new IdxSet();
            idx.pIndex = this.pIndex_.get(i);
            idx.nIndex = this.normals_.size() > 0 ? this.nIndex_.get(i) : Integer.valueOf(0);
            if (!pts.containsKey(idx)) {
                if (needsTriangles) {
                    this.indices_.put(pts.size());
                }
                pts.put(idx, pts.size());
                this.vertices_.put(this.positions_.get(idx.pIndex * this.posSize_).floatValue());
                this.vertices_.put(this.positions_.get(idx.pIndex * this.posSize_ + 1).floatValue());
                this.vertices_.put(this.positions_.get(idx.pIndex * this.posSize_ + 2).floatValue());
                if (this.normals_.size() <= 0) continue;
                this.vertices_.put(this.normals_.get(idx.nIndex * 3).floatValue());
                this.vertices_.put(this.normals_.get(idx.nIndex * 3 + 1).floatValue());
                this.vertices_.put(this.normals_.get(idx.nIndex * 3 + 2).floatValue());
                continue;
            }
            if (!needsTriangles) continue;
            this.indices_.put((Integer)pts.get(idx));
        }
        this.pOffset_ = 0;
        this.vtxSize_ = this.posSize_;
        if (this.hasNormals()) {
            this.nOffset_ = this.vtxSize_;
            this.vtxSize_ += 3;
        } else {
            this.nOffset_ = -1;
        }
        this.vertices_.rewind();
        this.indices_.rewind();
    }

    public BoundingBox3d computeBoundingBox() {
        int i;
        float[] minVal = new float[3];
        float[] maxVal = new float[3];
        if (this.positions_.isEmpty()) {
            return null;
        }
        for (i = 0; i < 3; ++i) {
            minVal[i] = 1.0E10f;
            maxVal[i] = -1.0E10f;
        }
        for (i = 0; i < this.positions_.size(); i += 3) {
            float x = this.positions_.get(i).floatValue();
            float y = this.positions_.get(i + 1).floatValue();
            float z = this.positions_.get(i + 2).floatValue();
            minVal[0] = Math.min(minVal[0], x);
            minVal[1] = Math.min(minVal[1], y);
            minVal[2] = Math.min(minVal[2], z);
            maxVal[0] = Math.max(maxVal[0], x);
            maxVal[1] = Math.max(maxVal[1], y);
            maxVal[2] = Math.max(maxVal[2], z);
        }
        return new BoundingBox3d(minVal[0], maxVal[0], minVal[1], maxVal[1], minVal[2], maxVal[2]);
    }

    public void clearNormals() {
        this.normals_.clear();
        this.nIndex_.clear();
    }

    public boolean hasNormals() {
        return this.normals_.size() > 0;
    }

    public int getPositionSize() {
        return this.posSize_;
    }

    public int getNormalSize() {
        return 3;
    }

    public List<Float> getPositions() {
        return this.positions_.size() > 0 ? this.positions_ : null;
    }

    public List<Float> getNormals() {
        return this.normals_.size() > 0 ? this.normals_ : null;
    }

    public List<Integer> getPositionIndices() {
        return this.pIndex_.size() > 0 ? this.pIndex_ : null;
    }

    public List<Integer> getNormalIndices() {
        return this.nIndex_.size() > 0 ? this.nIndex_ : null;
    }

    public int getPositionCount() {
        return this.posSize_ > 0 ? this.positions_.size() / this.posSize_ : 0;
    }

    public int getNormalCount() {
        return this.normals_.size() / 3;
    }

    public int getIndexCount() {
        return this.pIndex_.size();
    }

    public FloatBuffer getCompiledVertices() {
        return this.vertices_;
    }

    public IntBuffer getCompiledIndices() {
        return this.indices_;
    }

    public int getCompiledPositionOffset() {
        return this.pOffset_;
    }

    public int getCompiledNormalOffset() {
        return this.nOffset_;
    }

    public int getCompiledVertexSize() {
        return this.vtxSize_;
    }

    public int getCompiledVertexCount() {
        return (this.pIndex_.size() + this.nIndex_.size()) * 3;
    }

    public int getOpenEdgeCount() {
        return this.openEdges_;
    }

    public class IdxSet {
        Integer pIndex = 0;
        Integer nIndex = 0;

        boolean lessThan(IdxSet rhs) {
            if (this.pIndex < rhs.pIndex) {
                return true;
            }
            return this.pIndex == rhs.pIndex && this.nIndex < rhs.nIndex;
        }
    }

    public static enum PrimType {
        eptNone(0),
        eptPoints(1),
        eptEdges(2),
        eptTriangles(4),
        eptTrianglesWithAdjacency(8),
        eptAll(15);

        int m_iVal = 0;

        private PrimType(int val) {
            this.m_iVal = val;
        }
    }
}

