/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.chart.controllers.keyboard.screenshot;

import com.jogamp.opengl.util.texture.TextureIO;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jzy3d.chart.Chart;
import org.jzy3d.chart.controllers.AbstractController;
import org.jzy3d.chart.controllers.keyboard.screenshot.IScreenshotKeyController;

public class AbstractScreenshotKeyController
extends AbstractController
implements IScreenshotKeyController {
    protected Chart chart;
    protected String outputFile;
    protected List<IScreenshotKeyController.IScreenshotEventListener> listeners = new ArrayList<IScreenshotKeyController.IScreenshotEventListener>(1);

    public AbstractScreenshotKeyController(Chart chart, String outputFile) {
        super(chart);
        this.register(chart);
        this.chart = chart;
        this.outputFile = outputFile;
    }

    @Override
    public void register(Chart chart) {
        super.register(chart);
        chart.getCanvas().addKeyController(this);
    }

    @Override
    public void dispose() {
        for (Chart c : this.targets) {
            c.getCanvas().removeKeyController(this);
        }
        super.dispose();
    }

    @Override
    public void screenshot(Chart chart, String filename) throws IOException {
        File output = new File(filename);
        if (!output.getParentFile().exists()) {
            output.mkdirs();
        }
        TextureIO.write(chart.screenshot(), new File(filename));
    }

    @Override
    public void addListener(IScreenshotKeyController.IScreenshotEventListener listener) {
        this.listeners.add(listener);
    }

    protected void fireDone(String file) {
        for (IScreenshotKeyController.IScreenshotEventListener listener : this.listeners) {
            listener.doneScreenshot(file);
        }
    }

    protected void fireError(String file, Exception e) {
        for (IScreenshotKeyController.IScreenshotEventListener listener : this.listeners) {
            listener.failedScreenshot(file, e);
        }
    }
}

