/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.chart;

import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.util.texture.TextureData;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jzy3d.bridge.IFrame;
import org.jzy3d.chart.ChartScene;
import org.jzy3d.chart.Settings;
import org.jzy3d.chart.controllers.camera.AbstractCameraController;
import org.jzy3d.chart.controllers.keyboard.camera.ICameraKeyController;
import org.jzy3d.chart.controllers.keyboard.screenshot.IScreenshotKeyController;
import org.jzy3d.chart.controllers.mouse.camera.ICameraMouseController;
import org.jzy3d.chart.factories.ChartComponentFactory;
import org.jzy3d.chart.factories.IChartComponentFactory;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Rectangle;
import org.jzy3d.maths.Scale;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.axes.layout.IAxeLayout;
import org.jzy3d.plot3d.rendering.canvas.ICanvas;
import org.jzy3d.plot3d.rendering.canvas.IScreenCanvas;
import org.jzy3d.plot3d.rendering.canvas.Quality;
import org.jzy3d.plot3d.rendering.lights.Light;
import org.jzy3d.plot3d.rendering.view.View;
import org.jzy3d.plot3d.rendering.view.ViewportMode;
import org.jzy3d.plot3d.rendering.view.modes.ViewPositionMode;

public class Chart {
    public static Quality DEFAULT_QUALITY = Quality.Intermediate;
    public static String DEFAULT_WINDOWING_TOOLKIT = "awt";
    protected IChartComponentFactory factory;
    protected Quality quality;
    protected GLCapabilities capabilities;
    protected String windowingToolkit;
    protected ChartScene scene;
    protected View view;
    protected ICanvas canvas;
    protected Coord3d previousViewPointFree;
    protected Coord3d previousViewPointTop;
    protected Coord3d previousViewPointProfile;
    protected ArrayList<AbstractCameraController> controllers;

    public Chart() {
        this(DEFAULT_QUALITY, DEFAULT_WINDOWING_TOOLKIT);
    }

    public Chart(Quality quality) {
        this(quality, DEFAULT_WINDOWING_TOOLKIT);
    }

    public Chart(String windowingToolkit) {
        this(DEFAULT_QUALITY, windowingToolkit);
    }

    public Chart(IChartComponentFactory components, Quality quality) {
        this(components, quality, DEFAULT_WINDOWING_TOOLKIT, Settings.getInstance().getGLCapabilities());
    }

    public Chart(Quality quality, String windowingToolkit) {
        this(new ChartComponentFactory(), quality, windowingToolkit, Settings.getInstance().getGLCapabilities());
    }

    public Chart(IChartComponentFactory factory, Quality quality, String windowingToolkit) {
        this(factory, quality, windowingToolkit, Settings.getInstance().getGLCapabilities());
    }

    public Chart(IChartComponentFactory factory, Quality quality, String windowingToolkit, GLCapabilities capabilities) {
        this.capabilities = capabilities;
        this.windowingToolkit = windowingToolkit;
        this.factory = factory;
        this.quality = quality;
        this.controllers = new ArrayList(1);
        this.scene = factory.newScene(quality.isAlphaActivated());
        this.canvas = factory.newCanvas(this.scene, quality, windowingToolkit, capabilities);
        this.view = this.canvas.getView();
        this.view.setBackgroundColor(Color.WHITE);
        this.view.setChart(this);
    }

    public Chart black() {
        this.getView().setBackgroundColor(Color.BLACK);
        this.getAxeLayout().setGridColor(Color.WHITE);
        this.getAxeLayout().setMainColor(Color.WHITE);
        return this;
    }

    public Chart white() {
        this.getView().setBackgroundColor(Color.WHITE);
        this.getAxeLayout().setGridColor(Color.BLACK);
        this.getAxeLayout().setMainColor(Color.BLACK);
        return this;
    }

    public Chart view2d() {
        IAxeLayout axe = this.getAxeLayout();
        axe.setZAxeLabelDisplayed(false);
        axe.setTickLineDisplayed(false);
        View view = this.getView();
        view.setViewPositionMode(ViewPositionMode.TOP);
        view.setSquared(true);
        view.getCamera().setViewportMode(ViewportMode.STRETCH_TO_FILL);
        return this;
    }

    public Chart add(AbstractDrawable drawable) {
        this.getScene().getGraph().add(drawable);
        return this;
    }

    public IFrame show(Rectangle rectangle, String title) {
        return this.display(rectangle, title);
    }

    public IFrame display(Rectangle rectangle, String title) {
        return this.getFactory().newFrame(this, rectangle, title);
    }

    public void clear() {
        this.scene.clear();
        this.view.shoot();
    }

    public void pauseAnimator() {
        GLAnimatorControl control;
        if (this.canvas != null && this.canvas instanceof IScreenCanvas && (control = ((IScreenCanvas)this.canvas).getAnimator()) != null && control.isAnimating()) {
            control.pause();
        }
    }

    public void resumeAnimator() {
        GLAnimatorControl control;
        if (this.canvas != null && this.canvas instanceof IScreenCanvas && (control = ((IScreenCanvas)this.canvas).getAnimator()) != null && control.isPaused()) {
            control.resume();
        }
    }

    public void startAnimator() {
        GLAnimatorControl control;
        if (this.canvas != null && this.canvas instanceof IScreenCanvas && (control = ((IScreenCanvas)this.canvas).getAnimator()) != null && !control.isStarted()) {
            control.start();
        }
    }

    public void stopAnimator() {
        GLAnimatorControl control;
        if (this.canvas != null && this.canvas instanceof IScreenCanvas && (control = ((IScreenCanvas)this.canvas).getAnimator()) != null) {
            control.stop();
        }
    }

    public void dispose() {
        this.clearControllerList();
        if (this.canvas != null) {
            this.canvas.dispose();
        }
        if (this.scene != null) {
            this.scene.dispose();
        }
        this.canvas = null;
        this.scene = null;
    }

    public void render() {
        this.view.shoot();
    }

    public TextureData screenshot() {
        return this.canvas.screenshot();
    }

    public TextureData screenshot(File file) throws IOException {
        return this.canvas.screenshot(file);
    }

    public void updateProjectionsAndRender() {
        this.getView().shoot();
        this.getView().project();
        this.render();
    }

    public View newView() {
        View v = this.scene.newView(this.canvas, this.quality);
        v.setSlave(true);
        return v;
    }

    public ICameraMouseController addMouseController() {
        return this.getFactory().newMouseController(this);
    }

    public ICameraKeyController addKeyController() {
        return this.getFactory().newKeyController(this);
    }

    public IScreenshotKeyController addScreenshotKeyController() {
        return this.getFactory().newScreenshotKeyController(this);
    }

    public IFrame open(String title, int width, int height) {
        return this.open(title, new Rectangle(0, 0, width, height));
    }

    public IFrame open(String title, Rectangle rect) {
        return this.getFactory().newFrame(this, rect, title);
    }

    public void addController(AbstractCameraController controller) {
        controller.register(this);
        this.controllers.add(controller);
    }

    public void removeController(AbstractCameraController controller) {
        controller.unregister(this);
        this.controllers.remove(controller);
    }

    protected void clearControllerList() {
        for (AbstractCameraController controller : this.controllers) {
            controller.unregister(this);
        }
        this.controllers.clear();
    }

    public List<AbstractCameraController> getControllers() {
        return this.controllers;
    }

    public void addDrawable(AbstractDrawable drawable) {
        this.getScene().getGraph().add(drawable);
    }

    public void addDrawable(AbstractDrawable drawable, boolean updateViews) {
        this.getScene().getGraph().add(drawable, updateViews);
    }

    public void addDrawable(List<? extends AbstractDrawable> drawables, boolean updateViews) {
        this.getScene().getGraph().add(drawables, updateViews);
    }

    public void addDrawable(List<? extends AbstractDrawable> drawables) {
        this.getScene().getGraph().add(drawables);
    }

    public void removeDrawable(AbstractDrawable drawable) {
        this.getScene().getGraph().remove(drawable);
    }

    public void removeDrawable(AbstractDrawable drawable, boolean updateViews) {
        this.getScene().getGraph().remove(drawable, updateViews);
    }

    public Light addLight(Coord3d position) {
        return this.addLight(position, Color.BLUE, new Color(0.8f, 0.8f, 0.8f), Color.WHITE, 1.0f);
    }

    public Light addLight(Coord3d position, Color ambiant, Color diffuse, Color specular, float radius) {
        Light light = new Light();
        light.setPosition(position);
        light.setAmbiantColor(ambiant);
        light.setDiffuseColor(diffuse);
        light.setSpecularColor(specular);
        light.setRepresentationRadius(radius);
        this.getScene().add(light);
        return light;
    }

    public View view() {
        return this.getView();
    }

    public View getView() {
        return this.view;
    }

    public ChartScene getScene() {
        return this.scene;
    }

    public ICanvas getCanvas() {
        return this.canvas;
    }

    public IAxeLayout getAxeLayout() {
        return this.getView().getAxe().getLayout();
    }

    public void setAxeDisplayed(boolean status) {
        this.view.setAxeBoxDisplayed(status);
        this.view.shoot();
    }

    public IChartComponentFactory getFactory() {
        return this.factory;
    }

    public String getWindowingToolkit() {
        return this.windowingToolkit;
    }

    public void setViewPoint(Coord3d viewPoint) {
        this.view.setViewPoint(viewPoint);
        this.view.shoot();
    }

    public Coord3d getViewPoint() {
        return this.view.getViewPoint();
    }

    public void setViewMode(ViewPositionMode mode) {
        ViewPositionMode previous = this.view.getViewMode();
        if (previous == ViewPositionMode.FREE) {
            this.previousViewPointFree = this.view.getViewPoint();
        } else if (previous == ViewPositionMode.TOP) {
            this.previousViewPointTop = this.view.getViewPoint();
        } else if (previous == ViewPositionMode.PROFILE) {
            this.previousViewPointProfile = this.view.getViewPoint();
        }
        this.view.setViewPositionMode(mode);
        if (mode == ViewPositionMode.FREE) {
            this.view.setViewPoint(this.previousViewPointFree == null ? View.DEFAULT_VIEW.clone() : this.previousViewPointFree);
        } else if (mode == ViewPositionMode.TOP) {
            this.view.setViewPoint(this.previousViewPointTop == null ? View.DEFAULT_VIEW.clone() : this.previousViewPointTop);
        } else if (mode == ViewPositionMode.PROFILE) {
            this.view.setViewPoint(this.previousViewPointProfile == null ? View.DEFAULT_VIEW.clone() : this.previousViewPointProfile);
        }
        this.view.shoot();
    }

    public ViewPositionMode getViewMode() {
        return this.view.getViewMode();
    }

    public void setScale(Scale scale, boolean notify) {
        this.view.setScale(scale, notify);
    }

    public void setScale(Scale scale) {
        this.setScale(scale, true);
    }

    public Scale getScale() {
        return new Scale(this.view.getBounds().getZmin(), this.view.getBounds().getZmax());
    }

    public float flip(float y) {
        return (float)this.canvas.getRendererHeight() - y;
    }

    public GLCapabilities getCapabilities() {
        return this.capabilities;
    }
}

