/*
 * Decompiled with CFR 0.152.
 */
package QuasiBayesianInferences;

import BayesianInferences.Inference;
import BayesianNetworks.BayesNet;
import BayesianNetworks.DiscreteFunction;
import BayesianNetworks.ProbabilityFunction;
import BayesianNetworks.ProbabilityVariable;
import CredalSets.ConstantDensityBoundedSet;
import CredalSets.ConstantDensityRatioSet;
import CredalSets.EpsilonContaminatedSet;
import CredalSets.QBProbabilityFunction;
import CredalSets.TotalVariationSet;
import CredalSets.VertexSet;
import QuasiBayesianNetworks.QuasiBayesNet;
import java.util.Enumeration;
import java.util.Vector;

public class QBInference
extends Inference {
    BayesNet original_bn;
    ProbabilityFunction list_of_local_neighborhood_results;
    boolean is_inference_without_local_neighborhoods;

    public QBInference(BayesNet b_n, boolean dpc) {
        super(b_n, dpc);
        this.original_bn = b_n;
        this.transform_network();
    }

    private void transform_network() {
        this.is_inference_without_local_neighborhoods = this.bn instanceof QuasiBayesNet ? ((QuasiBayesNet)this.bn).get_global_neighborhood_type() != 0 || !((QuasiBayesNet)this.bn).are_local_credal_sets_present() : true;
        this.bn = new QuasiBayesNet(this.bn);
        if (this.is_inference_without_local_neighborhoods) {
            return;
        }
        this.bn.set_name("Transformed-Network");
        Vector auxiliary_variables = this.transform_probability_functions_array();
        this.transform_probability_variables_array(auxiliary_variables);
    }

    private Vector transform_probability_functions_array() {
        Vector<ProbabilityVariable> auxiliary_variables = new Vector<ProbabilityVariable>();
        for (int i = 0; i < this.bn.number_probability_functions(); ++i) {
            ProbabilityFunction pf = this.bn.get_probability_function(i);
            if (pf instanceof VertexSet) {
                VertexSet qbpf = (VertexSet)pf;
                VertexSet new_qbpf = qbpf.prepare_auxiliary_variable(this.bn);
                auxiliary_variables.addElement(new_qbpf.get_auxiliary_variable());
                this.bn.set_probability_function(i, new_qbpf);
                continue;
            }
            ProbabilityFunction new_probability_function = new ProbabilityFunction(this.bn, pf.get_variables(), pf.get_values(), (Vector)null);
            this.bn.set_probability_function(i, new_probability_function);
        }
        return auxiliary_variables;
    }

    private void transform_probability_variables_array(Vector auxs) {
        int new_array_size = this.bn.number_variables() + auxs.size();
        ProbabilityVariable[] new_probability_variables = new ProbabilityVariable[new_array_size];
        for (int i = 0; i < this.bn.number_variables(); ++i) {
            ProbabilityVariable new_probability_variable;
            new_probability_variables[i] = new_probability_variable = new ProbabilityVariable(this.bn, this.bn.get_probability_variable(i));
        }
        Enumeration e = auxs.elements();
        for (int j = i; j < new_probability_variables.length; ++j) {
            new_probability_variables[j] = (ProbabilityVariable)e.nextElement();
            new_probability_variables[j].set_index(j);
        }
        this.bn.set_probability_variables(new_probability_variables);
    }

    @Override
    public void inference(String queried_variable_name) {
        super.inference(queried_variable_name);
        this.do_quasi_bayesian_inference();
    }

    @Override
    public void inference(String[] order) {
        this.inference(order);
        this.do_quasi_bayesian_inference();
    }

    protected void do_quasi_bayesian_inference() {
        if (this.is_inference_without_local_neighborhoods) {
            this.inference_without_local_neighborhoods();
        } else {
            this.inference_with_local_neighborhoods();
        }
    }

    private void inference_with_local_neighborhoods() {
        int i;
        int jump = 1;
        DiscreteFunction unnormalized_results = this.bucket_tree.get_unnormalized_result();
        ProbabilityFunction normalized_results = new ProbabilityFunction(this.bn, unnormalized_results.get_variables(), unnormalized_results.get_values(), (Vector)null);
        normalized_results.normalize_first();
        for (i = 1; i < normalized_results.number_variables(); ++i) {
            jump *= normalized_results.get_variable(i).number_values();
        }
        double[] min = new double[normalized_results.get_variable(0).number_values()];
        double[] max = new double[normalized_results.get_variable(0).number_values()];
        for (i = 0; i < normalized_results.get_variable(0).number_values(); ++i) {
            min[i] = 1.0;
            max[i] = 0.0;
            for (int j = 0; j < jump; ++j) {
                double v = normalized_results.get_value(j + i * jump);
                if (v < min[i]) {
                    min[i] = v;
                }
                if (!(v > max[i])) continue;
                max[i] = v;
            }
        }
        this.result = new QBProbabilityFunction(normalized_results, (double[])null, min, max);
        this.list_of_local_neighborhood_results = normalized_results;
    }

    private void inference_without_local_neighborhoods() {
        DiscreteFunction unnormalized = this.bucket_tree.get_unnormalized_result();
        switch (((QuasiBayesNet)this.bn).get_global_neighborhood_type()) {
            case 0: {
                this.result = new ProbabilityFunction(unnormalized, this.bn);
                this.result.normalize();
                break;
            }
            case 2: {
                ProbabilityFunction cdr_res = new ProbabilityFunction(unnormalized, this.bn);
                ConstantDensityRatioSet cdr = new ConstantDensityRatioSet(cdr_res, ((QuasiBayesNet)this.bn).get_global_neighborhood_parameter());
                this.result = cdr.posterior_marginal();
                break;
            }
            case 3: {
                ProbabilityFunction eps_res = new ProbabilityFunction(unnormalized, this.bn);
                EpsilonContaminatedSet eps = new EpsilonContaminatedSet(eps_res, ((QuasiBayesNet)this.bn).get_global_neighborhood_parameter());
                this.result = eps.posterior_marginal();
                break;
            }
            case 4: {
                ProbabilityFunction cdb_res = new ProbabilityFunction(unnormalized, this.bn);
                ConstantDensityBoundedSet cdb = new ConstantDensityBoundedSet(cdb_res, ((QuasiBayesNet)this.bn).get_global_neighborhood_parameter());
                this.result = cdb.posterior_marginal();
                break;
            }
            case 5: {
                ProbabilityFunction tv_res = new ProbabilityFunction(unnormalized, this.bn);
                TotalVariationSet tv = new TotalVariationSet(tv_res, ((QuasiBayesNet)this.bn).get_global_neighborhood_parameter());
                this.result = tv.posterior_marginal();
            }
        }
    }
}

