/*
 * Decompiled with CFR 0.152.
 */
package JavaBayesInterface;

import InferenceGraphs.InferenceGraph;
import InferenceGraphs.InferenceGraphNode;
import JavaBayesInterface.JavaBayesHelpMessages;
import JavaBayesInterface.NetworkPanel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;

class ObserveDialog
extends Dialog {
    NetworkPanel npan;
    InferenceGraph ig;
    InferenceGraphNode node;
    boolean observed;
    Checkbox observedBox;
    List valuesList;

    public ObserveDialog(NetworkPanel network_panel, Frame parent, InferenceGraph i_g, InferenceGraphNode node) {
        super(parent, "Set Observe Value", true);
        this.ig = i_g;
        this.node = node;
        this.npan = network_panel;
        Panel cbp = new Panel();
        cbp.setLayout(new FlowLayout(1));
        this.observed = node.is_observed();
        this.observedBox = new Checkbox("Observed", null, this.observed);
        cbp.add(this.observedBox);
        Panel listp = new Panel();
        listp.setLayout(new GridLayout(1, 1));
        this.valuesList = new List(6, false);
        String[] values = node.get_values();
        for (int i = 0; i < values.length; ++i) {
            this.valuesList.addItem(new String(values[i]));
        }
        if (this.observed) {
            this.valuesList.select(node.get_observed_value());
        }
        listp.add(this.valuesList);
        Panel okp = new Panel();
        okp.setLayout(new FlowLayout(1));
        okp.add(new Button("Ok"));
        okp.add(new Button("Cancel"));
        this.setLayout(new BorderLayout());
        this.add("North", cbp);
        this.add("Center", listp);
        this.add("South", okp);
        this.pack();
    }

    @Override
    public boolean action(Event evt, Object arg) {
        if (evt.target == this.observedBox) {
            this.observed = this.observedBox.getState();
            if (this.observed) {
                this.valuesList.select(0);
            } else {
                this.valuesList.deselect(this.valuesList.getSelectedIndex());
            }
            return super.action(evt, arg);
        }
        if (evt.target == this.valuesList) {
            if (!this.observed) {
                this.observed = true;
                this.observedBox.setState(this.observed);
            }
            return super.action(evt, arg);
        }
        if (arg.equals("Ok")) {
            String selValue = null;
            this.observed = this.observedBox.getState();
            selValue = this.valuesList.getSelectedItem();
            if (this.observed && selValue == null) {
                JavaBayesHelpMessages.show(JavaBayesHelpMessages.observe_error);
                return true;
            }
            if (this.observed) {
                this.node.set_observation_value(selValue);
            } else {
                this.node.clear_observation();
            }
            this.npan.repaint();
            this.dispose();
        } else if (arg.equals("Cancel")) {
            this.dispose();
        } else {
            return super.action(evt, arg);
        }
        return true;
    }
}

