/*
 * Decompiled with CFR 0.152.
 */
package JavaBayesInterface;

import InferenceGraphs.InferenceGraph;
import JavaBayes.JavaBayes;
import JavaBayesInterface.JavaBayesHelpMessages;
import JavaBayesInterface.QuitDialog;
import JavaBayesInterface.ScrollingPanel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;

public class EditorFrame
extends Frame {
    JavaBayes jb;
    Panel cmdPanel;
    Panel editPanel;
    public ScrollingPanel scrollPanel;
    public static final int BIF_FORMAT = 0;
    public static final int XML_FORMAT = 1;
    public static final int BUGS_FORMAT = 2;
    public static final int ALGORITHM_VARIABLE_ELIMINATION = 0;
    public static final int ALGORITHM_BUCKET_TREE = 1;
    int mode_menu_choice = 1;
    boolean what_to_show_bayesian_network_state = false;
    boolean what_to_show_bucket_tree_state = false;
    int save_format = 0;
    private String current_save_filename;
    private int algorithm_type = 0;
    public static final String createLabel = "Create";
    public static final String moveLabel = "Move";
    public static final String deleteLabel = "Delete";
    public static final String queryLabel = "Query";
    public static final String observeLabel = "Observe";
    public static final String editVariableLabel = "Edit Variable";
    public static final String editFunctionLabel = "Edit Function";
    public static final String editNetworkLabel = "Edit Network";

    public EditorFrame(JavaBayes java_bayes, String title) {
        super(title);
        this.jb = java_bayes;
        this.scrollPanel = new ScrollingPanel(this);
        this.cmdPanel = new Panel();
        this.cmdPanel.setLayout(new GridLayout(1, 5));
        this.cmdPanel.add(new Button(createLabel));
        this.cmdPanel.add(new Button(moveLabel));
        this.cmdPanel.add(new Button(deleteLabel));
        this.cmdPanel.add(new Button(queryLabel));
        this.cmdPanel.add(new Button(observeLabel));
        this.editPanel = new Panel();
        this.editPanel.setLayout(new GridLayout(1, 3));
        this.editPanel.add(new Button(editVariableLabel));
        this.editPanel.add(new Button(editFunctionLabel));
        this.editPanel.add(new Button(editNetworkLabel));
        this.setLayout(new BorderLayout(0, 0));
        this.add("North", this.cmdPanel);
        this.add("Center", this.scrollPanel);
        this.add("South", this.editPanel);
        Toolkit t = Toolkit.getDefaultToolkit();
        Dimension d = t.getScreenSize();
        d.width /= 2;
        d.height = d.height * 3 / 4;
        this.resize(d);
    }

    @Override
    public boolean handleEvent(Event evt) {
        if (evt.id == 201 && this.jb != null) {
            new QuitDialog((Frame)this, this.jb, "Quit JavaBayes?", false).show();
        }
        return super.handleEvent(evt);
    }

    @Override
    public boolean action(Event evt, Object arg) {
        if (evt.target instanceof Button) {
            String label = ((Button)evt.target).getLabel();
            if (((String)arg).equals(createLabel)) {
                this.scrollPanel.netPanel.set_mode(label);
                JavaBayesHelpMessages.show(JavaBayesHelpMessages.create_message);
                this.setCursor(0);
            } else if (((String)arg).equals(moveLabel)) {
                this.scrollPanel.netPanel.set_mode(label);
                JavaBayesHelpMessages.show(JavaBayesHelpMessages.move_message);
                this.setCursor(13);
            } else if (((String)arg).equals(deleteLabel)) {
                this.scrollPanel.netPanel.set_mode(label);
                JavaBayesHelpMessages.show(JavaBayesHelpMessages.delete_message);
                this.setCursor(12);
            } else if (((String)arg).equals(queryLabel)) {
                this.set_query_mode();
            } else if (((String)arg).equals(observeLabel)) {
                this.set_observe_mode();
            } else if (((String)arg).equals(editVariableLabel)) {
                this.set_edit_variable_mode();
            } else if (((String)arg).equals(editFunctionLabel)) {
                this.set_edit_function_mode();
            } else if (((String)arg).equals(editNetworkLabel)) {
                this.set_edit_network_mode();
            }
        }
        return true;
    }

    public boolean open(String filename) {
        InferenceGraph ig;
        try {
            if (this.jb.is_applet) {
                return false;
            }
            this.jb.appendText("\nLoading " + filename + "\n");
            ig = new InferenceGraph(filename);
        }
        catch (Exception e) {
            this.jb.appendText(e + "\n");
            return false;
        }
        this.set_inference_graph(ig);
        return true;
    }

    public boolean open_url(String filename) {
        InferenceGraph ig;
        try {
            this.jb.appendText("\nLoading " + filename + "\n");
            ig = new InferenceGraph(new URL(filename));
        }
        catch (Exception e) {
            this.jb.appendText("Exception: " + e + "\n");
            return false;
        }
        this.set_inference_graph(ig);
        return true;
    }

    public boolean save() {
        return this.save(this.current_save_filename);
    }

    public boolean save(String filename) {
        InferenceGraph ig = this.get_inference_graph();
        if (filename == null) {
            this.jb.appendText("\n Filename invalid!");
            return false;
        }
        if (ig == null) {
            this.jb.appendText("\n No Bayesian network to be saved.\n\n");
            return false;
        }
        try {
            FileOutputStream fileout = new FileOutputStream(filename);
            PrintStream out = new PrintStream(fileout);
            switch (this.save_format) {
                case 0: {
                    ig.save_bif(out);
                    break;
                }
                case 1: {
                    ig.save_xml(out);
                    break;
                }
                case 2: {
                    ig.save_bugs(out);
                }
            }
            out.close();
            fileout.close();
        }
        catch (IOException e) {
            this.jb.appendText("Exception: " + e + "\n");
            return false;
        }
        return true;
    }

    public void clear() {
        this.scrollPanel.netPanel.clear();
    }

    public void process_query(InferenceGraph ig, String queried_variable) {
        if (ig == null) {
            this.jb.appendText("\nLoad Bayesian network.\n\n");
            return;
        }
        ByteArrayOutputStream bstream = new ByteArrayOutputStream();
        PrintStream pstream = new PrintStream(bstream);
        if (this.what_to_show_bayesian_network_state) {
            this.print_bayes_net(pstream, ig);
        }
        switch (this.mode_menu_choice) {
            case 1: {
                this.print_marginal(pstream, ig, queried_variable);
                break;
            }
            case 2: {
                this.print_expectation(pstream, ig, queried_variable);
                break;
            }
            case 3: {
                this.print_explanation(pstream, ig);
                break;
            }
            case 4: {
                this.print_full_explanation(pstream, ig);
                break;
            }
            case 5: {
                this.print_sensitivity_analysis(pstream, ig);
            }
        }
        this.jb.appendText(bstream.toString());
        try {
            bstream.close();
            pstream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void print_bayes_net(PrintStream pstream, InferenceGraph ig) {
        ig.print_bayes_net(pstream);
    }

    protected void print_marginal(PrintStream pstream, InferenceGraph ig, String queried_variable) {
        if (this.algorithm_type == 0) {
            ig.print_marginal(pstream, queried_variable, false, this.what_to_show_bucket_tree_state);
        } else if (this.algorithm_type == 1) {
            ig.print_marginal(pstream, queried_variable, true, this.what_to_show_bucket_tree_state);
        } else {
            return;
        }
    }

    protected void print_expectation(PrintStream pstream, InferenceGraph ig, String queried_variable) {
        if (this.algorithm_type == 0) {
            ig.print_expectation(pstream, queried_variable, false, this.what_to_show_bucket_tree_state);
        } else if (this.algorithm_type == 1) {
            ig.print_expectation(pstream, queried_variable, true, this.what_to_show_bucket_tree_state);
        } else {
            return;
        }
    }

    protected void print_explanation(PrintStream pstream, InferenceGraph ig) {
        ig.print_explanation(pstream, this.what_to_show_bucket_tree_state);
    }

    protected void print_full_explanation(PrintStream pstream, InferenceGraph ig) {
        ig.print_full_explanation(pstream, this.what_to_show_bucket_tree_state);
    }

    protected void print_sensitivity_analysis(PrintStream pstream, InferenceGraph ig) {
        ig.print_sensitivity_analysis(pstream);
    }

    public InferenceGraph get_inference_graph() {
        return this.scrollPanel.netPanel.get_inference_graph();
    }

    public void set_inference_graph(InferenceGraph ig) {
        this.scrollPanel.netPanel.load(ig);
    }

    public void set_observe_mode() {
        this.setCursor(1);
        this.scrollPanel.netPanel.set_mode(observeLabel);
        JavaBayesHelpMessages.show(JavaBayesHelpMessages.observe_message);
    }

    public void set_edit_variable_mode() {
        this.setCursor(2);
        this.scrollPanel.netPanel.set_mode(editVariableLabel);
        JavaBayesHelpMessages.show(JavaBayesHelpMessages.edit_message);
    }

    public void set_edit_function_mode() {
        this.setCursor(2);
        this.scrollPanel.netPanel.set_mode(editFunctionLabel);
        JavaBayesHelpMessages.show(JavaBayesHelpMessages.edit_message);
    }

    public void set_edit_network_mode() {
        this.scrollPanel.netPanel.edit_network();
    }

    public void set_query_mode() {
        this.setCursor(0);
        this.scrollPanel.netPanel.set_mode(queryLabel);
        JavaBayesHelpMessages.show(JavaBayesHelpMessages.query_message);
    }

    public int get_mode() {
        return this.mode_menu_choice;
    }

    public String get_current_save_filename() {
        return this.current_save_filename;
    }

    public void set_current_save_filename(String csf) {
        this.current_save_filename = csf;
    }

    public void what_to_show_bucket_tree_action(boolean what_to_show_bucket_tree) {
        this.what_to_show_bucket_tree_state = what_to_show_bucket_tree;
    }

    public void what_to_show_bayesian_network_action(boolean what_to_show_bayesian_network) {
        this.what_to_show_bayesian_network_state = what_to_show_bayesian_network;
    }

    public void posterior_expectation_action() {
        this.mode_menu_choice = 2;
        this.scrollPanel.netPanel.repaint();
    }

    public void posterior_marginal_action() {
        this.mode_menu_choice = 1;
        this.scrollPanel.netPanel.repaint();
    }

    public void estimate_explanation_variables_action() {
        this.mode_menu_choice = 3;
        this.scrollPanel.netPanel.repaint();
    }

    public void estimate_best_configuration_action() {
        this.mode_menu_choice = 4;
        this.scrollPanel.netPanel.repaint();
    }

    public void sensitivity_analysis_action() {
        this.mode_menu_choice = 5;
        this.scrollPanel.netPanel.repaint();
    }

    public void set_save_format(int sf) {
        this.save_format = sf;
    }

    public void set_algorithm(int type) {
        this.algorithm_type = type;
    }
}

