/*
 * Decompiled with CFR 0.152.
 */
package InferenceGraphs;

import BayesianNetworks.BayesNet;
import BayesianNetworks.DiscreteFunction;
import BayesianNetworks.DiscreteVariable;
import BayesianNetworks.ProbabilityFunction;
import BayesianNetworks.ProbabilityVariable;
import CredalSets.QBProbabilityFunction;
import CredalSets.VertexSet;
import InferenceGraphs.InferenceGraph;
import java.awt.Point;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringBufferInputStream;
import java.util.Enumeration;
import java.util.Vector;

public class InferenceGraphNode {
    InferenceGraph ig;
    ProbabilityVariable pv;
    ProbabilityFunction pf;
    Vector parents = new Vector();
    Vector children = new Vector();
    Point pos;
    private final String[] defaultInferenceGraphNodeValues = new String[]{"true", "false"};
    private final BayesNet defaultInferenceGraphNodeBayesNet = null;
    private final Vector defaultInferenceGraphNodeProperties = null;

    InferenceGraphNode(InferenceGraph i_g, String name) {
        this(i_g, name, new Point(100, 100));
    }

    InferenceGraphNode(InferenceGraph i_g, String name, Point position) {
        this.ig = i_g;
        this.pv = new ProbabilityVariable(this.defaultInferenceGraphNodeBayesNet, name, -1, this.defaultInferenceGraphNodeValues, this.defaultInferenceGraphNodeProperties);
        this.init_dists();
        this.pos = position;
    }

    InferenceGraphNode(InferenceGraph i_g, ProbabilityVariable p_v, ProbabilityFunction p_f) {
        this.ig = i_g;
        this.pv = p_v;
        this.pf = p_f;
        this.pos = this.parse_position(p_v);
    }

    InferenceGraphNode(InferenceGraph i_g, ProbabilityVariable p_v, ProbabilityFunction p_f, Point position) {
        this.ig = i_g;
        this.pv = p_v;
        this.pf = p_f;
        this.pos = position;
    }

    void init_dists() {
        DiscreteVariable[] pvs = new ProbabilityVariable[this.parents.size() + 1];
        pvs[0] = this.pv;
        int total_values = this.pv.number_values();
        double new_value = 1.0 / (double)total_values;
        int i = 1;
        Enumeration e = this.parents.elements();
        while (e.hasMoreElements()) {
            InferenceGraphNode pnode = (InferenceGraphNode)e.nextElement();
            pvs[i] = pnode.pv;
            total_values *= pnode.pv.number_values();
            ++i;
        }
        double[] dists = new double[total_values];
        for (i = 0; i < dists.length; ++i) {
            dists[i] = new_value;
        }
        this.pf = new ProbabilityFunction(this.defaultInferenceGraphNodeBayesNet, pvs, dists, this.defaultInferenceGraphNodeProperties);
    }

    void update_position() {
        Vector properties = this.pv.get_properties();
        Vector<String> properties_to_remove = new Vector<String>();
        String final_property = null;
        if (properties != null && properties.size() > 0) {
            String ss;
            Enumeration e = properties.elements();
            while (e.hasMoreElements()) {
                ss = (String)e.nextElement();
                String s = ss.trim();
                if (!s.startsWith("position")) continue;
                properties_to_remove.addElement(ss);
            }
            e = properties_to_remove.elements();
            while (e.hasMoreElements()) {
                ss = (String)e.nextElement();
                this.pv.remove_property(ss);
            }
        }
        final_property = new String("position = (" + this.pos.x + ", " + this.pos.y + ")");
        this.pv.add_property(final_property);
    }

    private Point parse_position(ProbabilityVariable p_v) {
        Point final_position;
        block8: {
            Vector properties = p_v.get_properties();
            final_position = null;
            if (properties.size() == 0) {
                return new Point(100, 100);
            }
            try {
                Enumeration e = properties.elements();
                while (e.hasMoreElements()) {
                    String ss = (String)e.nextElement();
                    String s = ss.trim();
                    if (!s.startsWith("position")) continue;
                    StreamTokenizer st = new StreamTokenizer(new StringBufferInputStream(s));
                    st.parseNumbers();
                    int x = -1;
                    int y = 0;
                    while (true) {
                        int tok = st.nextToken();
                        if (tok != -1) {
                            if (tok != -2) continue;
                            if (x == -1) {
                                x = (int)st.nval;
                                continue;
                            }
                            y = (int)st.nval;
                            final_position = new Point(x, y);
                            continue;
                        }
                        break block8;
                        break;
                    }
                }
            }
            catch (IOException e) {
                final_position = new Point(100, 100);
            }
        }
        if (final_position == null) {
            final_position = new Point(100, 100);
        }
        return final_position;
    }

    public double get_function_value(String[][] variable_value_pairs, int index_extreme_point) {
        if (this.pf instanceof VertexSet) {
            return ((VertexSet)this.pf).evaluate(variable_value_pairs, index_extreme_point);
        }
        return this.pf.evaluate(variable_value_pairs);
    }

    public double[] get_function_values() {
        if (this.pf instanceof VertexSet) {
            double[][] ep = ((VertexSet)this.pf).get_extreme_points();
            return ep[0];
        }
        return this.pf.get_values();
    }

    public double[] get_function_values(int index) {
        if (this.pf instanceof VertexSet) {
            double[][] ep = ((VertexSet)this.pf).get_extreme_points();
            return ep[index];
        }
        return this.pf.get_values();
    }

    public void set_function_values(double[] fv) {
        if (this.pf instanceof VertexSet) {
            ((VertexSet)this.pf).set_extreme_point(0, fv);
        } else {
            this.pf.set_values(fv);
        }
    }

    public void set_function_values(int iep, double[] fv) {
        if (this.pf instanceof VertexSet) {
            ((VertexSet)this.pf).set_extreme_point(iep, fv);
        } else if (iep == 0) {
            this.pf.set_values(fv);
        }
    }

    public void set_function_value(String[][] variable_value_pairs, double val, int index_extreme_point) {
        if (this.pf instanceof VertexSet) {
            ((VertexSet)this.pf).set_value(variable_value_pairs, val, index_extreme_point);
        } else {
            this.pf.set_value(variable_value_pairs, val);
        }
    }

    public String get_name() {
        return this.pv.get_name();
    }

    public void set_name(String n) {
        this.pv.set_name(n);
    }

    public String[] get_all_names() {
        String[] ns = new String[this.pf.number_variables()];
        for (int i = 0; i < ns.length; ++i) {
            ns[i] = this.pf.get_variable(i).get_name();
        }
        return ns;
    }

    public String[] get_values() {
        return this.pv.get_values();
    }

    public String[][] get_all_values() {
        String[][] all_values = new String[this.pf.number_variables()][];
        for (int i = 0; i < this.pf.number_variables(); ++i) {
            DiscreteVariable dv = this.pf.get_variable(i);
            all_values[i] = new String[dv.number_values()];
            for (int j = 0; j < all_values[i].length; ++j) {
                all_values[i][j] = dv.get_value(j);
            }
        }
        return all_values;
    }

    public int get_number_values() {
        return this.pv.number_values();
    }

    public boolean hasParent() {
        return this.pf.number_variables() > 1;
    }

    public Vector get_parents() {
        return this.parents;
    }

    public Vector get_children() {
        return this.children;
    }

    public boolean is_observed() {
        return this.pv.is_observed();
    }

    public boolean is_explanation() {
        return this.pv.is_explanation();
    }

    public int get_observed_value() {
        return this.pv.get_observed_index();
    }

    public int get_pos_x() {
        return this.pos.x;
    }

    public int get_pos_y() {
        return this.pos.y;
    }

    public Vector get_variable_properties() {
        return this.pv.get_properties();
    }

    public void set_variable_properties(Vector prop) {
        this.pv.set_properties(prop);
    }

    public Vector get_function_properties() {
        return this.pf.get_properties();
    }

    public void set_function_properties(Vector prop) {
        this.pf.set_properties(prop);
    }

    public boolean is_credal_set() {
        return this.pf instanceof QBProbabilityFunction;
    }

    public int number_extreme_distributions() {
        if (this.pf instanceof VertexSet) {
            return ((VertexSet)this.pf).get_extreme_points().length;
        }
        return 1;
    }

    public void set_no_local_credal_set() {
        if (this.pf instanceof QBProbabilityFunction) {
            if (this.pf instanceof VertexSet) {
                ((VertexSet)this.pf).compose_values();
            }
            this.pf = new ProbabilityFunction((DiscreteFunction)this.pf, this.pf.get_values());
        }
    }

    public void set_local_credal_set(int number_extreme_points) {
        if (!(this.pf instanceof VertexSet)) {
            this.pf = new VertexSet(this.pf);
        }
        ((VertexSet)this.pf).set_local_credal_set(number_extreme_points);
    }

    public void set_local_credal_set() {
        if (!(this.pf instanceof VertexSet)) {
            this.pf = new VertexSet(this.pf);
        }
    }

    public void set_observation_value(String value) {
        this.pv.set_observed_value(value);
    }

    public void clear_observation() {
        this.pv.set_invalid_observed_index();
    }

    public void set_explanation(boolean flag) {
        if (flag) {
            this.pv.set_explanation_value(0);
        } else {
            this.pv.set_explanation_value(-1);
        }
    }

    public void remove_variable_property(int index) {
        this.pv.remove_property(index);
    }

    public void remove_function_property(int index) {
        this.pf.remove_property(index);
    }

    public void add_variable_property(String s) {
        this.pv.add_property(s);
        this.update_position_from_property(s);
    }

    public void update_position_from_property(String s) {
        if (s.startsWith("position")) {
            Point final_position = null;
            try {
                StreamTokenizer st = new StreamTokenizer(new StringBufferInputStream(s));
                st.parseNumbers();
                int x = -1;
                int y = 0;
                while (true) {
                    int tok = st.nextToken();
                    if (tok != -1) {
                        if (tok != -2) continue;
                        if (x == -1) {
                            x = (int)st.nval;
                            continue;
                        }
                        y = (int)st.nval;
                        final_position = new Point(x, y);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                final_position = new Point(100, 100);
            }
            if (final_position == null) {
                final_position = new Point(100, 100);
            }
            this.pos = final_position;
        }
    }

    public void add_function_property(String prop) {
        this.pf.add_property(prop);
    }
}

