/*
 * Decompiled with CFR 0.152.
 */
package CredalSets;

import BayesianNetworks.BayesNet;
import BayesianNetworks.DiscreteFunction;
import BayesianNetworks.DiscreteVariable;
import BayesianNetworks.ProbabilityFunction;
import BayesianNetworks.ProbabilityVariable;
import CredalSets.FinitelyGeneratedSet;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;

public class VertexSet
extends FinitelyGeneratedSet {
    ProbabilityVariable auxiliary_variable;
    double[][] extreme_points;

    public VertexSet(BayesNet b_n, ProbabilityVariable[] pvs, double[][] ep, Vector prop) {
        super(b_n, pvs, ep[0], prop);
        double[] vals = new double[ep[0].length];
        this.values = vals;
        this.extreme_points = ep;
        this.compose_values();
    }

    public VertexSet(BayesNet b_n, ProbabilityVariable[] pvs, double[] v, Vector prop, double[][] ep) {
        super(b_n, pvs, v, null, null, prop);
        this.extreme_points = ep;
    }

    public VertexSet(ProbabilityFunction pf) {
        super((DiscreteFunction)pf, pf.get_values());
        if (pf instanceof VertexSet) {
            this.extreme_points = ((VertexSet)pf).extreme_points;
        } else {
            this.extreme_points = new double[1][];
            this.extreme_points[0] = pf.get_values();
        }
    }

    public VertexSet(ProbabilityFunction pf, double[] new_values) {
        super((DiscreteFunction)pf, new_values);
        if (pf instanceof VertexSet) {
            this.extreme_points = ((VertexSet)pf).extreme_points;
            this.auxiliary_variable = ((VertexSet)pf).auxiliary_variable;
        } else {
            this.extreme_points = new double[1][];
            this.extreme_points[0] = pf.get_values();
        }
    }

    public VertexSet prepare_auxiliary_variable(BayesNet transformed_bn) {
        if (this.auxiliary_variable != null) {
            return this;
        }
        ProbabilityVariable auxv = this.create_auxiliary_variable(transformed_bn);
        double[] new_values = this.create_new_values(transformed_bn);
        DiscreteVariable[] new_variables = new DiscreteVariable[this.variables.length + 1];
        for (int i = 0; i < this.variables.length; ++i) {
            new_variables[i] = this.variables[i];
        }
        new_variables[i] = auxv;
        VertexSet new_qbpf = new VertexSet(this, new_values);
        new_qbpf.bn = transformed_bn;
        new_qbpf.auxiliary_variable = auxv;
        new_qbpf.variables = new_variables;
        return new_qbpf;
    }

    private double[] create_new_values(BayesNet transformed_bn) {
        double[] new_values = new double[this.extreme_points.length * this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < this.extreme_points.length; ++j) {
                new_values[j + i * this.extreme_points.length] = this.extreme_points[j][i];
            }
        }
        return new_values;
    }

    private ProbabilityVariable create_auxiliary_variable(BayesNet transformed_bn) {
        StringBuffer buffer_auxiliary_variable_name = new StringBuffer("<Transparent:");
        buffer_auxiliary_variable_name.append(this.variables[0].get_name());
        buffer_auxiliary_variable_name.append(">");
        String auxiliary_variable_name = new String(buffer_auxiliary_variable_name);
        String[] auxiliary_variable_values = new String[this.extreme_points.length];
        for (int i = 0; i < auxiliary_variable_values.length; ++i) {
            auxiliary_variable_values[i] = String.valueOf(i);
        }
        ProbabilityVariable auxv = new ProbabilityVariable(transformed_bn, auxiliary_variable_name, -1, auxiliary_variable_values, null);
        auxv.set_type(1);
        return auxv;
    }

    public double evaluate(String[][] variable_value_pairs, int index_extreme_point) {
        int[] value_indexes = new int[this.bn.number_variables()];
        for (int i = 0; i < variable_value_pairs.length; ++i) {
            int index = this.bn.index_of_variable(variable_value_pairs[i][0]);
            ProbabilityVariable pv = this.bn.get_probability_variable(index);
            value_indexes[index] = pv.index_of_value(variable_value_pairs[i][1]);
        }
        int position = this.get_position_from_indexes(this.bn.get_probability_variables(), value_indexes);
        return this.extreme_points[index_extreme_point][position];
    }

    public void set_value(String[][] variable_value_pairs, double val, int index_extreme_point) {
        int[] value_indexes = new int[this.bn.number_variables()];
        for (int i = 0; i < variable_value_pairs.length; ++i) {
            int index = this.bn.index_of_variable(variable_value_pairs[i][0]);
            ProbabilityVariable pv = this.bn.get_probability_variable(index);
            value_indexes[index] = pv.index_of_value(variable_value_pairs[i][1]);
        }
        int pos = this.get_position_from_indexes(this.bn.get_probability_variables(), value_indexes);
        this.extreme_points[index_extreme_point][pos] = val;
        this.compose_values();
    }

    @Override
    public void print(PrintStream out) {
        if (this.variables != null) {
            int j;
            out.print("probability ( ");
            for (j = 0; j < this.variables.length; ++j) {
                out.print(" \"" + this.variables[j].get_name() + "\" ");
            }
            out.print(") {");
            out.println(" //" + this.variables.length + " variable(s) and " + this.values.length + " values");
            if (this.extreme_points != null) {
                for (int i = 0; i < this.extreme_points.length; ++i) {
                    out.print("\ttable ");
                    for (j = 0; j < this.extreme_points[i].length; ++j) {
                        out.print(this.extreme_points[i][j] + " ");
                    }
                    out.println(";");
                }
                out.print(" // Values: ");
            }
            out.print("\ttable ");
            for (j = 0; j < this.values.length; ++j) {
                out.print(this.values[j] + " ");
            }
            out.print(";");
        }
        out.println();
        if (this.properties != null && this.properties.size() > 0) {
            Enumeration e = this.properties.elements();
            while (e.hasMoreElements()) {
                String property = (String)e.nextElement();
                out.println("\tproperty \"" + property + "\" ;");
            }
        }
        out.println("}");
    }

    public void compose_values() {
        if (this.extreme_points == null) {
            return;
        }
        double n = this.extreme_points.length;
        for (int i = 0; i < this.values.length; ++i) {
            double aux = 0.0;
            for (int j = 0; j < this.extreme_points.length; ++j) {
                aux += this.extreme_points[j][i];
            }
            this.values[i] = aux / n;
        }
    }

    public void set_local_credal_set(int number_extreme_points) {
        int number_current_extreme_points;
        this.compose_values();
        if (this.extreme_points == null) {
            number_current_extreme_points = 0;
        } else {
            number_current_extreme_points = this.extreme_points.length;
            if (number_extreme_points == number_current_extreme_points) {
                return;
            }
        }
        double[][] new_extreme_points = new double[number_extreme_points][this.values.length];
        if (number_extreme_points > number_current_extreme_points) {
            int j;
            for (int i = 0; i < number_current_extreme_points; ++i) {
                for (j = 0; j < this.extreme_points[i].length; ++j) {
                    new_extreme_points[i][j] = this.extreme_points[i][j];
                }
            }
            for (int k = i; k < new_extreme_points.length; ++k) {
                for (j = 0; j < this.values.length; ++j) {
                    new_extreme_points[k][j] = this.values[j];
                }
            }
        } else {
            for (int i = 0; i < new_extreme_points.length; ++i) {
                for (int j = 0; j < this.values.length; ++j) {
                    new_extreme_points[i][j] = this.extreme_points[i][j];
                }
            }
        }
        this.extreme_points = new_extreme_points;
    }

    public void set_extreme_point(int index, double[] ep) {
        this.extreme_points[index] = ep;
    }

    public ProbabilityVariable get_auxiliary_variable() {
        return this.auxiliary_variable;
    }

    public double[][] get_extreme_points() {
        return this.extreme_points;
    }
}

