/*
 * Decompiled with CFR 0.152.
 */
package CredalSets;

import BayesianNetworks.BayesNet;
import BayesianNetworks.DiscreteFunction;
import BayesianNetworks.DiscreteVariable;
import BayesianNetworks.ProbabilityFunction;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;

public class QBProbabilityFunction
extends ProbabilityFunction {
    double[] lower_envelope;
    double[] upper_envelope;

    public QBProbabilityFunction() {
    }

    public QBProbabilityFunction(BayesNet b_n, int n_vb, int n_vl, Vector prop) {
        super(b_n, n_vb, n_vl, prop);
        this.lower_envelope = new double[n_vl];
        this.upper_envelope = new double[n_vl];
    }

    public QBProbabilityFunction(BayesNet b_n, DiscreteVariable[] dvs, double[] v, double[] lp, double[] up, Vector prop) {
        super(b_n, dvs, v, prop);
        this.lower_envelope = lp;
        this.upper_envelope = up;
    }

    public QBProbabilityFunction(DiscreteFunction df, double[] new_values, double[] new_lp, double[] new_up) {
        super(df, new_values);
        this.lower_envelope = new_lp;
        this.upper_envelope = new_up;
    }

    @Override
    public void print() {
        this.print(System.out);
    }

    @Override
    public void print(PrintStream out) {
        if (this.variables != null) {
            int j;
            out.print(" envelope ( ");
            for (j = 0; j < this.variables.length; ++j) {
                out.print(" \"" + this.variables[j].get_name() + "\" ");
            }
            out.print(") {");
            if (this.lower_envelope != null) {
                out.println(" //" + this.variables.length + " variable(s) and " + this.lower_envelope.length + " values");
                out.print("\ttable lower-envelope ");
                for (j = 0; j < this.lower_envelope.length; ++j) {
                    out.print(this.lower_envelope[j] + " ");
                }
                out.print(";");
            }
            out.println();
            if (this.upper_envelope != null) {
                out.print("\ttable upper-envelope ");
                for (j = 0; j < this.upper_envelope.length; ++j) {
                    out.print(this.upper_envelope[j] + " ");
                }
                out.print(";");
            }
        }
        out.println();
        if (this.properties != null && this.properties.size() > 0) {
            Enumeration e = this.properties.elements();
            while (e.hasMoreElements()) {
                String property = (String)e.nextElement();
                out.println("\tproperty \"" + property + "\" ;");
            }
        }
        out.println("}");
    }

    public double[] get_lower_envelope() {
        return this.lower_envelope;
    }

    public double[] get_upper_envelope() {
        return this.upper_envelope;
    }
}

