/*
 * Decompiled with CFR 0.152.
 */
package BayesianNetworks;

import BayesianNetworks.BayesNet;
import BayesianNetworks.DiscreteVariable;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;

public class ProbabilityVariable
extends DiscreteVariable {
    protected int type = 0;
    protected int observed_index = -1;
    protected int explanation_index = -1;
    protected Vector properties;
    protected BayesNet bn;
    public static final int CHANCE = 0;
    public static final int TRANSPARENT = 1;
    static final String observed_property_name = "observed";
    static final String explanation_property_name = "explanation";

    public ProbabilityVariable() {
    }

    public ProbabilityVariable(BayesNet b_n, String n_vb, Vector p) {
        super(n_vb);
        this.properties = p;
        this.bn = b_n;
    }

    public ProbabilityVariable(BayesNet b_n, String n_vb, int vi, String[] vl, Vector p) {
        super(n_vb, vi, vl);
        this.properties = p;
        this.bn = b_n;
    }

    public ProbabilityVariable(ProbabilityVariable pv) {
        super(pv);
        this.observed_index = pv.observed_index;
        this.explanation_index = pv.explanation_index;
        this.type = pv.type;
        this.properties = pv.properties;
        this.bn = pv.bn;
    }

    public ProbabilityVariable(BayesNet b_n, ProbabilityVariable pv) {
        super(pv);
        this.observed_index = pv.observed_index;
        this.explanation_index = pv.explanation_index;
        this.type = pv.type;
        this.properties = pv.properties;
        this.bn = b_n;
    }

    void process_properties() {
        String property;
        Vector<String> properties_to_remove = new Vector<String>();
        Enumeration e = this.properties.elements();
        while (e.hasMoreElements()) {
            String property_value;
            String keyword;
            String pp = (String)e.nextElement();
            property = pp.trim();
            if (property.startsWith(keyword = observed_property_name) || property.equals(keyword)) {
                properties_to_remove.addElement(pp);
                property_value = property.substring(keyword.length()).trim();
                this.observed_index = this.index_of_value(property_value);
                continue;
            }
            keyword = explanation_property_name;
            if (!property.startsWith(keyword) && !property.equals(keyword)) continue;
            properties_to_remove.addElement(pp);
            property_value = property.substring(keyword.length()).trim();
            this.explanation_index = this.index_of_value(property_value);
            if (this.explanation_index != -1) continue;
            this.explanation_index = 0;
        }
        e = properties_to_remove.elements();
        while (e.hasMoreElements()) {
            property = (String)e.nextElement();
            this.properties.removeElement(property);
        }
    }

    public void save_xml_0_3(PrintStream out) {
        if (this == null) {
            return;
        }
        out.println("<VARIABLE TYPE=\"nature\">");
        if (this.name != null) {
            out.println("\t<NAME>" + this.name + "</NAME>");
        }
        if (this.values != null) {
            for (int i = 0; i < this.values.length; ++i) {
                out.println("\t<OUTCOME>" + this.values[i] + "</OUTCOME>");
            }
        }
        if (this.is_explanation()) {
            out.println("\t<PROPERTY>explanation " + this.values[this.explanation_index] + "</PROPERTY>");
        }
        if (this.is_observed()) {
            out.println("\t<PROPERTY>observed " + this.values[this.observed_index] + "</PROPERTY>");
        }
        if (this.properties != null && this.properties.size() > 0) {
            Enumeration e = this.properties.elements();
            while (e.hasMoreElements()) {
                String property = (String)e.nextElement();
                out.println("\t<PROPERTY>" + property + "</PROPERTY>");
            }
        }
        out.println("</VARIABLE>\n");
    }

    public void save_xml(PrintStream out) {
        if (this == null) {
            return;
        }
        out.println("<VARIABLE>");
        if (this.name != null) {
            out.println("\t<NAME>" + this.name + "</NAME>");
        }
        if (this.values != null) {
            out.println("\t<TYPE>discrete</TYPE>");
            for (int i = 0; i < this.values.length; ++i) {
                out.println("\t<VALUE>" + this.values[i] + "</VALUE>");
            }
        }
        if (this.is_explanation()) {
            out.println("\t<PROPERTY>explanation " + this.values[this.explanation_index] + "</PROPERTY>");
        }
        if (this.is_observed()) {
            out.println("\t<PROPERTY>observed " + this.values[this.observed_index] + "</PROPERTY>");
        }
        if (this.properties != null && this.properties.size() > 0) {
            Enumeration e = this.properties.elements();
            while (e.hasMoreElements()) {
                String property = (String)e.nextElement();
                out.println("\t<PROPERTY>" + property + "</PROPERTY>");
            }
        }
        out.println("</VARIABLE>\n");
    }

    @Override
    public void print(PrintStream out) {
        if (this == null) {
            return;
        }
        out.print("variable ");
        if (this.name != null) {
            out.print(" \"" + this.name + "\" ");
        }
        out.print("{");
        if (this.values != null) {
            out.println(" //" + this.values.length + " values");
            out.print("\ttype discrete[" + this.values.length + "] { ");
            for (int i = 0; i < this.values.length; ++i) {
                out.print(" \"" + this.values[i] + "\" ");
            }
            out.println("};");
        }
        if (this.is_explanation()) {
            out.println("\tproperty \"explanation " + this.values[this.explanation_index] + "\" ;");
        }
        if (this.is_observed()) {
            out.println("\tproperty \"observed " + this.values[this.observed_index] + "\" ;");
        }
        if (this.properties != null && this.properties.size() > 0) {
            Enumeration e = this.properties.elements();
            while (e.hasMoreElements()) {
                String property = (String)e.nextElement();
                out.println("\tproperty \"" + property + "\" ;");
            }
        }
        out.println("}");
    }

    public int get_type() {
        return this.type;
    }

    public boolean is_explanation() {
        return this.explanation_index != -1;
    }

    public boolean is_observed() {
        return this.observed_index != -1;
    }

    public void set_observed_value(String v) {
        int index = this.index_of_value(v);
        if (index == -1) {
            return;
        }
        this.observed_index = index;
    }

    public void set_explanation_value(int i) {
        this.explanation_index = i;
    }

    public void add_property(String prop) {
        if (this.properties == null) {
            this.properties = new Vector();
        }
        this.properties.addElement(prop);
    }

    public void remove_property(String prop) {
        if (this.properties == null) {
            return;
        }
        this.properties.removeElement(prop);
    }

    public void remove_property(int i) {
        if (this.properties == null) {
            return;
        }
        this.properties.removeElementAt(i);
    }

    public int get_observed_index() {
        return this.observed_index;
    }

    public int get_explanation_index() {
        return this.explanation_index;
    }

    public Vector get_properties() {
        return this.properties;
    }

    public void set_properties(Vector prop) {
        this.properties = prop;
    }

    public Enumeration get_enumerated_properties() {
        return this.properties.elements();
    }

    public void set_index(int ind) {
        this.index = ind;
    }

    public void set_invalid_index() {
        this.index = -1;
    }

    public void set_invalid_observed_index() {
        this.observed_index = -1;
    }

    public void set_type(int t) {
        this.type = t;
    }
}

