/*
 * Decompiled with CFR 0.152.
 */
package BayesianInferences;

import BayesianInferences.BucketTree;
import BayesianNetworks.DiscreteFunction;
import BayesianNetworks.DiscreteVariable;
import BayesianNetworks.ProbabilityVariable;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;

class Bucket {
    BucketTree bucket_tree;
    ProbabilityVariable variable;
    Vector discrete_functions;
    DiscreteFunction backward_pointers;
    DiscreteFunction separator;
    boolean do_produce_clusters;
    DiscreteFunction cluster;
    Vector non_conditioning_variables;
    Vector parents;
    Bucket child;
    int bucket_status = 0;
    private DiscreteFunction[] ordered_dfs;
    private boolean is_ordered_dfs_ready;
    static final int EMPTY = 0;
    static final int REDUCED = 1;
    static final int DISTRIBUTED = 2;

    Bucket(BucketTree bs, ProbabilityVariable pv) {
        this(bs, pv, false);
    }

    Bucket(BucketTree bs, ProbabilityVariable pv, boolean dpc) {
        this.bucket_tree = bs;
        this.variable = pv;
        this.discrete_functions = new Vector();
        this.do_produce_clusters = dpc;
        this.non_conditioning_variables = new Vector();
        this.parents = new Vector();
    }

    void print() {
        this.print(System.out);
    }

    void print(PrintStream out) {
        boolean is_explanation_flag = false;
        if (this.is_explanation()) {
            is_explanation_flag = true;
        }
        if (is_explanation_flag) {
            out.print("MAP");
        }
        out.println("Bucket; variable " + this.variable.get_name() + " with " + this.discrete_functions.size() + " function(s).");
        switch (this.bucket_status) {
            case 0: {
                out.println("Bucket is empty.");
                break;
            }
            case 1: {
                out.println("Bucket has been reduced.");
                break;
            }
            case 2: {
                out.println("Bucket has been distributed.");
            }
        }
        Enumeration e = this.discrete_functions.elements();
        while (e.hasMoreElements()) {
            DiscreteFunction d_f = (DiscreteFunction)e.nextElement();
            d_f.print(out);
        }
        if (is_explanation_flag && this.backward_pointers != null) {
            out.println("Backward pointers:");
            this.backward_pointers.print(out);
        }
        if (this.cluster != null) {
            out.println("Cluster:");
            this.cluster.print(out);
        }
        if (this.separator != null) {
            out.println("Separator:");
            this.separator.print(out);
        }
        if (this.parents.size() > 0) {
            out.println("\tParents:");
            e = this.parents.elements();
            while (e.hasMoreElements()) {
                out.println("\t" + ((Bucket)e.nextElement()).variable.get_name());
            }
        }
        if (this.child != null) {
            out.println("\tChild:");
            out.println("\t" + this.child.variable.get_name());
        }
    }

    void reduce() {
        this.order_dfs();
        if (this.ordered_dfs.length == 0) {
            this.separator = null;
            return;
        }
        DiscreteFunction new_df = this.build_new_function(false);
        if (new_df == null) {
            this.combine();
            this.separator = null;
            return;
        }
        if (this.is_explanation()) {
            this.max_out(new_df);
        } else {
            this.sum_out(new_df);
        }
        this.bucket_status = 1;
        this.separator = new_df;
    }

    DiscreteFunction combine() {
        int j;
        int i;
        int[] indexes = new int[this.bucket_tree.bn.number_variables()];
        int[] value_lengths = new int[this.bucket_tree.bn.number_variables()];
        this.order_dfs();
        if (this.ordered_dfs.length == 0) {
            return null;
        }
        DiscreteFunction new_df = this.build_new_function(true);
        for (i = 0; i < this.bucket_tree.bn.number_variables(); ++i) {
            indexes[i] = 0;
            value_lengths[i] = this.bucket_tree.bn.get_probability_variable(i).number_values();
        }
        for (i = 0; i < new_df.number_values(); ++i) {
            int current;
            double v = 1.0;
            for (int m = 0; m < this.ordered_dfs.length; ++m) {
                v *= this.ordered_dfs[m].evaluate(this.bucket_tree.bn.get_probability_variables(), indexes);
            }
            int p = new_df.get_position_from_indexes(this.bucket_tree.bn.get_probability_variables(), indexes);
            new_df.set_value(p, v);
            int n = new_df.get_index(new_df.number_variables() - 1);
            indexes[n] = indexes[n] + 1;
            for (j = new_df.number_variables() - 1; j > 0 && indexes[current = new_df.get_index(j)] >= value_lengths[current]; --j) {
                indexes[current] = 0;
                int n2 = new_df.get_index(j - 1);
                indexes[n2] = indexes[n2] + 1;
            }
        }
        if (this.is_explanation()) {
            int jump = 1;
            for (i = 1; i < new_df.number_variables(); ++i) {
                jump *= new_df.get_variable(i).number_values();
            }
            j = 0;
            double t = 0.0;
            this.backward_pointers = new DiscreteFunction(1, 1);
            this.backward_pointers.set_variable(0, this.variable);
            for (i = 0; i < this.variable.number_values(); ++i) {
                if (!(new_df.get_value(i) > t)) continue;
                t = new_df.get_value(i * jump);
                j = i;
            }
            this.backward_pointers.set_value(0, j);
        }
        if (this.do_produce_clusters) {
            this.cluster = new_df;
        }
        return new_df;
    }

    void reduce_cluster() {
        if (this.cluster == null) {
            this.bucket_tree.unnormalized_result = null;
            return;
        }
        boolean[] markers = new boolean[this.bucket_tree.bn.number_variables()];
        for (int i = 0; i < markers.length; ++i) {
            markers[i] = true;
        }
        markers[this.variable.get_index()] = false;
        this.bucket_tree.unnormalized_result = this.cluster.sum_out(this.bucket_tree.bn.get_probability_variables(), markers);
    }

    boolean is_explanation() {
        if (this.bucket_tree.explanation_status == 0) {
            return false;
        }
        if (this.bucket_tree.explanation_status == 2) {
            return true;
        }
        return this.variable.is_explanation();
    }

    private void order_dfs() {
        if (this.is_ordered_dfs_ready) {
            return;
        }
        this.is_ordered_dfs_ready = true;
        this.ordered_dfs = new DiscreteFunction[this.discrete_functions.size()];
        for (int i = 0; i < this.ordered_dfs.length; ++i) {
            this.ordered_dfs[i] = (DiscreteFunction)this.discrete_functions.elementAt(i);
        }
    }

    private int join_indexes(boolean[] variable_markers) {
        int i;
        int n = 0;
        for (i = 0; i < variable_markers.length; ++i) {
            variable_markers[i] = false;
        }
        for (i = 0; i < this.ordered_dfs.length; ++i) {
            for (int j = 0; j < this.ordered_dfs[i].number_variables(); ++j) {
                int k = this.ordered_dfs[i].get_index(j);
                if (variable_markers[k]) continue;
                variable_markers[k] = true;
                ++n;
            }
        }
        return n;
    }

    private DiscreteFunction build_new_function(boolean is_bucket_variable_included) {
        int j = 0;
        int v = 1;
        boolean[] variable_markers = new boolean[this.bucket_tree.bn.number_variables()];
        int n = this.join_indexes(variable_markers);
        if (!is_bucket_variable_included) {
            --n;
            variable_markers[this.variable.get_index()] = false;
        }
        if (n == 0) {
            return null;
        }
        int[] joined_indexes = new int[n];
        for (int i = 0; i < variable_markers.length; ++i) {
            if (!variable_markers[i]) continue;
            joined_indexes[j] = i;
            ++j;
            v *= this.bucket_tree.bn.get_probability_variable(i).number_values();
        }
        DiscreteFunction new_df = new DiscreteFunction(n, v);
        this.build_new_variables(new_df, joined_indexes, is_bucket_variable_included, n);
        return new_df;
    }

    private void build_new_variables(DiscreteFunction new_df, int[] joined_indexes, boolean is_bucket_variable_included, int n) {
        if (is_bucket_variable_included) {
            int j = 1;
            for (int i = 0; i < n; ++i) {
                if (joined_indexes[i] == this.variable.get_index()) {
                    new_df.set_variable(0, this.bucket_tree.bn.get_probability_variable(this.variable.get_index()));
                    continue;
                }
                new_df.set_variable(j, this.bucket_tree.bn.get_probability_variable(joined_indexes[i]));
                ++j;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                new_df.set_variable(i, this.bucket_tree.bn.get_probability_variable(joined_indexes[i]));
            }
        }
    }

    private void sum_out(DiscreteFunction new_df) {
        int i;
        int n = this.variable.number_values();
        int[] indexes = new int[this.bucket_tree.bn.number_variables()];
        int[] value_lengths = new int[this.bucket_tree.bn.number_variables()];
        DiscreteVariable[] dvs = this.bucket_tree.bn.get_probability_variables();
        for (i = 0; i < this.bucket_tree.bn.number_variables(); ++i) {
            indexes[i] = 0;
            value_lengths[i] = this.bucket_tree.bn.get_probability_variable(i).number_values();
        }
        if (this.do_produce_clusters) {
            this.cluster = this.build_new_function(true);
        }
        int last = new_df.number_variables() - 1;
        for (i = 0; i < new_df.number_values(); ++i) {
            int current;
            double v = 0.0;
            for (int l = 0; l < n; ++l) {
                indexes[this.variable.get_index()] = l;
                double t = 1.0;
                for (int m = 0; m < this.ordered_dfs.length; ++m) {
                    t *= this.ordered_dfs[m].evaluate(dvs, indexes);
                }
                if (this.do_produce_clusters) {
                    int p_cluster = this.cluster.get_position_from_indexes(dvs, indexes);
                    this.cluster.set_value(p_cluster, t);
                }
                v += t;
            }
            int p = new_df.get_position_from_indexes(dvs, indexes);
            new_df.set_value(p, v);
            int n2 = new_df.get_index(last);
            indexes[n2] = indexes[n2] + 1;
            for (int j = last; j > 0 && indexes[current = new_df.get_index(j)] >= value_lengths[current]; --j) {
                indexes[current] = 0;
                int n3 = new_df.get_index(j - 1);
                indexes[n3] = indexes[n3] + 1;
            }
        }
    }

    private void max_out(DiscreteFunction new_df) {
        int i;
        int n = this.variable.number_values();
        int[] indexes = new int[this.bucket_tree.bn.number_variables()];
        int[] value_lengths = new int[this.bucket_tree.bn.number_variables()];
        double v = 0.0;
        this.create_backward_pointers(new_df);
        for (i = 0; i < this.bucket_tree.bn.number_variables(); ++i) {
            indexes[i] = 0;
            value_lengths[i] = this.bucket_tree.bn.get_probability_variable(i).number_values();
        }
        int last = new_df.number_variables() - 1;
        for (i = 0; i < new_df.number_values(); ++i) {
            int current;
            v = 0.0;
            int u = -1;
            for (int l = 0; l < n; ++l) {
                double t = 1.0;
                indexes[this.variable.get_index()] = l;
                for (int m = 0; m < this.ordered_dfs.length; ++m) {
                    t *= this.ordered_dfs[m].evaluate(this.bucket_tree.bn.get_probability_variables(), indexes);
                }
                if (!(v <= t)) continue;
                v = t;
                u = l;
            }
            int p = new_df.get_position_from_indexes(this.bucket_tree.bn.get_probability_variables(), indexes);
            new_df.set_value(p, v);
            this.backward_pointers.set_value(p, u);
            int n2 = new_df.get_index(last);
            indexes[n2] = indexes[n2] + 1;
            for (int j = last; j > 0 && indexes[current = new_df.get_index(j)] >= value_lengths[current]; --j) {
                indexes[current] = 0;
                int n3 = new_df.get_index(j - 1);
                indexes[n3] = indexes[n3] + 1;
            }
        }
    }

    private void create_backward_pointers(DiscreteFunction new_df) {
        int i;
        DiscreteVariable[] new_df_variables = new DiscreteVariable[new_df.number_variables()];
        double[] new_df_values = new double[new_df.number_values()];
        for (i = 0; i < new_df.number_variables(); ++i) {
            new_df_variables[i] = new_df.get_variable(i);
        }
        for (i = 0; i < new_df.number_values(); ++i) {
            new_df_values[i] = new_df.get_value(i);
        }
        this.backward_pointers = new DiscreteFunction(new_df_variables, new_df_values);
    }
}

