/*
 * Decompiled with CFR 0.152.
 */
package com.edsdev.jconvert.util;

import com.edsdev.jconvert.util.Logger;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.ImageIcon;

public class ResourceManager {
    private static Logger log = Logger.getInstance(ResourceManager.class);

    public static Image getImage(String string) {
        Image image = null;
        try {
            ClassLoader classLoader = ResourceManager.class.getClassLoader();
            image = Toolkit.getDefaultToolkit().getImage(classLoader.getResource(string));
        }
        catch (Exception exception) {
            log.error("Failed to get Image " + string, exception);
        }
        return image;
    }

    public static Properties loadProperties(String string) throws IOException {
        return ResourceManager.loadProperties(ResourceManager.getResourceAsStream(string));
    }

    public static InputStream getResourceAsStream(String string) {
        InputStream inputStream = null;
        ClassLoader classLoader = ResourceManager.class.getClassLoader();
        inputStream = classLoader.getResourceAsStream(string);
        if (inputStream != null) {
            return inputStream;
        }
        classLoader = Thread.currentThread().getContextClassLoader();
        inputStream = classLoader.getResourceAsStream(string);
        if (inputStream != null) {
            return inputStream;
        }
        try {
            inputStream = new FileInputStream(ResourceManager.getJarPath() + string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return inputStream;
    }

    public static String getJarPath() {
        String string = "";
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IOException("Can't load properties file from the inputstream - it is null");
        }
        Properties properties = null;
        Class<ResourceManager> clazz = ResourceManager.class;
        synchronized (ResourceManager.class) {
            try {
                properties = new Properties();
                properties.load(inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {
                log.error("Can't load properties for Input stream", iOException);
                throw iOException;
            }
            return properties;
        }
    }

    public static ImageIcon getImageIcon(String string) {
        ImageIcon imageIcon = null;
        try {
            ClassLoader classLoader = ResourceManager.class.getClassLoader();
            imageIcon = new ImageIcon(classLoader.getResource(string));
        }
        catch (Exception exception) {
            log.error("Could not load image " + string, exception);
        }
        return imageIcon;
    }
}

