/*
 * Decompiled with CFR 0.152.
 */
package com.edsdev.jconvert.util;

import com.edsdev.jconvert.util.Logger;
import com.edsdev.jconvert.util.ResourceManager;
import java.io.FileOutputStream;
import java.util.Properties;

public class JConvertSettingsProperties {
    private static Properties props = null;
    private static final Logger log = Logger.getInstance(JConvertSettingsProperties.class);
    private static final String FILE_NAME = "jconvert_settings.properties";
    public static final String APP_WIDTH = "ApplicationWidth";
    public static final String APP_HEIGHT = "ApplicationHeight";
    public static final String APP_X = "ApplicationX";
    public static final String APP_Y = "ApplicationY";
    public static final String HIDDEN_TABS = "HiddenTabs";
    public static final String LAST_TAB = "LastTab";
    public static final String LAST_VALUE = "LastValue";
    public static final String LAST_FROM = "LastFrom";
    public static final String LAST_TO = "LastTo";
    public static final String LOCALE_LANGUAGE = "LocaleLanguage";
    public static final String LOCALE_COUNTRY = "LocaleCountry";
    public static final String LOCALE_VARIANT = "LocaleVariant";
    public static final String CHECK_FOR_NEWER_VERSION = "CheckForNewerVersion";
    public static final String CUSTOM_CONVERSION_CLASS = "CustomConversionClass";
    public static final String CUSTOM_CONVERSION_JAR = "CustomConversionJar";
    public static final String LOG_LEVEL = "LogLevel";

    private static void setDefaults() {
        JConvertSettingsProperties.setLogLevel("fatal");
    }

    private static String getFilePath() {
        String string = ResourceManager.getJarPath();
        return string + FILE_NAME;
    }

    public static void persist() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(JConvertSettingsProperties.getFilePath());
            props.store(fileOutputStream, "Jconvert Settings File");
        }
        catch (Exception exception) {
            log.error("Failed to save jconvert settings.", exception);
        }
    }

    private JConvertSettingsProperties() {
    }

    public static String getProp(String string) {
        return props.getProperty(string);
    }

    public static String getAppWidth() {
        return props.getProperty(APP_WIDTH);
    }

    public static void setAppWidth(String string) {
        props.setProperty(APP_WIDTH, string);
    }

    public static String getAppHeight() {
        return props.getProperty(APP_HEIGHT);
    }

    public static void setAppHeight(String string) {
        props.setProperty(APP_HEIGHT, string);
    }

    public static String getAppX() {
        return props.getProperty(APP_X);
    }

    public static void setAppX(String string) {
        props.setProperty(APP_X, string);
    }

    public static String getAppY() {
        return props.getProperty(APP_Y);
    }

    public static void setAppY(String string) {
        props.setProperty(APP_Y, string);
    }

    public static String getHiddenTabs() {
        return props.getProperty(HIDDEN_TABS);
    }

    public static void setHiddenTabs(String string) {
        props.setProperty(HIDDEN_TABS, string);
    }

    public static String getLastTab() {
        return props.getProperty(LAST_TAB);
    }

    public static void setLastTab(String string) {
        props.setProperty(LAST_TAB, string);
    }

    public static String getLastValue() {
        return props.getProperty(LAST_VALUE);
    }

    public static void setLastValue(String string) {
        props.setProperty(LAST_VALUE, string);
    }

    public static String getLastFrom() {
        return props.getProperty(LAST_FROM);
    }

    public static void setLastFrom(String string) {
        props.setProperty(LAST_FROM, string);
    }

    public static String getLastTo() {
        return props.getProperty(LAST_TO);
    }

    public static void setLastTo(String string) {
        props.setProperty(LAST_TO, string);
    }

    public static String getLocaleLanguage() {
        return props.getProperty(LOCALE_LANGUAGE);
    }

    public static void setLocaleLanguage(String string) {
        props.setProperty(LOCALE_LANGUAGE, string);
    }

    public static String getLocaleCountry() {
        return props.getProperty(LOCALE_COUNTRY);
    }

    public static void setLocaleCountry(String string) {
        props.setProperty(LOCALE_COUNTRY, string);
    }

    public static String getLocaleVariant() {
        return props.getProperty(LOCALE_VARIANT);
    }

    public static void setLocaleVariant(String string) {
        props.setProperty(LOCALE_VARIANT, string);
    }

    public static String getCheckForNewerVersion() {
        return props.getProperty(CHECK_FOR_NEWER_VERSION);
    }

    public static void setCheckForNewerVersion(String string) {
        props.setProperty(CHECK_FOR_NEWER_VERSION, string);
    }

    public static String getCustomConversionClass() {
        return props.getProperty(CUSTOM_CONVERSION_CLASS);
    }

    public static void setCustomConversionClass(String string) {
        props.setProperty(CUSTOM_CONVERSION_CLASS, string);
    }

    public static String getCustomConversionJar() {
        return props.getProperty(CUSTOM_CONVERSION_JAR);
    }

    public static void setCustomConversionJar(String string) {
        props.setProperty(CUSTOM_CONVERSION_JAR, string);
    }

    public static String getLogLevel() {
        return props.getProperty(LOG_LEVEL);
    }

    public static void setLogLevel(String string) {
        props.setProperty(LOG_LEVEL, string);
    }

    static {
        try {
            props = ResourceManager.loadProperties(FILE_NAME);
            JConvertSettingsProperties.setDefaults();
        }
        catch (Exception exception) {
            props = new Properties();
            JConvertSettingsProperties.setDefaults();
            log.warn("Cannot load settings: jconvert_settings.properties not found.");
        }
    }
}

