/*
 * Decompiled with CFR 0.152.
 */
package com.edsdev.jconvert.presentation.component;

import com.edsdev.jconvert.presentation.component.DocumentSizeFilter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;

public class BaseTextField
extends JTextField {
    private static final long serialVersionUID = 1L;
    private int maxTextLength = -1;
    private String commitedValue;

    public BaseTextField() {
        this.init();
    }

    public BaseTextField(Document document, String string, int n) {
        super(document, string, n);
        this.setText(string);
        this.init();
    }

    public BaseTextField(int n) {
        super(n);
        this.init();
    }

    public BaseTextField(String string, int n) {
        super(string, n);
        this.setText(string);
        this.init();
    }

    public BaseTextField(String string) {
        super(string);
        this.setText(string);
        this.init();
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        this.commitedValue = string;
    }

    public void selectText() {
        if (this.getText() != null) {
            this.setSelectionStart(0);
            this.setSelectionEnd(this.getText().length());
        }
    }

    public void setMaxTextLength(int n) {
        this.maxTextLength = n;
        if (this.getDocument() instanceof AbstractDocument) {
            AbstractDocument abstractDocument = (AbstractDocument)this.getDocument();
            if (abstractDocument.getDocumentFilter() instanceof DocumentSizeFilter) {
                if (n < 0) {
                    abstractDocument.setDocumentFilter(null);
                } else {
                    ((DocumentSizeFilter)abstractDocument.getDocumentFilter()).setMaxCharacters(n);
                }
            } else {
                abstractDocument.setDocumentFilter(new DocumentSizeFilter(n));
            }
        }
    }

    public int getMaxTextLength() {
        return this.maxTextLength;
    }

    private void init() {
        this.commitedValue = this.getText();
        this.enableEvents(4L);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27 && BaseTextField.this.isEnabled()) {
                    BaseTextField.this.setText(BaseTextField.this.commitedValue);
                }
            }
        });
    }

    @Override
    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (focusEvent.isTemporary()) {
            return;
        }
        if (focusEvent.getID() == 1005) {
            this.setText(this.getText());
        }
    }
}

