/*
 * Decompiled with CFR 0.152.
 */
package com.edsdev.jconvert.presentation;

import com.edsdev.jconvert.presentation.AddCustomConversionDlg;
import com.edsdev.jconvert.presentation.ConversionTypeData;
import com.edsdev.jconvert.presentation.ConversionsChangedListener;
import com.edsdev.jconvert.presentation.component.VisibleTabsListCellRenderer;
import com.edsdev.jconvert.util.JConvertSettingsProperties;
import com.edsdev.jconvert.util.Logger;
import com.edsdev.jconvert.util.Messages;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class SettingsDlg
extends JDialog {
    private final int WIDTH = 400;
    private final int HEIGHT = 450;
    private JComboBox cboCountry = new JComboBox(this.getCountries());
    private JComboBox cboLanguage = new JComboBox(this.getLanguages());
    private JTextField txtVariant = new JTextField();
    private JTextField customClassName = new JTextField();
    private JTextField customClassJar = new JTextField();
    private JButton okButton = new JButton(Messages.getResource("okButton"));
    private JButton cancelButton = new JButton(Messages.getResource("cancelButton"));
    private ArrayList listeners = new ArrayList();
    private JScrollPane scrollData = new JScrollPane();
    private JList hiddenTabs = null;
    private List data = null;
    private static final Logger log = Logger.getInstance(AddCustomConversionDlg.class);

    public SettingsDlg(Frame frame, List list) {
        super(frame);
        this.data = list;
        this.setTitle(Messages.getResource("settingsTitle"));
        if (frame != null) {
            int n = frame.getX() + (frame.getWidth() - 400) / 2;
            int n2 = frame.getY() + (frame.getHeight() - 450) / 2;
            if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            this.setBounds(n, n2, 400, 450);
        } else {
            this.setBounds(10, 10, 400, 450);
        }
        this.init();
    }

    private void init() {
        this.getContentPane().setLayout(null);
        this.addLabel(Messages.getResource("country"), 5, 5, 100, 22);
        this.addComponent(this.cboCountry, 110, 5, 200, 22);
        this.cboCountry.setToolTipText("Country this application is used in.");
        this.addLabel(Messages.getResource("language"), 5, 30, 100, 22);
        this.addComponent(this.cboLanguage, 110, 30, 200, 22);
        this.cboLanguage.setToolTipText("Language this application is used in.");
        this.addLabel(Messages.getResource("variant"), 5, 55, 100, 22);
        this.addComponent(this.txtVariant, 110, 55, 200, 22);
        this.txtVariant.setToolTipText("Language variant - 2 characters.");
        this.addLabel("Custom Conversion Class", 5, 80, 130, 22);
        this.addComponent(this.customClassName, 140, 80, 230, 22);
        this.customClassName.setToolTipText("Full name of custom conversion class used.  Place in JConvert directory.");
        this.addLabel("Conversion Jar (optional)", 5, 105, 130, 22);
        this.addComponent(this.customClassJar, 140, 105, 230, 22);
        this.customClassJar.setToolTipText("Name of jar file that conversion class is contained in.  Place in JConvert directory.");
        this.addLabel(Messages.getResource("hiddenTabs"), 5, 130, 100, 22);
        this.hiddenTabs = new JList(this.getTabs());
        this.scrollData.getViewport().add(this.hiddenTabs);
        this.hiddenTabs.setCellRenderer(new VisibleTabsListCellRenderer());
        this.scrollData.setVerticalScrollBarPolicy(20);
        this.addComponent(this.scrollData, 5, 155, 380, 200);
        this.addComponent(this.okButton, 5, 360, 100, 25);
        this.addComponent(this.cancelButton, 110, 360, 100, 25);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsDlg.this.saveData();
                SettingsDlg.this.fireConversionsChanged();
                SettingsDlg.this.closeDialog();
            }
        });
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsDlg.this.closeDialog();
            }
        });
        this.initializeData();
    }

    private void initializeData() {
        String string;
        String string2 = JConvertSettingsProperties.getLocaleCountry();
        if (string2 == null) {
            string2 = Locale.getDefault().getCountry();
        }
        for (int i = 0; i < this.cboCountry.getModel().getSize(); ++i) {
            if (!this.cboCountry.getModel().getElementAt(i).toString().startsWith(string2)) continue;
            this.cboCountry.setSelectedIndex(i);
            break;
        }
        if ((string = JConvertSettingsProperties.getLocaleLanguage()) == null) {
            string = Locale.getDefault().getLanguage();
        }
        for (int i = 0; i < this.cboLanguage.getModel().getSize(); ++i) {
            if (!this.cboLanguage.getModel().getElementAt(i).toString().startsWith(string)) continue;
            this.cboLanguage.setSelectedIndex(i);
            break;
        }
        this.txtVariant.setText(JConvertSettingsProperties.getLocaleVariant());
        this.customClassJar.setText(JConvertSettingsProperties.getCustomConversionJar());
        this.customClassName.setText(JConvertSettingsProperties.getCustomConversionClass());
    }

    private void saveData() {
        Locale locale = Locale.getDefault();
        locale = new Locale(this.cboLanguage.getSelectedItem().toString().substring(0, 2), this.cboCountry.getSelectedItem().toString().substring(0, 2), this.txtVariant.getText());
        Locale.setDefault(locale);
        JConvertSettingsProperties.setCustomConversionClass(this.customClassName.getText());
        JConvertSettingsProperties.setCustomConversionJar(this.customClassJar.getText());
        String string = "";
        for (int i = 0; i < this.hiddenTabs.getModel().getSize(); ++i) {
            if (!this.hiddenTabs.getModel().getElementAt(i).toString().startsWith("x")) continue;
            string = string + "," + this.hiddenTabs.getModel().getElementAt(i).toString().substring(1);
        }
        if (string.length() > 0) {
            string = string.substring(1);
        }
        JConvertSettingsProperties.setHiddenTabs(string);
    }

    private void closeDialog() {
        this.dispose();
    }

    private Vector getCountries() {
        Vector<String> vector = new Vector<String>();
        Locale[] localeArray = Locale.getAvailableLocales();
        for (int i = 0; i < localeArray.length; ++i) {
            if (localeArray[i].getCountry().equals("")) continue;
            vector.add(localeArray[i].getCountry() + " - " + localeArray[i].getDisplayCountry());
        }
        return vector;
    }

    private Vector getLanguages() {
        Vector<String> vector = new Vector<String>();
        Locale[] localeArray = Locale.getAvailableLocales();
        for (int i = 0; i < localeArray.length; ++i) {
            String string = localeArray[i].getLanguage() + " - " + localeArray[i].getDisplayLanguage();
            if (vector.contains(string)) continue;
            vector.add(string);
        }
        return vector;
    }

    private Vector getTabs() {
        Object object2;
        Vector<String> vector = new Vector<String>();
        String string = JConvertSettingsProperties.getHiddenTabs();
        if (string == null) {
            string = "";
        }
        for (Object object2 : this.data) {
            vector.add("o" + ((ConversionTypeData)object2).getTypeName());
        }
        object2 = new StringTokenizer(string, ",");
        while (((StringTokenizer)object2).hasMoreTokens()) {
            String string2 = ((StringTokenizer)object2).nextToken();
            if (!vector.contains("o" + string2)) continue;
            vector.remove("o" + string2);
            vector.add("x" + string2);
        }
        Collections.sort(vector, new Comparator(){

            public int compare(Object object, Object object2) {
                return object.toString().substring(1).compareTo(object2.toString().substring(1));
            }
        });
        return vector;
    }

    public void addConversionsChangedListener(ConversionsChangedListener conversionsChangedListener) {
        this.listeners.add(conversionsChangedListener);
    }

    public void removeConversionsChangedListener(ConversionsChangedListener conversionsChangedListener) {
        this.listeners.remove(conversionsChangedListener);
    }

    private void fireConversionsChanged() {
        for (ConversionsChangedListener conversionsChangedListener : this.listeners) {
            conversionsChangedListener.conversionsUpdated();
        }
    }

    private boolean isEmpty(JTextComponent jTextComponent) {
        String string = jTextComponent.getText();
        return string == null || string.trim().equals("");
    }

    private void displayRequiredError(String string) {
        JOptionPane.showConfirmDialog(this, Messages.getResource("fieldIsRequired", string), Messages.getResource("fieldRequiredTitle"), -1, 0);
    }

    private boolean validComponent(JTextComponent jTextComponent, String string) {
        if (this.isEmpty(jTextComponent)) {
            this.displayRequiredError(string);
            jTextComponent.grabFocus();
            return false;
        }
        return true;
    }

    private void addLabel(String string, int n, int n2, int n3, int n4) {
        JLabel jLabel = new JLabel(string);
        jLabel.setBounds(n, n2, n3, n4);
        this.getContentPane().add(jLabel);
    }

    private void addComponent(Component component, int n, int n2, int n3, int n4) {
        component.setBounds(n, n2, n3, n4);
        this.getContentPane().add(component);
    }
}

