/*
 * Decompiled with CFR 0.152.
 */
package math.jwave.transforms;

import math.jwave.datatypes.Complex;
import math.jwave.transforms.BasicTransform;

public class DiscreteFourierTransform
extends BasicTransform {
    @Override
    public double[] forward(double[] arrTime) {
        int m = arrTime.length;
        double[] arrFreq = new double[m];
        int n = m >> 1;
        for (int i = 0; i < n; ++i) {
            int iR = i * 2;
            int iC = i * 2 + 1;
            arrFreq[iR] = 0.0;
            arrFreq[iC] = 0.0;
            double arg = Math.PI * -2 * (double)i / (double)n;
            for (int k = 0; k < n; ++k) {
                int kR = k * 2;
                int kC = k * 2 + 1;
                double cos = Math.cos((double)k * arg);
                double sin = Math.sin((double)k * arg);
                int n2 = iR;
                arrFreq[n2] = arrFreq[n2] + (arrTime[kR] * cos - arrTime[kC] * sin);
                int n3 = iC;
                arrFreq[n3] = arrFreq[n3] + (arrTime[kR] * sin + arrTime[kC] * cos);
            }
            int n4 = iR;
            arrFreq[n4] = arrFreq[n4] / (double)n;
            int n5 = iC;
            arrFreq[n5] = arrFreq[n5] / (double)n;
        }
        return arrFreq;
    }

    @Override
    public double[] reverse(double[] arrFreq) {
        int m = arrFreq.length;
        double[] arrTime = new double[m];
        int n = m >> 1;
        for (int i = 0; i < n; ++i) {
            int iR = i * 2;
            int iC = i * 2 + 1;
            arrTime[iR] = 0.0;
            arrTime[iC] = 0.0;
            double arg = Math.PI * 2 * (double)i / (double)n;
            for (int k = 0; k < n; ++k) {
                int kR = k * 2;
                int kC = k * 2 + 1;
                double cos = Math.cos((double)k * arg);
                double sin = Math.sin((double)k * arg);
                int n2 = iR;
                arrTime[n2] = arrTime[n2] + (arrFreq[kR] * cos - arrFreq[kC] * sin);
                int n3 = iC;
                arrTime[n3] = arrTime[n3] + (arrFreq[kR] * sin + arrFreq[kC] * cos);
            }
        }
        return arrTime;
    }

    @Override
    public Complex[] forward(Complex[] arrTime) {
        int n = arrTime.length;
        Complex[] arrFreq = new Complex[n];
        for (int i = 0; i < n; ++i) {
            arrFreq[i] = new Complex();
            double arg = Math.PI * -2 * (double)i / (double)n;
            for (int k = 0; k < n; ++k) {
                double cos = Math.cos((double)k * arg);
                double sin = Math.sin((double)k * arg);
                double real = arrTime[k].getReal();
                double imag = arrTime[k].getImag();
                arrFreq[i].addReal(real * cos - imag * sin);
                arrFreq[i].addImag(real * sin + imag * cos);
            }
            arrFreq[i].mulReal(1.0 / (double)n);
            arrFreq[i].mulImag(1.0 / (double)n);
        }
        return arrFreq;
    }

    @Override
    public Complex[] reverse(Complex[] arrFreq) {
        int n = arrFreq.length;
        Complex[] arrTime = new Complex[n];
        for (int i = 0; i < n; ++i) {
            arrTime[i] = new Complex();
            double arg = Math.PI * 2 * (double)i / (double)n;
            for (int k = 0; k < n; ++k) {
                double cos = Math.cos((double)k * arg);
                double sin = Math.sin((double)k * arg);
                double real = arrFreq[k].getReal();
                double imag = arrFreq[k].getImag();
                arrTime[i].addReal(real * cos - imag * sin);
                arrTime[i].addImag(real * sin + imag * cos);
            }
        }
        return arrTime;
    }

    @Override
    public double[][] forward(double[][] matTime) {
        return null;
    }

    @Override
    public double[][] reverse(double[][] matFreq) {
        return null;
    }

    @Override
    public double[][][] forward(double[][][] spcTime) {
        return null;
    }

    @Override
    public double[][][] reverse(double[][][] spcHilb) {
        return null;
    }
}

