/*
 * Decompiled with CFR 0.152.
 */
package math.jwave.transforms;

import math.jwave.datatypes.Complex;

public abstract class BasicTransform {
    public abstract double[] forward(double[] var1);

    public abstract double[] reverse(double[] var1);

    public Complex[] forward(Complex[] arrTime) {
        return null;
    }

    public Complex[] reverse(Complex[] arrFreq) {
        return null;
    }

    public double[][] forward(double[][] matTime) {
        double[] arrHilb;
        double[] arrTime;
        int noOfRows = matTime.length;
        int noOfCols = matTime[0].length;
        double[][] matHilb = new double[noOfRows][noOfCols];
        for (int i = 0; i < noOfRows; ++i) {
            arrTime = new double[noOfCols];
            for (int j = 0; j < noOfCols; ++j) {
                arrTime[j] = matTime[i][j];
            }
            arrHilb = this.forward(arrTime);
            for (int j = 0; j < noOfCols; ++j) {
                matHilb[i][j] = arrHilb[j];
            }
        }
        for (int j = 0; j < noOfCols; ++j) {
            arrTime = new double[noOfRows];
            for (int i = 0; i < noOfRows; ++i) {
                arrTime[i] = matHilb[i][j];
            }
            arrHilb = this.forward(arrTime);
            for (int i = 0; i < noOfRows; ++i) {
                matHilb[i][j] = arrHilb[i];
            }
        }
        return matHilb;
    }

    public double[][] reverse(double[][] matFreq) {
        double[] arrTime;
        double[] arrFreq;
        int noOfRows = matFreq.length;
        int noOfCols = matFreq[0].length;
        double[][] matTime = new double[noOfRows][noOfCols];
        for (int j = 0; j < noOfCols; ++j) {
            arrFreq = new double[noOfRows];
            for (int i = 0; i < noOfRows; ++i) {
                arrFreq[i] = matFreq[i][j];
            }
            arrTime = this.reverse(arrFreq);
            for (int i = 0; i < noOfRows; ++i) {
                matTime[i][j] = arrTime[i];
            }
        }
        for (int i = 0; i < noOfRows; ++i) {
            arrFreq = new double[noOfCols];
            for (int j = 0; j < noOfCols; ++j) {
                arrFreq[j] = matTime[i][j];
            }
            arrTime = this.reverse(arrFreq);
            for (int j = 0; j < noOfCols; ++j) {
                matTime[i][j] = arrTime[j];
            }
        }
        return matTime;
    }

    public double[][][] forward(double[][][] spcTime) {
        int noOfRows = spcTime.length;
        int noOfCols = spcTime[0].length;
        int noOfHigh = spcTime[0][0].length;
        double[][][] spcHilb = new double[noOfRows][noOfCols][noOfHigh];
        for (int i = 0; i < noOfRows; ++i) {
            double[][] matTime = new double[noOfCols][noOfHigh];
            for (int j = 0; j < noOfCols; ++j) {
                for (int k = 0; k < noOfHigh; ++k) {
                    matTime[j][k] = spcTime[i][j][k];
                }
            }
            double[][] matHilb = this.forward(matTime);
            for (int j = 0; j < noOfCols; ++j) {
                for (int k = 0; k < noOfHigh; ++k) {
                    spcHilb[i][j][k] = matHilb[j][k];
                }
            }
        }
        for (int j = 0; j < noOfCols; ++j) {
            for (int k = 0; k < noOfHigh; ++k) {
                double[] arrTime = new double[noOfRows];
                for (int i = 0; i < noOfRows; ++i) {
                    arrTime[i] = spcHilb[i][j][k];
                }
                double[] arrHilb = this.forward(arrTime);
                for (int i = 0; i < noOfRows; ++i) {
                    spcHilb[i][j][k] = arrHilb[i];
                }
            }
        }
        return spcHilb;
    }

    public double[][][] reverse(double[][][] spcHilb) {
        int noOfRows = spcHilb.length;
        int noOfCols = spcHilb[0].length;
        int noOfHigh = spcHilb[0][0].length;
        double[][][] spcTime = new double[noOfRows][noOfCols][noOfHigh];
        for (int i = 0; i < noOfRows; ++i) {
            double[][] matHilb = new double[noOfCols][noOfHigh];
            for (int j = 0; j < noOfCols; ++j) {
                for (int k = 0; k < noOfHigh; ++k) {
                    matHilb[j][k] = spcHilb[i][j][k];
                }
            }
            double[][] matTime = this.reverse(matHilb);
            for (int j = 0; j < noOfCols; ++j) {
                for (int k = 0; k < noOfHigh; ++k) {
                    spcTime[i][j][k] = matTime[j][k];
                }
            }
        }
        for (int j = 0; j < noOfCols; ++j) {
            for (int k = 0; k < noOfHigh; ++k) {
                double[] arrHilb = new double[noOfRows];
                for (int i = 0; i < noOfRows; ++i) {
                    arrHilb[i] = spcTime[i][j][k];
                }
                double[] arrTime = this.reverse(arrHilb);
                for (int i = 0; i < noOfRows; ++i) {
                    spcTime[i][j][k] = arrTime[i];
                }
            }
        }
        return spcTime;
    }
}

