/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time.daycount;

import java.util.Calendar;
import java.util.GregorianCalendar;
import net.finmath.time.daycount.DayCountConvention_ACT;

public class DayCountConvention_ACT_ACT_ISDA
extends DayCountConvention_ACT {
    private final boolean isCountLastDayNotFirst;

    public DayCountConvention_ACT_ACT_ISDA(boolean bl) {
        this.isCountLastDayNotFirst = bl;
    }

    public DayCountConvention_ACT_ACT_ISDA() {
        this(false);
    }

    @Override
    public double getDaycountFraction(Calendar calendar, Calendar calendar2) {
        if (calendar.after(calendar2)) {
            return -this.getDaycountFraction(calendar2, calendar);
        }
        double d = (double)(calendar2.get(1) - calendar.get(1)) - 1.0;
        GregorianCalendar gregorianCalendar = (GregorianCalendar)calendar.clone();
        gregorianCalendar.set(6, 1);
        gregorianCalendar.add(1, 1);
        if (this.isCountLastDayNotFirst) {
            gregorianCalendar.add(6, -1);
        }
        d += this.getDaycount(calendar, gregorianCalendar) / (double)calendar.getActualMaximum(6);
        GregorianCalendar gregorianCalendar2 = (GregorianCalendar)calendar2.clone();
        gregorianCalendar2.set(6, 1);
        if (this.isCountLastDayNotFirst) {
            gregorianCalendar2.add(6, -1);
        }
        return Math.max(d += this.getDaycount(gregorianCalendar2, calendar2) / (double)calendar2.getActualMaximum(6), 0.0);
    }

    public String toString() {
        return "DayCountConvention_ACT_ACT_ISDA [isCountLastDayNotFirst=" + this.isCountLastDayNotFirst + "]";
    }
}

