/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time.daycount;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import net.finmath.time.daycount.DayCountConventionInterface;
import net.finmath.time.daycount.DayCountConvention_30E_360;
import net.finmath.time.daycount.DayCountConvention_30E_360_ISDA;
import net.finmath.time.daycount.DayCountConvention_30U_360;
import net.finmath.time.daycount.DayCountConvention_ACT_360;
import net.finmath.time.daycount.DayCountConvention_ACT_365;
import net.finmath.time.daycount.DayCountConvention_ACT_ACT_ISDA;
import net.finmath.time.daycount.DayCountConvention_ACT_ACT_YEARFRAC;

public class DayCountConventionFactory {
    public static DayCountConventionInterface getDayCountConvention(String string) {
        if (string.compareToIgnoreCase("act/act isda") == 0) {
            return new DayCountConvention_ACT_ACT_ISDA();
        }
        if (string.compareToIgnoreCase("30/360") == 0) {
            return new DayCountConvention_30E_360_ISDA();
        }
        if (string.compareToIgnoreCase("30e/360") == 0) {
            return new DayCountConvention_30E_360();
        }
        if (string.compareToIgnoreCase("30u/360") == 0) {
            return new DayCountConvention_30U_360();
        }
        if (string.compareToIgnoreCase("act/360") == 0) {
            return new DayCountConvention_ACT_360();
        }
        if (string.compareToIgnoreCase("act/365") == 0) {
            return new DayCountConvention_ACT_365();
        }
        if (string.compareToIgnoreCase("act/act yearfrac") == 0) {
            return new DayCountConvention_ACT_ACT_YEARFRAC();
        }
        throw new IllegalArgumentException("Unknow day count convention: " + string);
    }

    public static double getDaycount(Date date, Date date2, String string) {
        DayCountConventionInterface dayCountConventionInterface = DayCountConventionFactory.getDayCountConvention(string);
        return dayCountConventionInterface.getDaycount(DayCountConventionFactory.getCalendarForData(date), DayCountConventionFactory.getCalendarForData(date2));
    }

    public static double getDaycountFraction(Date date, Date date2, String string) {
        DayCountConventionInterface dayCountConventionInterface = DayCountConventionFactory.getDayCountConvention(string);
        return dayCountConventionInterface.getDaycountFraction(DayCountConventionFactory.getCalendarForData(date), DayCountConventionFactory.getCalendarForData(date2));
    }

    public static Calendar getCalendarForData(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }
}

